/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.TagFilter;
import com.gregtechceu.gtceu.utils.TagExprFilter;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TagItemFilter
extends TagFilter<ItemStack, ItemFilter>
implements ItemFilter {
    private final Object2BooleanMap<Item> cache = new Object2BooleanOpenHashMap();

    protected TagItemFilter() {
    }

    public static TagItemFilter loadFilter(ItemStack itemStack) {
        return TagItemFilter.loadFilter(Objects.requireNonNullElseGet(itemStack.m_41783_(), CompoundTag::new), filter -> itemStack.m_41751_(filter.saveFilter()));
    }

    private static TagItemFilter loadFilter(CompoundTag tag, Consumer<ItemFilter> itemWriter) {
        TagItemFilter handler = new TagItemFilter();
        handler.itemWriter = itemWriter;
        handler.oreDictFilterExpression = tag.m_128461_("oreDict");
        handler.matchExpr = null;
        handler.cache.clear();
        handler.matchExpr = TagExprFilter.parseExpression(handler.oreDictFilterExpression);
        return handler;
    }

    @Override
    public void setOreDict(String oreDict) {
        this.cache.clear();
        super.setOreDict(oreDict);
    }

    @Override
    public boolean test(ItemStack itemStack) {
        if (this.oreDictFilterExpression.isEmpty()) {
            return false;
        }
        if (this.cache.containsKey((Object)itemStack.m_41720_())) {
            return this.cache.getOrDefault((Object)itemStack.m_41720_(), false);
        }
        if (TagExprFilter.tagsMatch(this.matchExpr, itemStack)) {
            this.cache.put((Object)itemStack.m_41720_(), true);
            return true;
        }
        this.cache.put((Object)itemStack.m_41720_(), false);
        return false;
    }

    @Override
    public int testItemCount(ItemStack itemStack) {
        return this.test(itemStack) ? Integer.MAX_VALUE : 0;
    }

    @Override
    public boolean supportsAmounts() {
        return false;
    }
}

