/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.component;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemDecoratorComponent;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.gregtechceu.gtceu.client.renderer.item.ToolChargeBarRenderer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ElectricStats
implements IInteractionItem,
ISubItemHandler,
IAddInformation,
IItemLifeCycle,
IComponentCapability,
IItemDecoratorComponent {
    public static final ElectricStats EMPTY = ElectricStats.create(0L, 0, false, false);
    public final long maxCharge;
    public final int tier;
    public final boolean chargeable;
    public final boolean dischargeable;

    protected ElectricStats(long maxCharge, int tier, boolean chargeable, boolean dischargeable) {
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.chargeable = chargeable;
        this.dischargeable = dischargeable;
    }

    public static ElectricStats create(long maxCharge, int tier, boolean chargeable, boolean dischargeable) {
        return new ElectricStats(maxCharge, tier, chargeable, dischargeable);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(ItemStack itemStack, @NotNull Capability<T> capability) {
        return GTCapability.CAPABILITY_ELECTRIC_ITEM.orEmpty(capability, LazyOptional.of(() -> new ElectricItem(itemStack, this.maxCharge, this.tier, this.chargeable, this.dischargeable)));
    }

    public static float getStoredPredicate(ItemStack itemStack) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
        if (electricItem != null) {
            long per = electricItem.getCharge() * 7L / electricItem.getMaxCharge();
            return (float)per / 100.0f;
        }
        return 0.0f;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
        if (electricItem != null && electricItem.canProvideChargeExternally() && player.m_6144_()) {
            if (!level.f_46443_) {
                boolean isInDischargeMode = ElectricStats.isInDischargeMode(itemStack);
                String locale = "metaitem.electric.discharge_mode." + (isInDischargeMode ? "disabled" : "enabled");
                player.m_5661_((Component)Component.m_237115_((String)locale), true);
                ElectricStats.setInDischargeMode(itemStack, !isInDischargeMode);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (electricItem != null && electricItem.canProvideChargeExternally() && ElectricStats.isInDischargeMode(stack) && electricItem.getCharge() > 0L) {
                long chargedAmount;
                ItemStack itemInSlot;
                int i;
                long transferLimit = electricItem.getTransferLimit();
                if (GTCEu.Mods.isCuriosLoaded()) {
                    IItemHandler curios = CuriosApi.getCuriosInventory((LivingEntity)player).map(ICuriosItemHandler::getEquippedCurios).orElse(EmptyHandler.INSTANCE);
                    for (i = 0; i < curios.getSlots(); ++i) {
                        itemInSlot = curios.getStackInSlot(i);
                        chargedAmount = ElectricStats.chargeItemStack(transferLimit, electricItem, itemInSlot);
                        if (chargedAmount > 0L) {
                            transferLimit -= chargedAmount;
                        }
                        if (transferLimit == 0L) break;
                    }
                }
                Inventory inventoryPlayer = player.m_150109_();
                for (i = 0; i < inventoryPlayer.m_6643_(); ++i) {
                    itemInSlot = inventoryPlayer.m_8020_(i);
                    chargedAmount = ElectricStats.chargeItemStack(transferLimit, electricItem, itemInSlot);
                    if (chargedAmount > 0L) {
                        transferLimit -= chargedAmount;
                    }
                    if (transferLimit == 0L) break;
                }
            }
        }
    }

    private static long chargeItemStack(long maxDischargeAmount, IElectricItem source, ItemStack target) {
        IEnergyStorage feEnergyItem;
        IElectricItem slotElectricItem = GTCapabilityHelper.getElectricItem(target);
        if (slotElectricItem != null && !slotElectricItem.canProvideChargeExternally()) {
            return ElectricStats.chargeElectricItem(maxDischargeAmount, source, slotElectricItem);
        }
        if (ConfigHolder.INSTANCE.compat.energy.nativeEUToFE && (feEnergyItem = GTCapabilityHelper.getForgeEnergyItem(target)) != null && feEnergyItem.canReceive() && feEnergyItem.getEnergyStored() < feEnergyItem.getMaxEnergyStored()) {
            return ElectricStats.chargeForgeEnergyItem(maxDischargeAmount, source, feEnergyItem);
        }
        return 0L;
    }

    private static long chargeElectricItem(long maxDischargeAmount, IElectricItem source, IElectricItem target) {
        long maxDischarged = source.discharge(maxDischargeAmount, source.getTier(), false, false, true);
        long maxReceived = target.charge(maxDischarged, source.getTier(), false, true);
        if (maxReceived > 0L) {
            long resultDischarged = source.discharge(maxReceived, source.getTier(), false, true, false);
            target.charge(resultDischarged, source.getTier(), false, false);
            return resultDischarged;
        }
        return 0L;
    }

    private static long chargeForgeEnergyItem(long maxDischargeAmount, IElectricItem source, IEnergyStorage target) {
        long maxDischarged = source.discharge(maxDischargeAmount, source.getTier(), false, true, true);
        long received = FeCompat.insertEu(target, maxDischarged, false);
        if (received > 0L) {
            source.discharge(received, source.getTier(), false, true, false);
            return received;
        }
        return 0L;
    }

    private static void setInDischargeMode(ItemStack itemStack, boolean isDischargeMode) {
        CompoundTag tagCompound = itemStack.m_41784_();
        if (isDischargeMode) {
            tagCompound.m_128379_("DischargeMode", true);
        } else {
            tagCompound.m_128473_("DischargeMode");
            if (tagCompound.m_128456_()) {
                itemStack.m_41751_(null);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem == null) {
            return;
        }
        ElectricStats.addCurrentChargeTooltip(tooltipComponents, electricItem.getCharge(), electricItem.getMaxCharge(), electricItem.getTier(), electricItem.canProvideChargeExternally());
        if (electricItem.canProvideChargeExternally()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"metaitem.electric.discharge_mode.tooltip"));
        }
    }

    public static void addCurrentChargeTooltip(List<Component> tooltip, long currentCharge, long maxCharge, int tier, boolean showTimeRemaining) {
        double percentage = (double)currentCharge / (double)maxCharge;
        Instant start = Instant.now();
        Instant current = Instant.now().plusSeconds((long)((double)currentCharge * 1.0 / (double)GTValues.V[tier] / 20.0));
        Instant max = Instant.now().plusSeconds((long)((double)maxCharge * 1.0 / (double)GTValues.V[tier] / 20.0));
        Duration durationCurrent = Duration.between(start, current);
        Duration durationMax = Duration.between(start, max);
        ChatFormatting color = ChatFormatting.RED;
        if (percentage > 0.5) {
            color = ChatFormatting.GREEN;
        } else if (percentage > 0.3) {
            color = ChatFormatting.YELLOW;
        }
        if (showTimeRemaining) {
            MutableComponent unit;
            long currentChargeTime;
            long maxChargeTime;
            if (durationCurrent.getSeconds() <= 60L) {
                maxChargeTime = durationMax.getSeconds();
                currentChargeTime = durationCurrent.toSeconds();
                unit = Component.m_237115_((String)"item.gtceu.battery.charge_unit.second");
            } else if (durationCurrent.toMinutes() <= 60L) {
                maxChargeTime = durationMax.toMinutes();
                currentChargeTime = durationCurrent.toMinutes();
                unit = Component.m_237115_((String)"item.gtceu.battery.charge_unit.minute");
            } else {
                maxChargeTime = durationMax.toHours();
                currentChargeTime = durationCurrent.toHours();
                unit = Component.m_237115_((String)"item.gtceu.battery.charge_unit.hour");
            }
            tooltip.add((Component)Component.m_237110_((String)"item.gtceu.battery.charge_detailed", (Object[])new Object[]{FormattingUtil.formatNumbers(currentCharge), FormattingUtil.formatNumbers(maxCharge), GTValues.VNF[tier], FormattingUtil.formatNumbers(currentChargeTime), FormattingUtil.formatNumbers(maxChargeTime), unit}).m_130940_(color));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"metaitem.generic.electric_item.tooltip", (Object[])new Object[]{FormattingUtil.formatNumbers(currentCharge), FormattingUtil.formatNumbers(maxCharge), GTValues.VNF[tier]}).m_130940_(color));
        }
    }

    private static boolean isInDischargeMode(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        return tagCompound != null && tagCompound.m_128471_("DischargeMode");
    }

    @Override
    public void fillItemCategory(Item item, CreativeModeTab category, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((ItemLike)item));
        ItemStack stack = new ItemStack((ItemLike)item);
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem != null) {
            electricItem.charge(electricItem.getMaxCharge(), electricItem.getTier(), true, false);
            items.add((Object)stack);
        }
    }

    public static ElectricStats createElectricItem(long maxCharge, int tier) {
        return ElectricStats.create(maxCharge, tier, true, false);
    }

    public static ElectricStats createRechargeableBattery(long maxCharge, int tier) {
        return ElectricStats.create(maxCharge, tier, true, true);
    }

    public static ElectricStats createBattery(long maxCharge, int tier, boolean rechargeable) {
        return ElectricStats.create(maxCharge, tier, rechargeable, true);
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (electricItem != null) {
            return ToolChargeBarRenderer.renderElectricBar(guiGraphics, electricItem.getCharge(), electricItem.getMaxCharge(), xOffset, yOffset, stack.m_150947_());
        }
        return false;
    }
}

