/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.jetbrains.annotations.NotNull;

public interface IRotorHolderMachine
extends IMultiPart {
    public static final int SPEED_INCREMENT = 1;
    public static final int SPEED_DECREMENT = 3;
    public static final BooleanProperty HAS_ROTOR_PROPERTY = GTMachineModelProperties.HAS_ROTOR;
    public static final BooleanProperty ROTOR_SPINNING_PROPERTY = GTMachineModelProperties.IS_ROTOR_SPINNING;
    public static final BooleanProperty EMISSIVE_ROTOR_PROPERTY = GTMachineModelProperties.IS_EMISSIVE_ROTOR;

    public static int getBaseEfficiency() {
        return 100;
    }

    @NotNull
    public Material getRotorMaterial();

    public ItemStack getRotorStack();

    public void setRotorStack(ItemStack var1);

    public int getRotorSpeed();

    public void setRotorSpeed(int var1);

    public int getMaxRotorHolderSpeed();

    public int getTierDifference();

    default public int getHolderEfficiency() {
        int tierDifference = this.getTierDifference();
        if (tierDifference == -1) {
            return -1;
        }
        return 100 + 10 * tierDifference;
    }

    default public int getHolderPowerMultiplier() {
        int tierDifference = this.getTierDifference();
        if (tierDifference == -1) {
            return -1;
        }
        return (int)Math.pow(2.0, this.getTierDifference());
    }

    default public boolean hasRotor() {
        return TurbineRotorBehaviour.getBehaviour(this.getRotorStack()) != null;
    }

    default public int getRotorEfficiency() {
        ItemStack stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            return behavior.getRotorEfficiency(stack);
        }
        return -1;
    }

    default public int getRotorPower() {
        ItemStack stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            return behavior.getRotorPower(stack);
        }
        return -1;
    }

    default public int getRotorDurabilityPercent() {
        ItemStack stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            return behavior.getRotorDurabilityPercent(stack);
        }
        return -1;
    }

    default public void damageRotor(int damageAmount) {
        ItemStack stack = this.getRotorStack();
        TurbineRotorBehaviour behavior = TurbineRotorBehaviour.getBehaviour(stack);
        if (behavior != null) {
            behavior.applyRotorDamage(stack, damageAmount);
            this.setRotorStack(stack);
        }
    }

    default public boolean isFrontFaceFree() {
        Direction facing = this.self().getFrontFacing();
        Direction up = facing.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        BlockPos pos = this.self().getPos();
        Level level = this.self().getLevel();
        for (int dLeft = -1; dLeft < 2; ++dLeft) {
            for (int dUp = -1; dUp < 2; ++dUp) {
                BlockPos checkPos = RelativeDirection.offsetPos(pos, facing, up, false, dUp, dLeft, 1);
                if (level.m_8055_(checkPos).m_60795_()) continue;
                return false;
            }
        }
        return true;
    }

    default public int getTotalEfficiency() {
        int rotorEfficiency = this.getRotorEfficiency();
        if (rotorEfficiency == -1) {
            return -1;
        }
        int holderEfficiency = this.getHolderEfficiency();
        if (holderEfficiency == -1) {
            return -1;
        }
        return Math.max(IRotorHolderMachine.getBaseEfficiency(), rotorEfficiency * holderEfficiency / 100);
    }

    default public int getTotalPower() {
        return this.getHolderPowerMultiplier() * this.getRotorPower();
    }

    default public boolean isRotorSpinning() {
        return this.getRotorSpeed() > 0;
    }

    @Override
    default public GTRecipe modifyRecipe(GTRecipe recipe) {
        if (!this.isFrontFaceFree() || !this.hasRotor()) {
            return null;
        }
        return IMultiPart.super.modifyRecipe(recipe);
    }

    @Override
    default public void attachFancyTooltipsToController(IMultiController controller, TooltipsPanel tooltipsPanel) {
        this.attachTooltips(tooltipsPanel);
    }

    @Override
    default public void attachTooltips(TooltipsPanel tooltipsPanel) {
        tooltipsPanel.attachTooltips(new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.m_237115_((String)"gtceu.multiblock.universal.rotor_obstructed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))), () -> !this.isFrontFaceFree(), () -> null));
    }
}

