/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern.error;

import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SinglePredicateError
extends PatternError {
    public final SimplePredicate predicate;
    public final int type;

    public SinglePredicateError(SimplePredicate predicate, int type) {
        this.predicate = predicate;
        this.type = type;
    }

    @Override
    public List<List<ItemStack>> getCandidates() {
        return Collections.singletonList(this.predicate.getCandidates());
    }

    @Override
    public Component getErrorInfo() {
        int number = -1;
        if (this.type == 0) {
            number = this.predicate.maxCount;
        }
        if (this.type == 1) {
            number = this.predicate.minCount;
        }
        if (this.type == 2) {
            number = this.predicate.maxLayerCount;
        }
        if (this.type == 3) {
            number = this.predicate.minLayerCount;
        }
        return Component.m_237110_((String)("gtceu.multiblock.pattern.error.limited." + this.type), (Object[])new Object[]{number});
    }
}

