/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern.predicates;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.error.SinglePredicateError;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SimplePredicate {
    public static SimplePredicate ANY = new SimplePredicate("any", x -> true, null);
    public static SimplePredicate AIR = new SimplePredicate("air", blockWorldState -> blockWorldState.getWorld().m_46859_(blockWorldState.getPos()), null);
    @Nullable
    public Supplier<BlockInfo[]> candidates;
    public Predicate<MultiblockState> predicate;
    public List<Component> toolTips;
    public int minCount = -1;
    public int maxCount = -1;
    public int minLayerCount = -1;
    public int maxLayerCount = -1;
    public int previewCount = -1;
    public boolean disableRenderFormed = false;
    public IO io = IO.BOTH;
    public String slotName;
    public String nbtParser;
    public final String type;

    public SimplePredicate() {
        this("unknown");
    }

    public SimplePredicate(String type) {
        this.type = type;
    }

    public SimplePredicate(Predicate<MultiblockState> predicate, @Nullable Supplier<BlockInfo[]> candidates) {
        this();
        this.predicate = predicate;
        this.candidates = candidates;
    }

    public SimplePredicate(String type, Predicate<MultiblockState> predicate, @Nullable Supplier<BlockInfo[]> candidates) {
        this(type);
        this.predicate = predicate;
        this.candidates = candidates;
    }

    public SimplePredicate buildPredicate() {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getToolTips(TraceabilityPredicate predicates) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (this.toolTips != null) {
            result.addAll(this.toolTips);
        }
        if (this.minCount == this.maxCount && this.maxCount != -1) {
            result.add((Component)Component.m_237110_((String)"gtceu.multiblock.pattern.error.limited_exact", (Object[])new Object[]{this.minCount}));
        } else if (this.minCount != this.maxCount && this.minCount != -1 && this.maxCount != -1) {
            result.add((Component)Component.m_237110_((String)"gtceu.multiblock.pattern.error.limited_within", (Object[])new Object[]{this.minCount, this.maxCount}));
        } else {
            if (this.minCount != -1) {
                result.add((Component)LangHandler.getFromMultiLang("gtceu.multiblock.pattern.error.limited", 1, this.minCount));
            }
            if (this.maxCount != -1) {
                result.add((Component)LangHandler.getFromMultiLang("gtceu.multiblock.pattern.error.limited", 0, this.maxCount));
            }
        }
        if (predicates == null) {
            return result;
        }
        if (predicates.isSingle()) {
            result.add((Component)Component.m_237115_((String)"gtceu.multiblock.pattern.single"));
        }
        if (predicates.hasAir()) {
            result.add((Component)Component.m_237115_((String)"gtceu.multiblock.pattern.replaceable_air"));
        }
        return result;
    }

    public boolean test(MultiblockState blockWorldState) {
        if (this.predicate.test(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    public boolean testLimited(MultiblockState blockWorldState) {
        if (this.testGlobal(blockWorldState) && this.testLayer(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    private boolean checkInnerConditions(MultiblockState blockWorldState) {
        if (this.disableRenderFormed) {
            blockWorldState.getMatchContext().getOrCreate("renderMask", LongOpenHashSet::new).add(blockWorldState.getPos().m_121878_());
        }
        if (this.io != IO.BOTH) {
            if (blockWorldState.io == IO.BOTH) {
                blockWorldState.io = this.io;
            } else if (blockWorldState.io != this.io) {
                blockWorldState.io = null;
            }
        }
        if (this.nbtParser != null && !blockWorldState.world.f_46443_) {
            BlockEntity te = blockWorldState.getTileEntity();
            if (te != null) {
                CompoundTag nbt = te.m_187480_();
                if (Pattern.compile(this.nbtParser).matcher(nbt.toString()).find()) {
                    return true;
                }
            }
            blockWorldState.setError(new PatternStringError("The NBT fails to match"));
            return false;
        }
        if (this.slotName != null) {
            Long2ObjectMap slots = (Long2ObjectMap)blockWorldState.getMatchContext().getOrCreate("slots", Long2ObjectArrayMap::new);
            ((Set)slots.computeIfAbsent(blockWorldState.getPos().m_121878_(), s -> new HashSet())).add(this.slotName);
            return true;
        }
        return true;
    }

    public boolean testGlobal(MultiblockState blockWorldState) {
        if (this.minCount == -1 && this.maxCount == -1) {
            return true;
        }
        boolean base = this.predicate.test(blockWorldState);
        int count = blockWorldState.getGlobalCount().mergeInt((Object)this, base ? 1 : 0, Integer::sum);
        if (this.maxCount == -1 || count <= this.maxCount) {
            return base;
        }
        blockWorldState.setError(new SinglePredicateError(this, 0));
        return false;
    }

    public boolean testLayer(MultiblockState blockWorldState) {
        if (this.minLayerCount == -1 && this.maxLayerCount == -1) {
            return true;
        }
        boolean base = this.predicate.test(blockWorldState);
        int count = blockWorldState.getLayerCount().mergeInt((Object)this, base ? 1 : 0, Integer::sum);
        if (this.maxLayerCount == -1 || count <= this.maxLayerCount) {
            return base;
        }
        blockWorldState.setError(new SinglePredicateError(this, 2));
        return false;
    }

    public List<ItemStack> getCandidates() {
        if (GTCEu.isClientSide()) {
            return this.candidates == null ? Collections.emptyList() : Arrays.stream(this.candidates.get()).filter(info -> info.getBlockState().m_60734_() != Blocks.f_50016_).map(blockInfo -> blockInfo.getItemStackForm((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_)).collect(Collectors.toList());
        }
        return this.candidates == null ? Collections.emptyList() : Arrays.stream(this.candidates.get()).filter(info -> info.getBlockState().m_60734_() != Blocks.f_50016_).map(BlockInfo::getItemStackForm).collect(Collectors.toList());
    }
}

