/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.placeholder;

import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class MultiLineComponent
extends ArrayList<MutableComponent> {
    private boolean ignoreSpaces = false;

    public MultiLineComponent(List<MutableComponent> components) {
        this.addAll(components);
    }

    public static MultiLineComponent of(Component c) {
        return new MultiLineComponent(List.of(c.m_6881_()));
    }

    public static MultiLineComponent literal(String s) {
        return MultiLineComponent.of((Component)Component.m_237113_((String)s));
    }

    public static MultiLineComponent literal(long n) {
        return MultiLineComponent.literal(String.valueOf(n));
    }

    public static MultiLineComponent literal(double n) {
        return MultiLineComponent.literal(String.valueOf(n));
    }

    public static MultiLineComponent empty() {
        return MultiLineComponent.of(CommonComponents.f_237098_);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MultiLineComponent) {
            return Objects.equals(this.toString(), o.toString());
        }
        return false;
    }

    public boolean equalsString(String s) {
        return Objects.equals(this.toString(), s);
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.isEmpty()) {
            return out.toString();
        }
        for (Component component : this) {
            out.append(component.getString());
            out.append('\n');
        }
        return out.substring(0, out.length() - 1);
    }

    public double toDouble() {
        if (this.isEmpty()) {
            return 0.0;
        }
        if (this.size() > 1) {
            throw new NumberFormatException(this.toString());
        }
        return Double.parseDouble(((MutableComponent)this.get(0)).getString());
    }

    public int toInt() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.size() > 1) {
            throw new NumberFormatException(this.toString());
        }
        return Integer.parseInt(((MutableComponent)this.get(0)).getString());
    }

    public void append(@Nullable String s) {
        if (s != null) {
            GTUtil.getLast(this).m_130946_(s);
        }
    }

    public void append(char c) {
        this.append(String.valueOf(c));
    }

    public MultiLineComponent append(@Nullable List<? extends Component> lines) {
        if (lines == null) {
            return this;
        }
        if (lines.isEmpty()) {
            return this;
        }
        for (Component component : lines) {
            GTUtil.getLast(this).m_7220_(component);
            this.add(MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_));
        }
        this.remove(this.size() - 1);
        return this;
    }

    public void appendNewline() {
        this.add(MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_));
    }

    public MultiLineComponent withStyle(Style style) {
        MultiLineComponent out = MultiLineComponent.empty();
        for (MutableComponent c : this) {
            out.append(MultiLineComponent.of((Component)c.m_130948_(style)));
            out.appendNewline();
        }
        if (!out.isEmpty()) {
            out.remove(out.size() - 1);
        }
        return out;
    }

    public MultiLineComponent withStyle(ChatFormatting ... style) {
        MultiLineComponent out = MultiLineComponent.empty();
        for (MutableComponent c : this) {
            out.append(MultiLineComponent.of((Component)c.m_130944_(style)));
            out.appendNewline();
        }
        if (!out.isEmpty()) {
            out.remove(out.size() - 1);
        }
        return out;
    }

    public List<Component> toImmutable() {
        return new ArrayList<MutableComponent>(this);
    }

    public Tag toTag() {
        ListTag tag = new ListTag();
        for (MutableComponent component : this) {
            tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component)));
        }
        return tag;
    }

    public static MultiLineComponent fromTag(ListTag tag) {
        MultiLineComponent out = MultiLineComponent.empty();
        out.clear();
        for (Tag i : tag) {
            out.add(Component.Serializer.m_130701_((String)i.m_7916_()));
        }
        return out;
    }

    public long toLong() {
        if (this.isEmpty()) {
            return 0L;
        }
        if (this.size() > 1) {
            throw new NumberFormatException(this.toString());
        }
        return Long.parseLong(((MutableComponent)this.get(0)).getString());
    }

    public MultiLineComponent setIgnoreSpaces(boolean ignoreSpaces) {
        this.ignoreSpaces = ignoreSpaces;
        return this;
    }

    @Generated
    public boolean isIgnoreSpaces() {
        return this.ignoreSpaces;
    }
}

