/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntProviderIngredient
extends Ingredient {
    public static final ResourceLocation TYPE = GTCEu.id("int_provider");
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];
    protected final IntProvider countProvider;
    protected int sampledCount = -1;
    protected final Ingredient inner;
    protected ItemStack[] itemStacks = null;
    public static final IIngredientSerializer<IntProviderIngredient> SERIALIZER = new IIngredientSerializer<IntProviderIngredient>(){

        @NotNull
        public IntProviderIngredient parse(FriendlyByteBuf buffer) {
            CompoundTag nbt = buffer.m_130260_();
            IntProvider provider = (IntProvider)IntProvider.f_146531_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("provider")).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            int sampledCount = nbt.m_128451_("sampledCount");
            return new IntProviderIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), provider, sampledCount);
        }

        @NotNull
        public IntProviderIngredient parse(JsonObject json) {
            IntProvider provider = (IntProvider)IntProvider.f_146531_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("count_provider")).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            Ingredient inner = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            int sampledCount = json.getAsJsonPrimitive("sampledCount").getAsInt();
            return new IntProviderIngredient(inner, provider, sampledCount);
        }

        public void write(FriendlyByteBuf buffer, IntProviderIngredient ingredient) {
            CompoundTag wrapper = new CompoundTag();
            wrapper.m_128365_("provider", (Tag)IntProvider.f_146531_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)ingredient.countProvider).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
            wrapper.m_128405_("sampledCount", ingredient.sampledCount);
            buffer.m_130079_(wrapper);
            ingredient.inner.m_43923_(buffer);
        }
    };

    protected IntProviderIngredient(Ingredient inner, IntProvider countProvider) {
        super(Stream.empty());
        this.inner = inner;
        this.countProvider = countProvider;
    }

    protected IntProviderIngredient(Ingredient inner, IntProvider countProvider, int sampledCount) {
        super(Stream.empty());
        this.inner = inner;
        this.countProvider = countProvider;
        this.sampledCount = sampledCount;
    }

    public static IntProviderIngredient of(Ingredient inner, IntProvider countProvider) {
        Preconditions.checkArgument((countProvider.m_142739_() >= 0 ? 1 : 0) != 0, (Object)"IntProviderIngredient must have a min value of at least 0.");
        return new IntProviderIngredient(inner, countProvider);
    }

    public static IntProviderIngredient of(ItemStack stack, IntProvider countProvider) {
        StrictNBTIngredient inner = stack.m_41782_() ? StrictNBTIngredient.of((ItemStack)stack) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
        return IntProviderIngredient.of((Ingredient)inner, countProvider);
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.inner.test(stack);
    }

    public ItemStack @NotNull [] m_43908_() {
        if (this.itemStacks == null) {
            int cachedCount = this.getSampledCount();
            if (cachedCount == 0) {
                return EMPTY_STACK_ARRAY;
            }
            ItemStack[] innerStacks = this.inner.m_43908_();
            this.itemStacks = new ItemStack[innerStacks.length];
            for (int i = 0; i < this.itemStacks.length; ++i) {
                this.itemStacks[i] = innerStacks[i].m_255036_(cachedCount);
            }
        }
        return this.itemStacks;
    }

    @NotNull
    public ItemStack getMaxSizeStack() {
        if (this.inner.m_43908_().length == 0) {
            return ItemStack.f_41583_;
        }
        return this.inner.m_43908_()[0].m_255036_(this.countProvider.m_142737_());
    }

    public int getSampledCount() {
        return this.getSampledCount(GTValues.RNG);
    }

    public int getSampledCount(@NotNull RandomSource random) {
        if (this.sampledCount == -1) {
            this.sampledCount = this.countProvider.m_214085_(random);
        }
        return this.sampledCount;
    }

    public double getMidRoll() {
        return (double)(this.countProvider.m_142737_() + this.countProvider.m_142739_()) / 2.0;
    }

    public void reroll() {
        this.sampledCount = -1;
        this.itemStacks = null;
    }

    @NotNull
    public IntList m_43931_() {
        return this.inner.m_43931_();
    }

    public boolean m_43947_() {
        return this.inner.m_43947_();
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static IntProviderIngredient fromJson(JsonObject json) {
        return (IntProviderIngredient)SERIALIZER.parse(json);
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.add("count_provider", (JsonElement)IntProvider.f_146531_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.countProvider).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
        json.add("ingredient", this.inner.m_43942_());
        json.addProperty("sampledCount", (Number)this.sampledCount);
        return json;
    }

    @Generated
    public IntProvider getCountProvider() {
        return this.countProvider;
    }

    @Generated
    public void setSampledCount(int sampledCount) {
        this.sampledCount = sampledCount;
    }

    @Generated
    public Ingredient getInner() {
        return this.inner;
    }

    @Generated
    public void setItemStacks(ItemStack[] itemStacks) {
        this.itemStacks = itemStacks;
    }
}

