/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.client.util.ModelUtils;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.gregtechceu.gtceu.utils.memoization.MemoizedSupplier;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeModel {
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY = GTCEu.id("block/pipe/blocked/pipe_blocked");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_UP = GTCEu.id("block/pipe/blocked/pipe_blocked_up");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_DOWN = GTCEu.id("block/pipe/blocked/pipe_blocked_down");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_LEFT = GTCEu.id("block/pipe/blocked/pipe_blocked_left");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_RIGHT = GTCEu.id("block/pipe/blocked/pipe_blocked_right");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_NU = GTCEu.id("block/pipe/blocked/pipe_blocked_nu");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_ND = GTCEu.id("block/pipe/blocked/pipe_blocked_nd");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_NL = GTCEu.id("block/pipe/blocked/pipe_blocked_nl");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_NR = GTCEu.id("block/pipe/blocked/pipe_blocked_nr");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_UD = GTCEu.id("block/pipe/blocked/pipe_blocked_ud");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_UL = GTCEu.id("block/pipe/blocked/pipe_blocked_ul");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_UR = GTCEu.id("block/pipe/blocked/pipe_blocked_ur");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_DL = GTCEu.id("block/pipe/blocked/pipe_blocked_dl");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_DR = GTCEu.id("block/pipe/blocked/pipe_blocked_dr");
    public static final ResourceLocation PIPE_BLOCKED_OVERLAY_LR = GTCEu.id("block/pipe/blocked/pipe_blocked_lr");
    private static final Int2ObjectMap<TextureAtlasSprite> RESTRICTOR_MAP = new Int2ObjectOpenHashMap();
    private static boolean isRestrictorInitialized;
    private static final EnumMap<Direction, EnumMap<Border, Direction>> FACE_BORDER_MAP;
    public static final int ITEM_CONNECTIONS = 12;
    public final float thickness;
    public final AABB coreCube;
    public final Map<Direction, AABB> sideCubes;
    public MemoizedSupplier<ResourceLocation> sideTexture;
    public MemoizedSupplier<ResourceLocation> endTexture;
    @Nullable
    public MemoizedSupplier<ResourceLocation> secondarySideTexture;
    @Nullable
    public MemoizedSupplier<ResourceLocation> secondaryEndTexture;
    @Nullable
    public ResourceLocation sideOverlayTexture;
    @Nullable
    public ResourceLocation endOverlayTexture;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private TextureAtlasSprite sideSprite;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private TextureAtlasSprite endSprite;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private TextureAtlasSprite secondarySideSprite;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private TextureAtlasSprite secondaryEndSprite;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private TextureAtlasSprite sideOverlaySprite;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private TextureAtlasSprite endOverlaySprite;
    private final Map<Optional<Direction>, List<BakedQuad>> itemModelCache = new ConcurrentHashMap<Optional<Direction>, List<BakedQuad>>();

    protected static void initializeRestrictor(Function<ResourceLocation, TextureAtlasSprite> atlas) {
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_UP), Border.TOP);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_DOWN), Border.BOTTOM);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_UD), Border.TOP, Border.BOTTOM);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_LEFT), Border.LEFT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_UL), Border.TOP, Border.LEFT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_DL), Border.BOTTOM, Border.LEFT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_NR), Border.TOP, Border.BOTTOM, Border.LEFT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_RIGHT), Border.RIGHT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_UR), Border.TOP, Border.RIGHT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_DR), Border.BOTTOM, Border.RIGHT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_NL), Border.TOP, Border.BOTTOM, Border.RIGHT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_LR), Border.LEFT, Border.RIGHT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_ND), Border.TOP, Border.LEFT, Border.RIGHT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY_NU), Border.BOTTOM, Border.LEFT, Border.RIGHT);
        PipeModel.addRestrictor(atlas.apply(PIPE_BLOCKED_OVERLAY), Border.TOP, Border.BOTTOM, Border.LEFT, Border.RIGHT);
    }

    public PipeModel(float thickness, Supplier<ResourceLocation> sideTexture, Supplier<ResourceLocation> endTexture, @Nullable Supplier<ResourceLocation> secondarySideTexture, @Nullable Supplier<ResourceLocation> secondaryEndTexture) {
        this.sideTexture = GTMemoizer.memoize(sideTexture);
        this.endTexture = GTMemoizer.memoize(endTexture);
        this.secondarySideTexture = secondarySideTexture != null ? GTMemoizer.memoize(secondarySideTexture) : null;
        this.secondaryEndTexture = secondaryEndTexture != null ? GTMemoizer.memoize(secondaryEndTexture) : null;
        this.thickness = thickness;
        double min = (1.0 - (double)thickness) / 2.0;
        double max = min + (double)thickness;
        this.coreCube = new AABB(min, min, min, max, max, max);
        this.sideCubes = new EnumMap<Direction, AABB>(Direction.class);
        Direction[] directionArray = GTUtil.DIRECTIONS;
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction side;
            Vec3i normal = (side = directionArray[i]).m_122436_();
            this.sideCubes.put(side, new AABB(normal.m_123341_() == 0 ? min : (normal.m_123341_() > 0 ? max : 0.0), normal.m_123342_() == 0 ? min : (normal.m_123342_() > 0 ? max : 0.0), normal.m_123343_() == 0 ? min : (normal.m_123343_() > 0 ? max : 0.0), normal.m_123341_() == 0 ? max : (normal.m_123341_() > 0 ? 1.0 : min), normal.m_123342_() == 0 ? max : (normal.m_123342_() > 0 ? 1.0 : min), normal.m_123343_() == 0 ? max : (normal.m_123343_() > 0 ? 1.0 : min)));
        }
        if (!isRestrictorInitialized) {
            ModelUtils.registerAtlasStitchedEventListener(false, InventoryMenu.f_39692_, event -> PipeModel.initializeRestrictor(arg_0 -> ((TextureAtlas)event.getAtlas()).m_118316_(arg_0)));
            isRestrictorInitialized = true;
        }
        ModelUtils.registerAtlasStitchedEventListener(false, InventoryMenu.f_39692_, event -> {
            TextureAtlas atlas = event.getAtlas();
            this.sideSprite = atlas.m_118316_((ResourceLocation)sideTexture.get());
            this.endSprite = atlas.m_118316_((ResourceLocation)endTexture.get());
            if (secondarySideTexture != null) {
                this.secondarySideSprite = atlas.m_118316_((ResourceLocation)secondarySideTexture.get());
            }
            if (secondaryEndTexture != null) {
                this.secondaryEndSprite = atlas.m_118316_((ResourceLocation)secondaryEndTexture.get());
            }
            if (this.sideOverlayTexture != null) {
                this.sideOverlaySprite = atlas.m_118316_(this.sideOverlayTexture);
            }
            if (this.endOverlayTexture != null) {
                this.endOverlaySprite = atlas.m_118316_(this.endOverlayTexture);
            }
        });
    }

    public VoxelShape getShapes(int connections) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(7);
        shapes.add(Shapes.m_83064_((AABB)this.coreCube));
        for (Direction side : GTUtil.DIRECTIONS) {
            if (!PipeBlockEntity.isConnected(connections, side)) continue;
            shapes.add(Shapes.m_83064_((AABB)this.sideCubes.get(side)));
        }
        return shapes.stream().reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction side, int connections, int blockedConnections) {
        if (side != null) {
            if (this.thickness == 1.0f) {
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.sideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                if (this.secondarySideSprite != null) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.secondarySideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                }
                return quads;
            }
            if (PipeBlockEntity.isConnected(connections, side)) {
                int borderMask;
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.endSprite).cube(this.sideCubes.get(side).m_82400_(-0.001)).cubeUV().tintIndex(1).bake());
                if (this.secondaryEndSprite != null) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.secondaryEndSprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(1).bake());
                }
                if (this.endOverlaySprite != null) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.endOverlaySprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(0).bake());
                }
                if (this.sideOverlaySprite != null) {
                    for (Direction face : GTUtil.DIRECTIONS) {
                        if (face.m_122434_() == side.m_122434_()) continue;
                        quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideOverlaySprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(2).bake());
                    }
                }
                if ((borderMask = PipeModel.computeBorderMask(blockedConnections, connections, side)) != 0) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)((TextureAtlasSprite)RESTRICTOR_MAP.get(borderMask))).cube(this.sideCubes.get(side)).cubeUV().bake());
                }
                return quads;
            }
            return Collections.emptyList();
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        if (this.thickness < 1.0f) {
            for (Direction face : GTUtil.DIRECTIONS) {
                if (!PipeBlockEntity.isConnected(connections, face)) {
                    quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                    if (this.secondarySideSprite != null) {
                        quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.secondarySideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                    }
                }
                for (Direction facing : GTUtil.DIRECTIONS) {
                    int borderMask;
                    if (facing.m_122434_() == face.m_122434_() || !PipeBlockEntity.isConnected(connections, facing)) continue;
                    quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideSprite).cube(this.sideCubes.get(facing)).cubeUV().tintIndex(0).bake());
                    if (this.secondarySideSprite != null) {
                        quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.secondarySideSprite).cube(this.sideCubes.get(facing)).cubeUV().tintIndex(0).bake());
                    }
                    if (this.sideOverlaySprite != null) {
                        quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideOverlaySprite).cube(this.sideCubes.get(facing).m_82400_(0.001)).cubeUV().tintIndex(2).bake());
                    }
                    if ((borderMask = PipeModel.computeBorderMask(blockedConnections, connections, face)) == 0) continue;
                    quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)((TextureAtlasSprite)RESTRICTOR_MAP.get(borderMask))).cube(this.coreCube).cubeUV().bake());
                    quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)((TextureAtlasSprite)RESTRICTOR_MAP.get(borderMask))).cube(this.sideCubes.get(facing)).cubeUV().bake());
                }
            }
        }
        return quads;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        return this.sideSprite;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        IItemRendererProvider.disabled.set(true);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (state, direction, random) -> this.itemModelCache.computeIfAbsent(Optional.ofNullable(direction), direction1 -> this.bakeQuads(direction1.orElse(null), 12, 0)));
        IItemRendererProvider.disabled.set(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerTextureAtlas(Consumer<ResourceLocation> register) {
        this.itemModelCache.clear();
        this.sideTexture.invalidate();
        register.accept(this.sideTexture.get());
        this.endTexture.invalidate();
        register.accept(this.endTexture.get());
        if (this.secondarySideTexture != null) {
            this.secondarySideTexture.invalidate();
            if (this.secondarySideTexture.get() != GTModels.BLANK_TEXTURE) {
                register.accept(this.secondarySideTexture.get());
            }
        }
        if (this.secondaryEndTexture != null) {
            this.secondaryEndTexture.invalidate();
            if (this.secondaryEndTexture.get() != GTModels.BLANK_TEXTURE) {
                register.accept(this.secondaryEndTexture.get());
            }
        }
        if (this.sideOverlayTexture != null) {
            register.accept(this.sideOverlayTexture);
        }
        if (this.endOverlayTexture != null) {
            register.accept(this.endOverlayTexture);
        }
        this.sideSprite = null;
        this.endSprite = null;
        this.endOverlaySprite = null;
    }

    private static EnumMap<Border, Direction> borderMap(Direction topSide, Direction bottomSide, Direction leftSide, Direction rightSide) {
        EnumMap<Border, Direction> sideMap = new EnumMap<Border, Direction>(Border.class);
        sideMap.put(Border.TOP, topSide);
        sideMap.put(Border.BOTTOM, bottomSide);
        sideMap.put(Border.LEFT, leftSide);
        sideMap.put(Border.RIGHT, rightSide);
        return sideMap;
    }

    private static void addRestrictor(TextureAtlasSprite sprite, Border ... borders) {
        int mask = 0;
        for (Border border : borders) {
            mask |= border.mask;
        }
        RESTRICTOR_MAP.put(mask, (Object)sprite);
    }

    protected static Direction getSideAtBorder(Direction side, Border border) {
        return FACE_BORDER_MAP.get(side).get((Object)border);
    }

    protected static int computeBorderMask(int blockedConnections, int connections, Direction side) {
        int borderMask = 0;
        if (blockedConnections != 0) {
            for (Border border : Border.VALUES) {
                Direction borderSide = PipeModel.getSideAtBorder(side, border);
                if (!PipeBlockEntity.isFaceBlocked(blockedConnections, borderSide) || !PipeBlockEntity.isConnected(connections, borderSide)) continue;
                borderMask |= border.mask;
            }
        }
        return borderMask;
    }

    @Generated
    public void setSideOverlayTexture(@Nullable ResourceLocation sideOverlayTexture) {
        this.sideOverlayTexture = sideOverlayTexture;
    }

    @Generated
    public void setEndOverlayTexture(@Nullable ResourceLocation endOverlayTexture) {
        this.endOverlayTexture = endOverlayTexture;
    }

    static {
        FACE_BORDER_MAP = (EnumMap)Util.m_137537_(() -> {
            EnumMap<Direction, EnumMap<Border, Direction>> map = new EnumMap<Direction, EnumMap<Border, Direction>>(Direction.class);
            map.put(Direction.DOWN, PipeModel.borderMap(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST));
            map.put(Direction.UP, PipeModel.borderMap(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST));
            map.put(Direction.NORTH, PipeModel.borderMap(Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST));
            map.put(Direction.SOUTH, PipeModel.borderMap(Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST));
            map.put(Direction.WEST, PipeModel.borderMap(Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH));
            map.put(Direction.EAST, PipeModel.borderMap(Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH));
            return map;
        });
    }

    public static enum Border {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

        public static final Border[] VALUES;
        public final int mask = 1 << this.ordinal();

        static {
            VALUES = Border.values();
        }
    }
}

