/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserNetHandler;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeNet;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeType;
import com.gregtechceu.gtceu.common.pipelike.laser.LevelLaserPipeNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserPipeBlockEntity
extends PipeBlockEntity<LaserPipeType, LaserPipeProperties> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LaserPipeBlockEntity.class, PipeBlockEntity.MANAGED_FIELD_HOLDER);
    protected final EnumMap<Direction, LaserNetHandler> handlers = new EnumMap(Direction.class);
    public final ILaserContainer clientCapability = new DefaultLaserContainer();
    private WeakReference<LaserPipeNet> currentPipeNet = new WeakReference<Object>(null);
    protected LaserNetHandler defaultHandler;
    private int ticksActive = 0;
    private int activeDuration = 0;
    @Persisted
    @DescSynced
    private boolean active = false;

    protected LaserPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static LaserPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new LaserPipeBlockEntity(type, pos, blockState);
    }

    public static void onBlockEntityRegister(BlockEntityType<LaserPipeBlockEntity> cableBlockEntityBlockEntityType) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == GTCapability.CAPABILITY_LASER) {
            if (this.m_58904_().m_5776_()) {
                return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> this.clientCapability));
            }
            if (side != null && !this.isConnected(side)) {
                return LazyOptional.empty();
            }
            if (this.handlers.isEmpty()) {
                this.initHandlers();
            }
            this.checkNetwork();
            return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> this.handlers.getOrDefault(side, this.defaultHandler)));
        }
        if (cap == GTCapability.CAPABILITY_COVERABLE) {
            return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(this::getCoverContainer));
        }
        if (cap == GTCapability.CAPABILITY_TOOLABLE) {
            return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> this));
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canHaveBlockedFaces() {
        return false;
    }

    public void initHandlers() {
        LaserPipeNet net = this.getLaserPipeNet();
        if (net == null) {
            return;
        }
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.handlers.put(facing, new LaserNetHandler(net, this, facing));
        }
        this.defaultHandler = new LaserNetHandler(net, this, null);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            LaserPipeNet current = this.getLaserPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (LaserNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public LaserPipeNet getLaserPipeNet() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return null;
        }
        LaserPipeNet currentPipeNet = (LaserPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        LevelLaserPipeNet worldNet = (LevelLaserPipeNet)((Object)this.getPipeBlock().getWorldPipeNet((ServerLevel)this.getPipeLevel()));
        currentPipeNet = (LaserPipeNet)worldNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<LaserPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    public void setActive(boolean active, int duration) {
        if (this.active != active) {
            this.active = active;
            this.notifyBlockUpdate();
            this.m_6596_();
            if (active && duration != this.activeDuration) {
                TaskHandler.enqueueServerTask((ServerLevel)this.m_58904_(), this::queueDisconnect, 0);
            }
        }
        this.activeDuration = duration;
        if (duration > 0 && active) {
            this.ticksActive = 0;
        }
    }

    public boolean queueDisconnect() {
        if (++this.ticksActive % this.activeDuration == 0) {
            this.ticksActive = 0;
            this.setActive(false, -1);
            return false;
        }
        return true;
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_7702_(this.m_58899_().m_121945_(side)) instanceof LaserPipeBlockEntity) {
                return false;
            }
            return GTCapabilityHelper.getLaser(this.f_58857_, this.m_58899_().m_121945_(side), side.m_122424_()) != null;
        }
        return false;
    }

    @Override
    public void setConnection(Direction side, boolean connected, boolean fromNeighbor) {
        if (!this.m_58904_().f_46443_ && connected) {
            IPipeNode pipeTile;
            int connections = this.getConnections();
            connections &= ~(1 << side.ordinal());
            if ((connections &= ~(1 << side.m_122424_().ordinal())) != 0) {
                return;
            }
            BlockEntity tile = this.m_58904_().m_7702_(this.m_58899_().m_121945_(side));
            if (tile instanceof IPipeNode && (pipeTile = (IPipeNode)tile).getPipeType().getClass() == ((LaserPipeType)this.getPipeType()).getClass()) {
                connections = pipeTile.getConnections();
                connections &= ~(1 << side.ordinal());
                if ((connections &= ~(1 << side.m_122424_().ordinal())) != 0) {
                    return;
                }
            }
        }
        super.setConnection(side, connected, fromNeighbor);
    }

    @Override
    public GTToolType getPipeTuneTool() {
        return GTToolType.WIRE_CUTTER;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public EnumMap<Direction, LaserNetHandler> getHandlers() {
        return this.handlers;
    }

    @Generated
    public LaserNetHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    private static class DefaultLaserContainer
    implements ILaserContainer {
        private DefaultLaserContainer() {
        }

        @Override
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        @Override
        public boolean inputsEnergy(Direction side) {
            return false;
        }

        @Override
        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        @Override
        public long getEnergyStored() {
            return 0L;
        }

        @Override
        public long getEnergyCapacity() {
            return 0L;
        }

        @Override
        public long getInputAmperage() {
            return 0L;
        }

        @Override
        public long getInputVoltage() {
            return 0L;
        }
    }
}

