/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidDetectorCover
extends DetectorCover {
    public FluidDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return super.canAttach() && this.getFluidHandler() != null;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IFluidHandler fluidHandler = this.getFluidHandler();
        if (fluidHandler == null) {
            return;
        }
        int storedFluid = 0;
        int fluidCapacity = 0;
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack content = fluidHandler.getFluidInTank(tank);
            if (!content.isEmpty()) {
                storedFluid += content.getAmount();
            }
            fluidCapacity += fluidHandler.getTankCapacity(tank);
        }
        if (fluidCapacity == 0) {
            return;
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedFluid, fluidCapacity, this.isInverted()));
    }

    protected IFluidHandler getFluidHandler() {
        return FluidUtil.getFluidHandler((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide).resolve().orElse(null);
    }
}

