/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.utils.input.SyncedKeyMappings;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IJetpack {
    default public double getSprintEnergyModifier() {
        return 1.0;
    }

    default public double getSprintSpeedModifier() {
        return 1.0;
    }

    default public double getVerticalHoverSpeed() {
        return 0.18;
    }

    default public double getVerticalHoverSlowSpeed() {
        return 0.14;
    }

    default public double getVerticalAcceleration() {
        return 0.1;
    }

    default public double getVerticalSpeed() {
        return 0.22;
    }

    default public double getSidewaysSpeed() {
        return 0.0;
    }

    default public boolean removeMiningSpeedPenalty() {
        return true;
    }

    @Nullable
    default public ParticleOptions getParticle() {
        return ParticleTypes.f_123755_;
    }

    default public float getFallDamageReduction() {
        return 0.0f;
    }

    public int getEnergyPerUse();

    public boolean canUseEnergy(ItemStack var1, int var2);

    public void drainEnergy(ItemStack var1, int var2);

    public boolean hasEnergy(ItemStack var1);

    default public void performFlying(@NotNull Player player, boolean flightEnabled, boolean hover, ItemStack stack) {
        double deltaY = player.m_20184_().m_7098_();
        if (!(flightEnabled && hover || !(player.m_20186_() < (double)(player.m_9236_().m_141937_() - 5)))) {
            IJetpack.performEHover(stack, player);
        } else if (!flightEnabled) {
            return;
        }
        boolean flyKeyDown = SyncedKeyMappings.VANILLA_JUMP.isKeyDown(player);
        boolean descendKeyDown = SyncedKeyMappings.VANILLA_SNEAK.isKeyDown(player);
        double currentAccel = this.getVerticalAcceleration() * (deltaY < 0.3 ? 2.5 : 1.0);
        if (!player.m_20096_() && player.m_21257_().isEmpty() && this.canUseEnergy(stack, this.getEnergyPerUse())) {
            double potentialY = 0.0;
            boolean editMotion = true;
            if (hover) {
                potentialY = flyKeyDown && descendKeyDown ? this.getVerticalHoverSlowSpeed() : (flyKeyDown ? this.getVerticalHoverSpeed() : (descendKeyDown ? -this.getVerticalHoverSpeed() : -this.getVerticalHoverSlowSpeed()));
                if (player.m_21255_()) {
                    player.m_36321_();
                }
            } else if (flyKeyDown && descendKeyDown) {
                potentialY = 0.0;
            } else if (flyKeyDown) {
                potentialY = this.getVerticalSpeed() * (player.m_20069_() ? 0.4 : 1.0);
            } else {
                editMotion = false;
            }
            if (editMotion) {
                potentialY = Math.min(deltaY + currentAccel, potentialY);
                IJetpack.setYMotion(player, potentialY);
            }
            float speedSideways = (float)(player.m_6144_() ? this.getSidewaysSpeed() * 0.5 : this.getSidewaysSpeed());
            float speedForward = (float)(player.m_20142_() ? (double)speedSideways * this.getSprintSpeedModifier() : (double)speedSideways);
            if (!player.m_21255_()) {
                double dist;
                Vec3 movement = new Vec3(0.0, 0.0, 0.0);
                if (SyncedKeyMappings.VANILLA_FORWARD.isKeyDown(player)) {
                    movement = movement.m_82520_(0.0, 0.0, (double)speedForward);
                }
                if (SyncedKeyMappings.VANILLA_BACKWARD.isKeyDown(player)) {
                    movement = movement.m_82520_(0.0, 0.0, (double)(-speedSideways * 0.8f));
                }
                if (SyncedKeyMappings.VANILLA_LEFT.isKeyDown(player)) {
                    movement = movement.m_82520_((double)speedSideways, 0.0, 0.0);
                }
                if (SyncedKeyMappings.VANILLA_RIGHT.isKeyDown(player)) {
                    movement = movement.m_82520_((double)(-speedSideways), 0.0, 0.0);
                }
                if ((dist = movement.m_82553_()) >= 1.0E-7) {
                    player.m_19920_((float)dist, movement);
                    if (!editMotion) {
                        editMotion = true;
                    }
                }
            }
            if (editMotion) {
                int energyUsed = (int)Math.round((double)this.getEnergyPerUse() * (player.m_20142_() ? this.getSprintEnergyModifier() : 1.0));
                this.drainEnergy(stack, energyUsed);
                ArmorUtils.spawnParticle(player.m_9236_(), player, this.getParticle(), -0.6);
            }
            if (!player.m_9236_().f_46443_ && (hover || flyKeyDown)) {
                player.f_19789_ = 0.0f;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.f_9737_ = 0;
                }
            }
        }
    }

    private static void setYMotion(Player player, double value) {
        Vec3 motion = player.m_20184_();
        player.m_20334_(motion.m_7096_(), value, motion.m_7094_());
    }

    public static void performEHover(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("enabled", true);
        tag.m_128379_("hover", true);
        player.m_5661_((Component)Component.m_237115_((String)"metaarmor.jetpack.emergency_hover_mode"), true);
        player.f_19789_ = 0.0f;
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.f_9737_ = 0;
        }
        player.f_36095_.m_150429_();
    }

    private static void addYMotion(Player player, double value) {
        Vec3 motion = player.m_20184_();
        player.m_246865_(new Vec3(motion.m_7096_(), value, motion.m_7094_()));
    }
}

