/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.List;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MetaMachineConfigCopyBehaviour
implements IInteractionItem,
IAddInformation {
    public static final String NONE_DIRECTION = "null";
    public static final String CONFIG_DATA = "config_data";
    public static final String ORIGINAL_FRONT = "front";
    public static final String ITEM_CONFIG = "item";
    public static final String FLUID_CONFIG = "fluid";
    public static final String DIRECTION = "direction";
    public static final String AUTO = "auto";
    public static final String INPUT_FROM_OUTPUT_SIDE = "in_from_out";
    public static final String MUFFLED = "muffled";
    public static final Component ENABLED = Component.m_237115_((String)"cover.voiding.label.enabled").m_130940_(ChatFormatting.GREEN);
    public static final Component DISABLED = Component.m_237115_((String)"cover.voiding.label.disabled").m_130940_(ChatFormatting.RED);
    public static final Component[] DIRECTION_TOOLTIPS = new Component[]{Component.m_237115_((String)"gtceu.direction.tooltip.up").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"gtceu.direction.tooltip.down").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"gtceu.direction.tooltip.left").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"gtceu.direction.tooltip.right").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"gtceu.direction.tooltip.front").m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)"gtceu.direction.tooltip.back").m_130940_(ChatFormatting.YELLOW)};

    public static String directionToString(@Nullable Direction direction) {
        if (direction == null) {
            return NONE_DIRECTION;
        }
        return direction.m_7912_();
    }

    @Nullable
    public static Direction tagToDirection(@Nullable Tag tag) {
        if (tag instanceof StringTag) {
            StringTag string = (StringTag)tag;
            String name = string.m_7916_();
            if (Strings.isNullOrEmpty((String)name) || NONE_DIRECTION.equalsIgnoreCase(name)) {
                return null;
            }
            return Direction.m_122402_((String)name);
        }
        if (tag instanceof NumericTag) {
            NumericTag number = (NumericTag)tag;
            int ordinal = number.m_7047_();
            return ordinal <= 0 || ordinal > Direction.values().length ? null : Direction.values()[ordinal - 1];
        }
        return null;
    }

    public static Component relativeDirectionComponent(Direction origFront, Direction origDirection) {
        RelativeDirection relative = RelativeDirection.findRelativeOf(origFront, origDirection);
        return DIRECTION_TOOLTIPS[relative.ordinal()];
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_()) {
            stack.m_41749_(CONFIG_DATA);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof IMachineBlockEntity) {
            IMachineBlockEntity blockEntity2 = (IMachineBlockEntity)blockEntity;
            MetaMachine machine = blockEntity2.getMetaMachine();
            if (!MachineOwner.canOpenOwnerMachine(context.m_43723_(), machine)) {
                return InteractionResult.FAIL;
            }
            if (context.m_7078_()) {
                return MetaMachineConfigCopyBehaviour.handleCopy(stack, machine);
            }
            if (stack.m_41737_(CONFIG_DATA) != null) {
                return MetaMachineConfigCopyBehaviour.handlePaste(stack, machine);
            }
        } else if (context.m_7078_() && context.m_43725_().m_8055_(context.m_8083_()).m_60795_()) {
            stack.m_41749_(CONFIG_DATA);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult handleCopy(ItemStack stack, MetaMachine machine) {
        IAutoOutputFluid autoOutputFluid;
        IAutoOutputItem autoOutputItem;
        CompoundTag configData = new CompoundTag();
        configData.m_128359_(ORIGINAL_FRONT, MetaMachineConfigCopyBehaviour.directionToString(machine.getFrontFacing()));
        if (machine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)machine)).getOutputFacingItems() != null) {
            configData.m_128365_(ITEM_CONFIG, (Tag)MetaMachineConfigCopyBehaviour.copyOutputConfig(autoOutputItem.getOutputFacingItems(), autoOutputItem.isAutoOutputItems(), autoOutputItem.isAllowInputFromOutputSideItems()));
        }
        if (machine instanceof IAutoOutputFluid && (autoOutputFluid = (IAutoOutputFluid)((Object)machine)).getOutputFacingFluids() != null) {
            configData.m_128365_(FLUID_CONFIG, (Tag)MetaMachineConfigCopyBehaviour.copyOutputConfig(autoOutputFluid.getOutputFacingFluids(), autoOutputFluid.isAutoOutputFluids(), autoOutputFluid.isAllowInputFromOutputSideFluids()));
        }
        if (machine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)machine);
            configData.m_128379_(MUFFLED, mufflableMachine.isMuffled());
        }
        if (!configData.m_128456_()) {
            stack.m_41784_().m_128365_(CONFIG_DATA, (Tag)configData);
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult handlePaste(ItemStack stack, MetaMachine machine) {
        CompoundTag configData = stack.m_41737_(CONFIG_DATA);
        if (configData == null) {
            return InteractionResult.PASS;
        }
        Direction originalFront = MetaMachineConfigCopyBehaviour.tagToDirection(configData.m_128423_(ORIGINAL_FRONT));
        if (configData.m_128441_(ITEM_CONFIG) && machine instanceof IAutoOutputItem) {
            IAutoOutputItem autoOutputItem = (IAutoOutputItem)((Object)machine);
            MetaMachineConfigCopyBehaviour.pasteOutputConfig(originalFront, machine.getFrontFacing(), configData.m_128469_(ITEM_CONFIG), autoOutputItem::setOutputFacingItems, autoOutputItem::setAutoOutputItems, autoOutputItem::setAllowInputFromOutputSideItems);
        }
        if (configData.m_128441_(FLUID_CONFIG) && machine instanceof IAutoOutputFluid) {
            IAutoOutputFluid autoOutputFluid = (IAutoOutputFluid)((Object)machine);
            MetaMachineConfigCopyBehaviour.pasteOutputConfig(originalFront, machine.getFrontFacing(), configData.m_128469_(FLUID_CONFIG), autoOutputFluid::setOutputFacingFluids, autoOutputFluid::setAutoOutputFluids, autoOutputFluid::setAllowInputFromOutputSideFluids);
        }
        if (configData.m_128441_(MUFFLED) && machine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)machine);
            mufflableMachine.setMuffled(configData.m_128471_(MUFFLED));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.meta.machine.config.copy.tooltip"));
        tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.meta.machine.config.paste.tooltip"));
        CompoundTag data = stack.m_41737_(CONFIG_DATA);
        if (data == null) {
            return;
        }
        if (Screen.m_96638_()) {
            tooltipComponents.add(CommonComponents.f_237098_);
            if (data.m_128441_(ORIGINAL_FRONT)) {
                Direction origFront = MetaMachineConfigCopyBehaviour.tagToDirection(data.m_128423_(ORIGINAL_FRONT));
                for (RecipeCapability recipeCapability : GTRegistries.RECIPE_CAPABILITIES) {
                    if (!data.m_128441_(recipeCapability.name)) continue;
                    CompoundTag configData = data.m_128469_(recipeCapability.name);
                    MutableComponent component = recipeCapability.getColoredName();
                    MetaMachineConfigCopyBehaviour.addConfigTypeTooltips(tooltipComponents, (Component)component, configData, origFront);
                }
            }
            if (data.m_128441_(MUFFLED)) {
                tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.setting.muffled.tooltip", (Object[])new Object[]{data.m_128471_(MUFFLED) ? ENABLED : DISABLED}));
            }
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"item.toggle.advanced.info.tooltip"));
        }
    }

    private static void addConfigTypeTooltips(List<Component> tooltip, Component baseComponent, CompoundTag data, Direction origFront) {
        tooltip.add((Component)Component.m_237110_((String)"behaviour.setting.output.direction.tooltip", (Object[])new Object[]{baseComponent, MetaMachineConfigCopyBehaviour.relativeDirectionComponent(origFront, MetaMachineConfigCopyBehaviour.tagToDirection(data.m_128423_(DIRECTION)))}));
        tooltip.add((Component)Component.m_237110_((String)"behaviour.setting.item_auto_output.tooltip", (Object[])new Object[]{baseComponent, data.m_128471_(AUTO) ? ENABLED : DISABLED}));
        tooltip.add((Component)Component.m_237110_((String)"behaviour.setting.allow.input.from.output.tooltip", (Object[])new Object[]{baseComponent, data.m_128471_(INPUT_FROM_OUTPUT_SIDE) ? ENABLED : DISABLED}));
    }

    private static CompoundTag copyOutputConfig(Direction outputSide, boolean autoOutput, boolean allowInputFromOutputSide) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(DIRECTION, MetaMachineConfigCopyBehaviour.directionToString(outputSide));
        tag.m_128379_(AUTO, autoOutput);
        tag.m_128379_(INPUT_FROM_OUTPUT_SIDE, allowInputFromOutputSide);
        return tag;
    }

    private static void pasteOutputConfig(Direction originalFront, Direction currentFront, CompoundTag data, Consumer<Direction> outputSide, BooleanConsumer autoOutput, BooleanConsumer allowInputFromOutputSide) {
        outputSide.accept(RelativeDirection.getActualDirection(originalFront, currentFront, MetaMachineConfigCopyBehaviour.tagToDirection(data.m_128423_(DIRECTION))));
        autoOutput.accept(data.m_128471_(AUTO));
        allowInputFromOutputSide.accept(data.m_128471_(INPUT_FROM_OUTPUT_SIDE));
    }
}

