/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.integration.map.ClientCacheManager;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SCPacketShareProspection
implements GTNetwork.INetPacket {
    private UUID sender;
    private UUID receiver;
    private String cacheName;
    private String key;
    private boolean isDimCache;
    private ResourceKey<Level> dimension;
    private CompoundTag data;
    private boolean first;

    public SCPacketShareProspection() {
    }

    public SCPacketShareProspection(FriendlyByteBuf buf) {
        this.sender = buf.m_130259_();
        this.receiver = buf.m_130259_();
        this.cacheName = buf.m_130277_();
        this.key = buf.m_130277_();
        this.isDimCache = buf.readBoolean();
        this.dimension = buf.m_236801_(Registries.f_256858_);
        this.data = buf.m_130260_();
        this.first = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.sender);
        buf.m_130077_(this.receiver);
        buf.m_130070_(this.cacheName);
        buf.m_130070_(this.key);
        buf.writeBoolean(this.isDimCache);
        buf.m_236858_(this.dimension);
        buf.m_130079_(this.data);
        buf.writeBoolean(this.first);
    }

    @Override
    public void execute(NetworkEvent.Context context) {
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            if (this.first) {
                Component playerName;
                PlayerInfo senderInfo = Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_104949_(this.sender);
                if (senderInfo == null) {
                    return;
                }
                Object object = playerName = senderInfo.m_105342_() != null ? senderInfo.m_105342_() : Component.m_237113_((String)senderInfo.m_105312_().getName());
                assert (Minecraft.m_91087_().f_91074_ != null);
                Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237110_((String)"command.gtceu.share_prospection_data.notification", (Object[])new Object[]{playerName}));
            }
            ClientCacheManager.processProspectionShare(this.cacheName, this.key, this.isDimCache, this.dimension, this.data);
        } else {
            SCPacketShareProspection newPacket = new SCPacketShareProspection(this.sender, this.receiver, this.cacheName, this.key, this.isDimCache, this.dimension, this.data, this.first);
            GTNetwork.sendToPlayer(GTCEu.getMinecraftServer().m_6846_().m_11259_(this.receiver), newPacket);
        }
    }

    @Generated
    public SCPacketShareProspection(UUID sender, UUID receiver, String cacheName, String key, boolean isDimCache, ResourceKey<Level> dimension, CompoundTag data, boolean first) {
        this.sender = sender;
        this.receiver = receiver;
        this.cacheName = cacheName;
        this.key = key;
        this.isDimCache = isDimCache;
        this.dimension = dimension;
        this.data = data;
        this.first = first;
    }
}

