/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.Node;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemNetWalker;
import com.gregtechceu.gtceu.common.pipelike.item.ItemRoutePath;
import com.gregtechceu.gtceu.common.pipelike.item.ItemRoutePathSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class ItemPipeNet
extends PipeNet<ItemPipeProperties> {
    private final Map<BlockPos, List<ItemRoutePath>> NET_DATA = new HashMap<BlockPos, List<ItemRoutePath>>();
    private final Map<BlockPos, List<ItemRoutePath>> NET_DATA_NO_RESTRICTIVE = new HashMap<BlockPos, List<ItemRoutePath>>();
    private final Map<BlockPos, List<ItemRoutePath>> NET_DATA_ONLY_RESTRICTIVE = new HashMap<BlockPos, List<ItemRoutePath>>();

    public ItemPipeNet(LevelPipeNet<ItemPipeProperties, ? extends PipeNet<ItemPipeProperties>> world) {
        super(world);
    }

    public List<ItemRoutePath> getNetData(BlockPos pipePos, Direction facing, ItemRoutePathSet ITEMNETSET) {
        List<ItemRoutePath> data;
        switch (ITEMNETSET) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FULL: {
                List<ItemRoutePath> list = this.NET_DATA.get(pipePos);
                break;
            }
            case NONRESTRICTED: {
                List<ItemRoutePath> list = this.NET_DATA_NO_RESTRICTIVE.get(pipePos);
                break;
            }
            case RESTRICTED: {
                List<ItemRoutePath> list = data = this.NET_DATA_ONLY_RESTRICTIVE.get(pipePos);
            }
        }
        if (data == null) {
            data = ItemNetWalker.createNetData(this, pipePos, facing);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(inv -> inv.getProperties().getPriority()));
            ArrayList<ItemRoutePath> nonRestricted = new ArrayList<ItemRoutePath>();
            ArrayList<ItemRoutePath> restricted = new ArrayList<ItemRoutePath>();
            for (ItemRoutePath route : data) {
                if (route.isRestrictive()) {
                    restricted.add(route);
                    continue;
                }
                nonRestricted.add(route);
            }
            this.NET_DATA.put(pipePos, data);
            this.NET_DATA_NO_RESTRICTIVE.put(pipePos, nonRestricted);
            this.NET_DATA_ONLY_RESTRICTIVE.put(pipePos, restricted);
            data = switch (ITEMNETSET) {
                default -> throw new IncompatibleClassChangeError();
                case ItemRoutePathSet.FULL -> this.NET_DATA.get(pipePos);
                case ItemRoutePathSet.NONRESTRICTED -> this.NET_DATA_NO_RESTRICTIVE.get(pipePos);
                case ItemRoutePathSet.RESTRICTED -> this.NET_DATA_ONLY_RESTRICTIVE.get(pipePos);
            };
        }
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.clearNetData();
    }

    private void clearNetData() {
        this.NET_DATA.clear();
        this.NET_DATA_ONLY_RESTRICTIVE.clear();
        this.NET_DATA_NO_RESTRICTIVE.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.clearNetData();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<ItemPipeProperties>> transferredNodes, PipeNet<ItemPipeProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.clearNetData();
        ((ItemPipeNet)parentNet).clearNetData();
    }

    @Override
    protected void writeNodeData(ItemPipeProperties nodeData, CompoundTag tagCompound) {
        tagCompound.m_128405_("Resistance", nodeData.getPriority());
        tagCompound.m_128350_("Rate", nodeData.getTransferRate());
    }

    @Override
    protected ItemPipeProperties readNodeData(CompoundTag tagCompound) {
        return new ItemPipeProperties(tagCompound.m_128451_("Resistance"), tagCompound.m_128457_("Rate"));
    }
}

