/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class VentCondition
extends RecipeCondition {
    public static final Codec<VentCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).apply((Applicative)instance, VentCondition::new));
    public static final VentCondition INSTANCE = new VentCondition();

    public VentCondition(boolean isReverse) {
        super(isReverse);
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.VENT;
    }

    @Override
    public Component getTooltips() {
        return Component.m_237115_((String)"recipe.condition.steam_vent.tooltip");
    }

    @Override
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        IRecipeLogicMachine iRecipeLogicMachine;
        if (recipeLogic.getProgress() % 10 == 0 && (iRecipeLogicMachine = recipeLogic.machine) instanceof IExhaustVentMachine) {
            IExhaustVentMachine ventMachine = (IExhaustVentMachine)((Object)iRecipeLogicMachine);
            return !ventMachine.isNeedsVenting() || !ventMachine.isVentingBlocked();
        }
        return true;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new VentCondition();
    }

    @Generated
    public VentCondition() {
    }
}

