/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class OreRecipeHandler {
    private OreRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        OreProperty property = material.getProperty(PropertyKey.ORE);
        if (property == null) {
            return;
        }
        for (TagPrefix ore : TagPrefix.ORES.keySet()) {
            OreRecipeHandler.processOre(provider, ore, property, material);
        }
        OreRecipeHandler.processRawOre(provider, property, material);
        OreRecipeHandler.processCrushedOre(provider, property, material);
        OreRecipeHandler.processCrushedPurified(provider, property, material);
        OreRecipeHandler.processCrushedCentrifuged(provider, property, material);
        OreRecipeHandler.processDirtyDust(provider, property, material);
        OreRecipeHandler.processPureDust(provider, property, material);
    }

    private static void processMetalSmelting(@NotNull Consumer<FinishedRecipe> provider, @NotNull OreProperty property, @NotNull TagPrefix prefix, @NotNull Material material) {
        ItemStack ingotStack;
        Material smeltingResult;
        Material material2 = smeltingResult = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
        if (smeltingResult.hasProperty(PropertyKey.INGOT) && !(ingotStack = ChemicalHelper.get(TagPrefix.ingot, smeltingResult)).m_41619_() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingResult) && !prefix.isIgnored(material)) {
            String name = "smelt_" + prefix.name + "_" + material.getName() + "_to_ingot";
            TagKey<Item> tag = ChemicalHelper.getTag(prefix, material);
            VanillaRecipeHelper.addSmeltingRecipe(provider, name, tag, ingotStack, 0.5f);
            VanillaRecipeHelper.addBlastingRecipe(provider, name, tag, ingotStack, 0.5f);
        }
    }

    private static void processOre(@NotNull Consumer<FinishedRecipe> provider, @NotNull TagPrefix orePrefix, @NotNull OreProperty property, @NotNull Material material) {
        String prefixString;
        Material smeltingMaterial;
        if (!material.shouldGenerateRecipesFor(orePrefix)) {
            return;
        }
        ItemStack inputStack = ChemicalHelper.get(orePrefix, material);
        Material byproductMaterial = property.getOreByProduct(0, material);
        ItemStack byproductStack = ChemicalHelper.get(TagPrefix.gem, byproductMaterial);
        if (byproductStack.m_41619_()) {
            byproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial);
        }
        Material material2 = smeltingMaterial = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
        ItemStack ingotStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
        int oreTypeMultiplier = TagPrefix.ORES.get(orePrefix).isDoubleDrops() ? 2 : 1;
        ingotStack.m_41764_(ingotStack.m_41613_() * property.getOreMultiplier() * oreTypeMultiplier);
        ItemStack crushedStack = ChemicalHelper.get(TagPrefix.crushed, material);
        crushedStack.m_41764_(crushedStack.m_41613_() * property.getOreMultiplier());
        String string = prefixString = orePrefix == TagPrefix.ore ? "" : orePrefix.name + "_";
        if (!crushedStack.m_41619_()) {
            int crushedCount = property.getOreMultiplier() * oreTypeMultiplier;
            GTRecipeBuilder builder = GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + prefixString + material.getName() + "_ore_to_crushed_ore").inputItems(inputStack).EUt(16L).duration(10).category(GTRecipeCategories.ORE_FORGING);
            if (material.hasProperty(PropertyKey.GEM) && !ChemicalHelper.get(TagPrefix.gem, material).m_41619_()) {
                builder.outputItems(ChemicalHelper.get(TagPrefix.gem, material).m_255036_(crushedCount));
            } else {
                builder.outputItems(crushedStack.m_255036_(crushedCount));
            }
            builder.save(provider);
            builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + prefixString + material.getName() + "_ore_to_crushed_ore").inputItems(inputStack).outputItems(crushedStack.m_255036_(crushedCount * 2)).chancedOutput(byproductStack, 1400, 0).EUt(2L).duration(400).category(GTRecipeCategories.ORE_CRUSHING);
            for (MaterialStack secondaryMaterial : orePrefix.secondaryMaterials()) {
                if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                ItemStack dustStack = ChemicalHelper.getGem(secondaryMaterial);
                builder.chancedOutput(dustStack, 6700, 0);
            }
            builder.save(provider);
        }
        if (!ingotStack.m_41619_() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !orePrefix.isIgnored(material)) {
            float xp = (float)Math.round(((1.0f + (float)oreTypeMultiplier * 0.5f) * 0.5f - 0.05f) * 10.0f) / 10.0f;
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + prefixString + material.getName() + "_ore_to_ingot", inputStack, ingotStack, xp);
            VanillaRecipeHelper.addBlastingRecipe(provider, "smelt_" + prefixString + material.getName() + "_ore_to_ingot", inputStack, ingotStack, xp);
        }
    }

    private static void processRawOre(@NotNull Consumer<FinishedRecipe> provider, @NotNull OreProperty property, @NotNull Material material) {
        Material smeltingMaterial;
        if (!material.shouldGenerateRecipesFor(TagPrefix.rawOre)) {
            return;
        }
        Material byproductMaterial = property.getOreByProduct(0, material);
        ItemStack byproductStack = ChemicalHelper.get(TagPrefix.gem, byproductMaterial);
        if (byproductStack.m_41619_()) {
            byproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial);
        }
        Material material2 = smeltingMaterial = property.getDirectSmeltResult().isNull() ? material : property.getDirectSmeltResult();
        ItemStack ingotStack = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? ChemicalHelper.get(TagPrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? ChemicalHelper.get(TagPrefix.gem, smeltingMaterial) : ChemicalHelper.get(TagPrefix.dust, smeltingMaterial));
        ingotStack.m_41764_(ingotStack.m_41613_() * property.getOreMultiplier());
        ItemStack crushedStack = ChemicalHelper.get(TagPrefix.crushed, material);
        crushedStack.m_41764_(crushedStack.m_41613_() * property.getOreMultiplier());
        if (!crushedStack.m_41619_()) {
            GTRecipeBuilder builder = GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_raw_" + material.getName() + "_ore_to_crushed_ore").inputItems(TagPrefix.rawOre, material).category(GTRecipeCategories.ORE_FORGING).duration(10).EUt(16L);
            if (material.hasProperty(PropertyKey.GEM) && !ChemicalHelper.get(TagPrefix.gem, material).m_41619_()) {
                builder.outputItems(ChemicalHelper.get(TagPrefix.gem, material, crushedStack.m_41613_()).m_255036_(property.getOreMultiplier()));
            } else {
                builder.outputItems(crushedStack.m_255036_(property.getOreMultiplier()));
            }
            builder.save(provider);
            builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_raw_" + material.getName() + "_ore_to_crushed_ore").inputItems(TagPrefix.rawOre, material).outputItems(crushedStack.m_255036_(property.getOreMultiplier() * 2)).chancedOutput(byproductStack, 1400, 0).EUt(2L).category(GTRecipeCategories.ORE_CRUSHING).duration(400);
            builder.save(provider);
        }
        if (!ingotStack.m_41619_() && OreRecipeHandler.doesMaterialUseNormalFurnace(smeltingMaterial) && !TagPrefix.rawOre.isIgnored(material)) {
            float xp = (float)Math.round(7.0f) / 10.0f;
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_raw_" + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(TagPrefix.rawOre, material), ingotStack, xp);
            VanillaRecipeHelper.addBlastingRecipe(provider, "smelt_raw_" + material.getName() + "_ore_to_ingot", ChemicalHelper.getTag(TagPrefix.rawOre, material), ingotStack, xp);
        }
        if (!ConfigHolder.INSTANCE.recipes.disableManualCompression && !TagPrefix.rawOre.isIgnored(material)) {
            VanillaRecipeHelper.addShapedRecipe(provider, "compress_" + material.getName() + "_to_ore_block", ChemicalHelper.get(TagPrefix.rawOreBlock, material), "BBB", "BBB", "BBB", Character.valueOf('B'), ChemicalHelper.getTag(TagPrefix.rawOre, material));
            VanillaRecipeHelper.addShapelessRecipe(provider, "decompress_" + material.getName() + "_from_ore_block", ChemicalHelper.get(TagPrefix.rawOre, material, 9), ChemicalHelper.getTag(TagPrefix.rawOreBlock, material));
        }
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_to_raw_ore_block").inputItems(TagPrefix.rawOre, material, 9).outputItems(TagPrefix.rawOreBlock, material).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("decompress_" + material.getName() + "_to_raw_ore").inputItems(TagPrefix.rawOreBlock, material).outputItems(TagPrefix.rawOre, material, 9).category(GTRecipeCategories.ORE_FORGING).duration(300).EUt(2L).save(provider);
    }

    private static void processCrushedOre(@NotNull Consumer<FinishedRecipe> provider, @NotNull OreProperty property, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.crushed)) {
            return;
        }
        ItemStack impureDustStack = ChemicalHelper.get(TagPrefix.dustImpure, material);
        Material byproductMaterial = property.getOreByProduct(0, material);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_crushed_ore_to_impure_dust").inputItems(TagPrefix.crushed, material).outputItems(impureDustStack).duration(10).EUt(16L).category(GTRecipeCategories.ORE_FORGING).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_crushed_ore_to_impure_dust").inputItems(TagPrefix.crushed, material).outputItems(impureDustStack).duration(400).EUt(2L).chancedOutput(ChemicalHelper.get(TagPrefix.dust, byproductMaterial, property.getByProductMultiplier()), 1400, 0).category(GTRecipeCategories.ORE_CRUSHING).save(provider);
        ItemStack crushedPurifiedOre = GTUtil.copyFirst(ChemicalHelper.get(TagPrefix.crushedPurified, material), ChemicalHelper.get(TagPrefix.dust, material));
        ItemStack crushedCentrifugedOre = GTUtil.copyFirst(ChemicalHelper.get(TagPrefix.crushedRefined, material), ChemicalHelper.get(TagPrefix.dust, material));
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore_fast").inputItems(TagPrefix.crushed, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100)).outputItems(crushedPurifiedOre).duration(8).EUt(4L).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore").inputItems(TagPrefix.crushed, material).inputFluids(GTMaterials.Water.getFluid(1000)).circuitMeta(1).outputItems(crushedPurifiedOre).chancedOutput(TagPrefix.dust, byproductMaterial, "1/3", 0).outputItems(TagPrefix.dust, GTMaterials.Stone).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_crushed_ore_to_purified_ore_distilled").inputItems(TagPrefix.crushed, material).inputFluids(GTMaterials.DistilledWater.getFluid(100)).outputItems(crushedPurifiedOre).chancedOutput(TagPrefix.dust, byproductMaterial, "1/3", 0).outputItems(TagPrefix.dust, GTMaterials.Stone).duration(200).save(provider);
        GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_crushed_ore_to_refined_ore").inputItems(TagPrefix.crushed, material).outputItems(crushedCentrifugedOre).chancedOutput(TagPrefix.dust, property.getOreByProduct(1, material), property.getByProductMultiplier(), "1/3", 0).outputItems(TagPrefix.dust, GTMaterials.Stone).save(provider);
        if (!((Material)property.getWashedIn().first()).isNull()) {
            Material washingByproduct = property.getOreByProduct(3, material);
            ObjectIntPair<Material> washedInTuple = property.getWashedIn();
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("bathe_" + material.getName() + "_crushed_ore_to_purified_ore").inputItems(TagPrefix.crushed, material).inputFluids(((Material)washedInTuple.first()).getFluid(washedInTuple.secondInt())).outputItems(crushedPurifiedOre).chancedOutput(ChemicalHelper.get(TagPrefix.dust, washingByproduct, property.getByProductMultiplier()), 7000, 0).chancedOutput(ChemicalHelper.get(TagPrefix.dust, GTMaterials.Stone), 4000, 0).duration(200).EUt(GTValues.VA[1]).category(GTRecipeCategories.ORE_BATHING).save(provider);
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("crushed_ore_to_dust_%s", material.getName()), impureDustStack, Character.valueOf('h'), new MaterialEntry(TagPrefix.crushed, material));
        OreRecipeHandler.processMetalSmelting(provider, property, TagPrefix.crushed, material);
    }

    private static void processCrushedCentrifuged(@NotNull Consumer<FinishedRecipe> provider, @NotNull OreProperty property, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.crushedRefined)) {
            return;
        }
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        ItemStack byproductStack = ChemicalHelper.get(TagPrefix.dust, property.getOreByProduct(2, material), 1);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_refined_ore_to_dust").inputItems(TagPrefix.crushedRefined, material).outputItems(dustStack).duration(10).EUt(16L).category(GTRecipeCategories.ORE_FORGING).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_refined_ore_to_dust").inputItems(TagPrefix.crushedRefined, material).outputItems(dustStack).chancedOutput(byproductStack, 1400, 0).duration(400).EUt(2L).category(GTRecipeCategories.ORE_CRUSHING).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("centrifuged_ore_to_dust_%s", material.getName()), dustStack, Character.valueOf('h'), new MaterialEntry(TagPrefix.crushedRefined, material));
        OreRecipeHandler.processMetalSmelting(provider, property, TagPrefix.crushedRefined, material);
    }

    private static void processCrushedPurified(@NotNull Consumer<FinishedRecipe> provider, @NotNull OreProperty property, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.crushedPurified)) {
            return;
        }
        ItemStack crushedCentrifugedStack = ChemicalHelper.get(TagPrefix.crushedRefined, material);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dustPure, material);
        Material byproductMaterial = property.getOreByProduct(1, material);
        ItemStack byproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_crushed_ore_to_dust").inputItems(TagPrefix.crushedPurified, material).outputItems(dustStack).duration(10).EUt(16L).category(GTRecipeCategories.ORE_FORGING).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + material.getName() + "_crushed_ore_to_dust").inputItems(TagPrefix.crushedPurified, material).outputItems(dustStack).chancedOutput(byproductStack, 1400, 0).duration(400).EUt(2L).category(GTRecipeCategories.ORE_CRUSHING).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("purified_ore_to_dust_%s", material.getName()), dustStack, Character.valueOf('h'), new MaterialEntry(TagPrefix.crushedPurified, material));
        if (!crushedCentrifugedStack.m_41619_()) {
            GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_purified_ore_to_refined_ore").inputItems(TagPrefix.crushedPurified, material).outputItems(crushedCentrifugedStack).chancedOutput(TagPrefix.dust, byproductMaterial, "1/3", 0).save(provider);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack exquisiteStack = ChemicalHelper.get(TagPrefix.gemExquisite, material);
            ItemStack flawlessStack = ChemicalHelper.get(TagPrefix.gemFlawless, material);
            ItemStack gemStack = ChemicalHelper.get(TagPrefix.gem, material);
            ItemStack flawedStack = ChemicalHelper.get(TagPrefix.gemFlawed, material);
            ItemStack chippedStack = ChemicalHelper.get(TagPrefix.gemChipped, material);
            if (material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT)) {
                GTRecipeBuilder builder = GTRecipeTypes.SIFTER_RECIPES.recipeBuilder("sift_" + material.getName() + "_purified_ore_to_gems").inputItems(TagPrefix.crushedPurified, material).chancedOutput(exquisiteStack, 500, 0).chancedOutput(flawlessStack, 1500, 0).chancedOutput(gemStack, 5000, 0).chancedOutput(dustStack, 2500, 0).duration(400).EUt(16L);
                if (!flawedStack.m_41619_()) {
                    builder.chancedOutput(flawedStack, 2000, 0);
                }
                if (!chippedStack.m_41619_()) {
                    builder.chancedOutput(chippedStack, 3000, 0);
                }
                builder.save(provider);
            } else {
                GTRecipeBuilder builder = GTRecipeTypes.SIFTER_RECIPES.recipeBuilder("sift_" + material.getName() + "_purified_ore_to_gems").inputItems(TagPrefix.crushedPurified, material).chancedOutput(exquisiteStack, 300, 0).chancedOutput(flawlessStack, 1000, 0).chancedOutput(gemStack, 3500, 0).chancedOutput(dustStack, 5000, 0).duration(400).EUt(16L);
                if (!flawedStack.m_41619_()) {
                    builder.chancedOutput(flawedStack, 2500, 0);
                }
                if (!chippedStack.m_41619_()) {
                    builder.chancedOutput(chippedStack, 3500, 0);
                }
                builder.save(provider);
            }
        }
        OreRecipeHandler.processMetalSmelting(provider, property, TagPrefix.crushedPurified, material);
    }

    private static void processDirtyDust(@NotNull Consumer<FinishedRecipe> provider, @NotNull OreProperty property, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.dustImpure)) {
            return;
        }
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        Material byproduct = property.getOreByProduct(0, material);
        GTRecipeBuilder builder = GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_dirty_dust_to_dust").inputItems(TagPrefix.dustImpure, material).outputItems(dustStack).duration((int)(material.getMass() * 4L)).EUt(24L);
        if (byproduct.hasProperty(PropertyKey.DUST)) {
            builder.chancedOutput(TagPrefix.dust, byproduct, "1/9", 0);
        } else {
            builder.outputFluids(byproduct.getFluid(16));
        }
        builder.save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_dirty_dust_to_dust").inputItems(TagPrefix.dustImpure, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100)).outputItems(dustStack).duration(8).EUt(4L).save(provider);
        OreRecipeHandler.processMetalSmelting(provider, property, TagPrefix.dustImpure, material);
    }

    private static void processPureDust(@NotNull Consumer<FinishedRecipe> provider, @NotNull OreProperty property, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.dustPure)) {
            return;
        }
        Material byproductMaterial = property.getOreByProduct(1, material);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        if (property.getSeparatedInto() != null && !property.getSeparatedInto().isEmpty()) {
            List<Material> separatedMaterial = property.getSeparatedInto();
            TagPrefix prefix = separatedMaterial.get(separatedMaterial.size() - 1).getBlastTemperature() == 0 && separatedMaterial.get(separatedMaterial.size() - 1).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dust;
            ItemStack separatedStack2 = ChemicalHelper.get(prefix, separatedMaterial.get(separatedMaterial.size() - 1), prefix == TagPrefix.nugget ? 2 : 1);
            GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder("separate_" + material.getName() + "_pure_dust_to_dust").inputItems(TagPrefix.dustPure, material).outputItems(dustStack).chancedOutput(TagPrefix.dust, separatedMaterial.get(0), 1000, 0).chancedOutput(separatedStack2, prefix == TagPrefix.dust ? 500 : 2000, 0).duration(200).EUt(24L).save(provider);
        }
        GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("centrifuge_" + material.getName() + "_pure_dust_to_dust").inputItems(TagPrefix.dustPure, material).outputItems(dustStack).chancedOutput(TagPrefix.dust, byproductMaterial, "1/9", 0).duration(100).EUt(5L).save(provider);
        GTRecipeTypes.ORE_WASHER_RECIPES.recipeBuilder("wash_" + material.getName() + "_pure_dust_to_dust").inputItems(TagPrefix.dustPure, material).circuitMeta(2).inputFluids(GTMaterials.Water.getFluid(100)).outputItems(dustStack).duration(8).EUt(4L).save(provider);
        OreRecipeHandler.processMetalSmelting(provider, property, TagPrefix.dustPure, material);
    }

    private static boolean doesMaterialUseNormalFurnace(@NotNull Material material) {
        return !material.hasProperty(PropertyKey.BLAST) && !material.hasFlag(MaterialFlags.NO_ORE_SMELTING);
    }
}

