/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.common.machine.storage.CreativeTankMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferProxyPartMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.FluidStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.FluidTextHelper;
import snownee.jade.util.JadeForgeUtils;

public enum GTFluidStorageProvider implements IServerExtensionProvider<MetaMachineBlockEntity, CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return GTCEu.id("custom_fluid_storage");
    }

    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return ClientViewGroup.map(groups, GTFluidStorageProvider::readFluid, null);
    }

    @Nullable
    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer serverPlayer, ServerLevel serverLevel, MetaMachineBlockEntity mmbe, boolean b) {
        MetaMachine machine = mmbe.getMetaMachine();
        if (machine instanceof QuantumTankMachine) {
            QuantumTankMachine qtm = (QuantumTankMachine)machine;
            FluidStack stored = qtm.getStored();
            if (stored.isEmpty() && qtm instanceof CreativeTankMachine) {
                return Collections.emptyList();
            }
            CompoundTag tag = JadeForgeUtils.fromFluidStack((FluidStack)stored, (long)qtm.getMaxAmount());
            tag.m_128379_("special", true);
            tag.m_128356_("amount", qtm.getStoredAmount());
            return List.of(new ViewGroup(List.of(tag)));
        }
        if (GTCEu.Mods.isAE2Loaded() && machine instanceof MEPatternBufferPartMachine) {
            MEPatternBufferPartMachine buffer = (MEPatternBufferPartMachine)machine;
            NotifiableFluidTank tank = buffer.getShareTank();
            ArrayList<CompoundTag> list = new ArrayList<CompoundTag>(tank.getTanks());
            for (CustomFluidTank storage : tank.getStorages()) {
                FluidStack stack = storage.getFluid();
                if (stack.isEmpty()) continue;
                int capacity = storage.getCapacity();
                list.add(JadeForgeUtils.fromFluidStack((FluidStack)stack, (long)capacity));
            }
            return list.isEmpty() ? List.of() : List.of(new ViewGroup(list));
        }
        if (GTCEu.Mods.isAE2Loaded() && machine instanceof MEPatternBufferProxyPartMachine) {
            MEPatternBufferProxyPartMachine proxy = (MEPatternBufferProxyPartMachine)machine;
            MEPatternBufferPartMachine buffer = proxy.getBuffer();
            if (buffer == null) {
                return Collections.emptyList();
            }
            return FluidStorageProvider.INSTANCE.getGroups(serverPlayer, serverLevel, (Object)buffer.holder, b);
        }
        return FluidStorageProvider.INSTANCE.getGroups(serverPlayer, serverLevel, (Object)mmbe, b);
    }

    private static FluidView readFluid(CompoundTag tag) {
        if (!tag.m_128441_("special")) {
            return FluidView.readDefault((CompoundTag)tag);
        }
        long capacity = tag.m_128454_("capacity");
        if (capacity <= 0L) {
            return null;
        }
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(tag.m_128461_("fluid")));
        CompoundTag nbt = tag.m_128441_("tag") ? tag.m_128469_("tag") : null;
        long amount = tag.m_128454_("amount");
        JadeFluidObject fluidObject = JadeFluidObject.of((Fluid)fluid, (long)1000L, (CompoundTag)nbt);
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluidObject));
        fluidView.fluidName = fluid.getFluidType().getDescription();
        fluidView.current = FluidTextHelper.getUnicodeMillibuckets((long)amount, (boolean)true);
        fluidView.max = FluidTextHelper.getUnicodeMillibuckets((long)capacity, (boolean)true);
        fluidView.ratio = Math.min(1.0f, (float)((double)amount / (double)capacity));
        return fluidView;
    }
}

