/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KJSTieredMultiblockBuilder
extends BuilderBase<MultiblockMachineDefinition[]> {
    private final MultiblockMachineBuilder[] builders = new MultiblockMachineBuilder[GTValues.TIER_COUNT];
    public volatile int[] tiers = GTMachineUtils.ELECTRIC_TIERS;
    public volatile TieredCreationFunction machine;
    public volatile DefinitionFunction definition = (tier, def) -> def.tier(tier);

    public KJSTieredMultiblockBuilder(ResourceLocation id) {
        super(id);
    }

    public KJSTieredMultiblockBuilder(ResourceLocation id, TieredCreationFunction machine) {
        super(id);
        this.machine = machine;
    }

    @Override
    public void generateAssetJsons(@Nullable AssetJsonGenerator generator) {
        super.generateAssetJsons(generator);
        for (int tier : this.tiers) {
            MultiblockMachineBuilder builder = this.builders[tier];
            if (builder == null) continue;
            builder.generateAssetJsons(generator);
        }
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        for (int tier : this.tiers) {
            MultiblockMachineBuilder builder = this.builders[tier];
            if (builder == null) continue;
            builder.generateLang(lang);
        }
    }

    @Override
    public @Nullable MultiblockMachineDefinition @NotNull [] register() {
        Preconditions.checkNotNull((Object)this.tiers, (Object)"Tiers can't be null!");
        Preconditions.checkArgument((this.tiers.length > 0 ? 1 : 0) != 0, (Object)"tiers must have at least one tier!");
        Preconditions.checkNotNull((Object)this.machine, (Object)"You must set a machine creation function! example: `builder.machine((holder, tier) => new SimpleTieredMachine(holder, tier, t => t * 3200)`");
        Preconditions.checkNotNull((Object)this.definition, (Object)"You must set a definition function! See GTMachines for examples");
        MultiblockMachineDefinition[] definitions = new MultiblockMachineDefinition[GTValues.TIER_COUNT];
        for (int tier : this.tiers) {
            String tierName = GTValues.VN[tier].toLowerCase(Locale.ROOT);
            MultiblockMachineBuilder builder = GTRegistration.REGISTRATE.multiblock(String.format("%s_%s", tierName, this.id.m_135815_()), holder -> this.machine.create((IMachineBlockEntity)holder, tier));
            builder.workableTieredHullModel(this.id.m_246208_("block/machines/")).tier(tier);
            this.definition.apply(tier, builder);
            this.builders[tier] = builder;
            definitions[tier] = builder.register();
        }
        this.value = definitions;
        return definitions;
    }

    @NotNull
    @Generated
    public KJSTieredMultiblockBuilder tiers(int[] tiers) {
        this.tiers = tiers;
        return this;
    }

    @NotNull
    @Generated
    public KJSTieredMultiblockBuilder machine(TieredCreationFunction machine) {
        this.machine = machine;
        return this;
    }

    @NotNull
    @Generated
    public KJSTieredMultiblockBuilder definition(DefinitionFunction definition) {
        this.definition = definition;
        return this;
    }

    @FunctionalInterface
    public static interface DefinitionFunction {
        public void apply(int var1, MachineBuilder<?> var2);
    }

    @FunctionalInterface
    public static interface TieredCreationFunction {
        public MultiblockControllerMachine create(IMachineBlockEntity var1, int var2);
    }
}

