/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.client.renderer.block.MaterialBlockRenderer;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MaterialBlock
extends Block {
    public final TagPrefix tagPrefix;
    public final Material material;
    public static VoxelShape FRAME_COLLISION_BOX = Shapes.box((double)0.05, (double)0.0, (double)0.05, (double)0.95, (double)1.0, (double)0.95);

    public MaterialBlock(BlockBehaviour.Properties properties, TagPrefix tagPrefix, Material material, boolean registerModel) {
        super(properties);
        this.material = material;
        this.tagPrefix = tagPrefix;
        if (registerModel && GTCEu.isClientSide()) {
            MaterialBlockRenderer.create(this, tagPrefix.materialIconType(), material.getMaterialIconSet());
        }
    }

    public MaterialBlock(BlockBehaviour.Properties properties, TagPrefix tagPrefix, Material material) {
        this(properties, tagPrefix, material, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedColor() {
        return (state, reader, pos, tintIndex) -> {
            Block patt3403$temp = state.getBlock();
            if (patt3403$temp instanceof MaterialBlock) {
                MaterialBlock block = (MaterialBlock)patt3403$temp;
                return block.material.getLayerARGB(tintIndex);
            }
            return -1;
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.tagPrefix == TagPrefix.frameGt) {
            return FRAME_COLLISION_BOX;
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall) {
            level.scheduleTick(currentPos, (Block)this, this.getDelayAfterPlace());
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) || pos.getY() < level.getMinBuildHeight()) {
            return;
        }
        FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!(TagPrefix.ORES.containsKey(this.tagPrefix) && TagPrefix.ORES.get(this.tagPrefix).isSand() && ConfigHolder.INSTANCE.worldgen.sandOresFall)) {
            return;
        }
        if (random.nextInt(16) == 0 && FallingBlock.isFree((BlockState)level.getBlockState(pos.below()))) {
            double d = (double)pos.getX() + random.nextDouble();
            double e = (double)pos.getY() - 0.05;
            double f = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public String getDescriptionId() {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public MutableComponent getName() {
        return this.tagPrefix.getLocalizedName(this.material);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.tagPrefix != TagPrefix.frameGt) {
            return super.use(state, level, pos, player, hand, hit);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (stack.getItem() instanceof PipeBlockItem) {
            return this.replaceWithFramedPipe(level, pos, state, player, stack, hit) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        Set<GTToolType> types = ToolHelper.getToolTypes(stack);
        if (!types.isEmpty() && ToolHelper.canUse(stack) && types.contains(GTToolType.CROWBAR)) {
            return this.removeFrame(level, pos, player, stack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        MaterialBlock frameBlock = MaterialBlock.getFrameboxFromItem(stack);
        if (frameBlock == null) {
            return InteractionResult.PASS;
        }
        BlockPos.MutableBlockPos blockPos = pos.mutable();
        for (int i = 0; i < 32; ++i) {
            PipeBlockEntity pbe;
            BlockEntity te;
            Block block = level.getBlockState((BlockPos)blockPos).getBlock();
            if (block instanceof MaterialBlock) {
                MaterialBlock matBlock = (MaterialBlock)block;
                if (matBlock.tagPrefix == TagPrefix.frameGt) {
                    blockPos.move(Direction.UP);
                    continue;
                }
            }
            if ((te = level.getBlockEntity((BlockPos)blockPos)) instanceof PipeBlockEntity && !(pbe = (PipeBlockEntity)te).getFrameMaterial().isNull()) {
                blockPos.move(Direction.UP);
                continue;
            }
            if (MaterialBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)blockPos.below())) {
                level.setBlock((BlockPos)blockPos, frameBlock.defaultBlockState(), 3);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (te instanceof PipeBlockEntity && (pbe = (PipeBlockEntity)te).getFrameMaterial().isNull()) {
                pbe.setFrameMaterial(frameBlock.material);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static MaterialBlock getFrameboxFromItem(ItemStack stack) {
        BlockItem ib;
        Block block;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (block = (ib = (BlockItem)item).getBlock()) instanceof MaterialBlock) {
            MaterialBlock matBlock = (MaterialBlock)block;
            return matBlock.tagPrefix == TagPrefix.frameGt ? matBlock : null;
        }
        return null;
    }

    public boolean removeFrame(Level level, BlockPos pos, Player player, ItemStack stack) {
        PipeBlockEntity pipeTile;
        Material mat;
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof PipeBlockEntity && !(mat = (pipeTile = (PipeBlockEntity)te).getFrameMaterial()).isNull()) {
            pipeTile.setFrameMaterial(GTMaterials.NULL);
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)this.asItem().getDefaultInstance());
            ToolHelper.damageItem(stack, (LivingEntity)player);
            ToolHelper.playToolSound(GTToolType.CROWBAR, (ServerPlayer)player);
            return true;
        }
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        if (this.tagPrefix == TagPrefix.frameGt && useContext.getItemInHand().getItem() instanceof PipeBlockItem && !useContext.getPlayer().isCrouching()) {
            return true;
        }
        return super.canBeReplaced(state, useContext);
    }

    public boolean replaceWithFramedPipe(Level level, BlockPos pos, BlockState state, Player player, ItemStack stackInHand, BlockHitResult hit) {
        PipeBlock pipeBlock = ((PipeBlockItem)stackInHand.getItem()).getBlock();
        if (((IPipeType)pipeBlock.pipeType).getThickness() < 1.0f) {
            PipeBlockItem itemBlock = (PipeBlockItem)stackInHand.getItem();
            BlockState pipeState = pipeBlock.defaultBlockState();
            BlockPlaceContext context = new BlockPlaceContext(level, player, InteractionHand.MAIN_HAND, stackInHand, hit);
            BlockState original = level.getBlockState(context.getClickedPos());
            itemBlock.placeBlock(context, pipeState);
            IPipeNode pipeTile = pipeBlock.getPipeTile((BlockGetter)level, pos);
            if (!(pipeTile instanceof PipeBlockEntity)) {
                level.setBlockAndUpdate(context.getClickedPos(), original);
                return false;
            }
            PipeBlockEntity pipeBlockEntity = (PipeBlockEntity)pipeTile;
            pipeBlockEntity.setFrameMaterial(this.material);
            SoundType type = VanillaRecipeHelper.isMaterialWood(pipeTile.getFrameMaterial()) ? SoundType.WOOD : SoundType.METAL;
            level.playSound(player, pos, type.getPlaceSound(), SoundSource.BLOCKS, (type.getVolume() + 1.0f) / 2.0f, type.getPitch() * 0.8f);
            if (!player.isCreative()) {
                stackInHand.shrink(1);
            }
            return true;
        }
        return false;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.tagPrefix == TagPrefix.frameGt && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double currentAccel = 0.15 * (livingEntity.getDeltaMovement().y < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = 0.9 * (livingEntity.isInWater() ? 0.4 : 1.0);
            Vec3 deltaMovement = livingEntity.getDeltaMovement();
            livingEntity.resetFallDistance();
            float f = 0.15f;
            double d0 = Mth.clamp((double)deltaMovement.x, (double)(-f), (double)f);
            double d1 = Mth.clamp((double)deltaMovement.z, (double)(-f), (double)f);
            double d2 = Math.max(deltaMovement.y, (double)(-f));
            if (d2 < 0.0 && !livingEntity.getFeetBlockState().isScaffolding(livingEntity) && livingEntity.isSuppressingSlidingDownLadder() && livingEntity instanceof Player) {
                d2 = Math.min(deltaMovement.y + currentAccel, 0.0);
            }
            if (livingEntity.horizontalCollision) {
                d2 = 0.3;
            }
            deltaMovement = new Vec3(d0, d2, d1);
            entity.setDeltaMovement(deltaMovement);
        }
    }
}

