/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MetaMachineBlock
extends Block
implements IMachineBlock {
    public final MachineDefinition definition;

    public MetaMachineBlock(BlockBehaviour.Properties properties, MachineDefinition definition) {
        super(properties);
        this.definition = definition;
        RotationState rotationState = definition.getRotationState();
        if (rotationState != RotationState.NONE) {
            BlockState defaultState = (BlockState)this.defaultBlockState().setValue((Property)rotationState.property, (Comparable)rotationState.defaultDirection);
            if (definition.isAllowExtendedFacing()) {
                defaultState = (BlockState)defaultState.setValue((Property)GTBlockStateProperties.UPWARDS_FACING, (Comparable)Direction.NORTH);
            }
            this.registerDefaultState(defaultState);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        RotationState rotationState = MachineDefinition.getBuilt().getRotationState();
        if (rotationState != RotationState.NONE) {
            pBuilder.add(new Property[]{rotationState.property});
            if (MachineDefinition.getBuilt().isAllowExtendedFacing()) {
                pBuilder.add(new Property[]{GTBlockStateProperties.UPWARDS_FACING});
            }
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getRotationState() == RotationState.NONE ? this.definition.getShape(Direction.NORTH) : this.definition.getShape((Direction)pState.getValue((Property)this.getRotationState().property));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        MetaMachine machine = this.getMachine((BlockGetter)level, pos);
        if (machine != null) {
            machine.animateTick(random);
        }
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity player, ItemStack pStack) {
        if (!pLevel.isClientSide) {
            MetaMachine machine = this.getMachine((BlockGetter)pLevel, pPos);
            if (machine != null && player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                machine.setOwnerUUID(sPlayer.getUUID());
                machine.markDirty();
            }
            if (machine instanceof IDropSaveMachine) {
                IDropSaveMachine dropSaveMachine = (IDropSaveMachine)((Object)machine);
                CompoundTag tag = pStack.getTag();
                if (tag != null) {
                    dropSaveMachine.loadFromItem(tag);
                }
            }
            if (machine instanceof IMachineLife) {
                IMachineLife machineLife = (IMachineLife)((Object)machine);
                machineLife.onMachinePlaced(player, pStack);
            }
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        level.updateNeighbourForOutputSignal(pos, (Block)this);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        RotationState rotationState = this.getRotationState();
        Player player = context.getPlayer();
        BlockPos blockPos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        if (player != null && rotationState != RotationState.NONE) {
            state = rotationState == RotationState.Y_AXIS ? (BlockState)state.setValue((Property)rotationState.property, (Comparable)Direction.UP) : (BlockState)state.setValue((Property)rotationState.property, (Comparable)player.getDirection().getOpposite());
            Vec3 pos = player.position();
            if (Math.abs(pos.x - (double)((float)blockPos.getX() + 0.5f)) < 2.0 && Math.abs(pos.z - (double)((float)blockPos.getZ() + 0.5f)) < 2.0) {
                double d0 = pos.y + (double)player.getEyeHeight();
                if (d0 - (double)blockPos.getY() > 2.0 && rotationState.test(Direction.UP)) {
                    state = (BlockState)state.setValue((Property)rotationState.property, (Comparable)Direction.UP);
                }
                if ((double)blockPos.getY() - d0 > 0.0 && rotationState.test(Direction.DOWN)) {
                    state = (BlockState)state.setValue((Property)rotationState.property, (Comparable)Direction.DOWN);
                }
            }
            if (this.getDefinition().isAllowExtendedFacing()) {
                Direction frontFacing = (Direction)state.getValue((Property)rotationState.property);
                if (frontFacing == Direction.UP) {
                    state = (BlockState)state.setValue((Property)GTBlockStateProperties.UPWARDS_FACING, (Comparable)player.getDirection());
                } else if (frontFacing == Direction.DOWN) {
                    state = (BlockState)state.setValue((Property)GTBlockStateProperties.UPWARDS_FACING, (Comparable)player.getDirection().getOpposite());
                }
            }
        }
        return state;
    }

    public ItemStack getCloneItemStack(BlockGetter level, BlockPos pos, BlockState state) {
        IDropSaveMachine dropSaveMachine;
        ItemStack itemStack = super.getCloneItemStack(level, pos, state);
        MetaMachine metaMachine = this.getMachine(level, pos);
        if (metaMachine instanceof IDropSaveMachine && (dropSaveMachine = (IDropSaveMachine)((Object)metaMachine)).savePickClone()) {
            dropSaveMachine.saveToItem(itemStack.getOrCreateTag());
        }
        return itemStack;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        MultiblockMachineDefinition multiblockDefinition;
        BlockPattern pattern;
        MachineDefinition machineDefinition;
        this.definition.getTooltipBuilder().accept(stack, tooltip);
        String mainKey = String.format("%s.machine.%s.tooltip", this.definition.getId().getNamespace(), this.definition.getId().getPath());
        if (GTUtil.isShiftDown() && (machineDefinition = this.definition) instanceof MultiblockMachineDefinition && (pattern = (multiblockDefinition = (MultiblockMachineDefinition)machineDefinition).getPatternFactory().get()) != null) {
            int[] aisleDims = pattern.getDimensions();
            assert (aisleDims.length == 3);
            tooltip.add((Component)Component.translatable((String)"gtceu.multiblock.dimension", (Object[])new Object[]{aisleDims[0], aisleDims[1], aisleDims[2]}));
        }
        if (Language.getInstance().has(mainKey)) {
            tooltip.add(1, (Component)Component.translatable((String)mainKey));
        }
    }

    public boolean triggerEvent(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        BlockEntity tile = pLevel.getBlockEntity(pPos);
        if (tile != null) {
            return tile.triggerEvent(pId, pParam);
        }
        return false;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        if (this.getRotationState() == RotationState.NONE) {
            return pState;
        }
        return (BlockState)pState.setValue((Property)this.getRotationState().property, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)this.getRotationState().property)));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity tileEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        List drops = super.getDrops(state, builder);
        if (tileEntity instanceof IMachineBlockEntity) {
            IDropSaveMachine dropSaveMachine;
            IMachineBlockEntity holder = (IMachineBlockEntity)tileEntity;
            MetaMachine machine = holder.getMetaMachine();
            if (machine instanceof IMachineModifyDrops) {
                IMachineModifyDrops machineModifyDrops = (IMachineModifyDrops)((Object)machine);
                machineModifyDrops.onDrops(drops);
            }
            if (machine instanceof IDropSaveMachine && (dropSaveMachine = (IDropSaveMachine)((Object)machine)).saveBreak()) {
                for (ItemStack drop : drops) {
                    MetaMachineItem item;
                    Item item2 = drop.getItem();
                    if (!(item2 instanceof MetaMachineItem) || (item = (MetaMachineItem)item2).getBlock() != this) continue;
                    dropSaveMachine.saveToItem(drop.getOrCreateTag());
                    break;
                }
            }
        }
        return drops;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.hasBlockEntity()) {
            if (!pState.is(pNewState.getBlock())) {
                MetaMachine machine = this.getMachine((BlockGetter)pLevel, pPos);
                if (machine instanceof IMachineLife) {
                    Direction[] machineLife = (Direction[])machine;
                    machineLife.onMachineRemoved();
                }
                if (machine != null) {
                    for (Direction direction : GTUtil.DIRECTIONS) {
                        machine.getCoverContainer().removeCover(direction, null);
                    }
                }
                pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
                pLevel.removeBlockEntity(pPos);
            } else if (this.getRotationState() != RotationState.NONE) {
                MetaMachine machine;
                Direction oldFacing = (Direction)pState.getValue((Property)this.getRotationState().property);
                Direction newFacing = (Direction)pNewState.getValue((Property)this.getRotationState().property);
                if (newFacing != oldFacing && (machine = this.getMachine((BlockGetter)pLevel, pPos)) != null) {
                    machine.onRotated(oldFacing, newFacing);
                }
            }
        }
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IInteractedMachine interactedMachine;
        InteractionResult result;
        Item serverPlayer;
        MetaMachine machine = this.getMachine((BlockGetter)world, pos);
        ItemStack itemStack = player.getItemInHand(hand);
        boolean shouldOpenUi = true;
        if (machine != null && machine.getOwnerUUID() == null && player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            machine.setOwnerUUID(sPlayer.getUUID());
            machine.markDirty();
        }
        Set<GTToolType> types = ToolHelper.getToolTypes(itemStack);
        if (machine != null && (!types.isEmpty() && ToolHelper.canUse(itemStack) || types.isEmpty() && player.isShiftKeyDown())) {
            Pair<GTToolType, InteractionResult> result2 = machine.onToolClick(types, itemStack, new UseOnContext(player, hand, hit));
            if (result2.getSecond() == InteractionResult.CONSUME && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                ToolHelper.playToolSound((GTToolType)result2.getFirst(), (ServerPlayer)serverPlayer);
                if (!serverPlayer.isCreative()) {
                    ToolHelper.damageItem(itemStack, (LivingEntity)serverPlayer, 1);
                }
            }
            if (result2.getSecond() != InteractionResult.PASS) {
                return (InteractionResult)result2.getSecond();
            }
        }
        if (itemStack.is((Item)GTItems.PORTABLE_SCANNER.get())) {
            return itemStack.getItem().use(world, player, hand).getResult();
        }
        serverPlayer = itemStack.getItem();
        if (serverPlayer instanceof IGTTool) {
            IGTTool gtToolItem = (IGTTool)serverPlayer;
            shouldOpenUi = gtToolItem.definition$shouldOpenUIAfterUse(new UseOnContext(player, hand, hit));
        }
        if (machine instanceof IInteractedMachine && (result = (interactedMachine = (IInteractedMachine)((Object)machine)).onUse(state, world, pos, player, hand, hit)) != InteractionResult.PASS) {
            return result;
        }
        if (shouldOpenUi && machine instanceof IUIMachine) {
            IUIMachine uiMachine = (IUIMachine)((Object)machine);
            if (MachineOwner.canOpenOwnerMachine(player, machine)) {
                return uiMachine.tryToOpenUI(player, hand, hit);
            }
        }
        return shouldOpenUi ? InteractionResult.PASS : InteractionResult.CONSUME;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getMachine(level, pos).getOutputSignal(direction);
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getMachine(level, pos).getOutputDirectSignal(direction);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return this.getMachine((BlockGetter)level, pos).getAnalogOutputSignal();
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        MetaMachine machine = this.getMachine((BlockGetter)level, pos);
        if (machine != null) {
            machine.onNeighborChanged(block, fromPos, isMoving);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        MetaMachine machine = this.getMachine((BlockGetter)level, pos);
        if (machine != null) {
            return machine.getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
        }
        return super.getAppearance(state, level, pos, side, sourceState, sourcePos);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    @Override
    @Generated
    public MachineDefinition getDefinition() {
        return this.definition;
    }
}

