/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.block.PipeBlockRenderer;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class PipeBlock<PipeType extends Enum<PipeType>, NodeDataType, WorldPipeNetType extends LevelPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends Block
implements EntityBlock,
IBlockRendererProvider,
SimpleWaterloggedBlock {
    public final PipeType pipeType;

    public PipeBlock(BlockBehaviour.Properties properties, PipeType pipeType) {
        super(properties);
        this.pipeType = pipeType;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BlockStateProperties.WATERLOGGED}));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public final PipeBlockEntity<PipeType, NodeDataType> newBlockEntity(BlockPos pos, BlockState state) {
        return (PipeBlockEntity)this.getBlockEntityType().create(pos, state);
    }

    public abstract WorldPipeNetType getWorldPipeNet(ServerLevel var1);

    public abstract BlockEntityType<? extends PipeBlockEntity<PipeType, NodeDataType>> getBlockEntityType();

    public abstract NodeDataType createRawData(BlockState var1, @Nullable ItemStack var2);

    public NodeDataType createProperties(BlockState state, @Nullable ItemStack stack) {
        return ((IPipeType)this.pipeType).modifyProperties(this.createRawData(state, stack));
    }

    public abstract NodeDataType createProperties(IPipeNode<PipeType, NodeDataType> var1);

    public abstract NodeDataType getFallbackType();

    @Nullable
    public abstract PipeBlockRenderer getRenderer(BlockState var1);

    protected abstract PipeModel getPipeModel();

    public void updateActiveNodeStatus(@NotNull Level worldIn, BlockPos pos, IPipeNode<PipeType, NodeDataType> pipeTile) {
        int activeConnections;
        boolean isActiveNodeNow;
        boolean modeChanged;
        if (worldIn.isClientSide) {
            return;
        }
        Object pipeNet = ((LevelPipeNet)((Object)this.getWorldPipeNet((ServerLevel)worldIn))).getNetFromPos(pos);
        if (pipeNet != null && pipeTile != null && (modeChanged = ((PipeNet)pipeNet).markNodeAsActive(pos, isActiveNodeNow = (activeConnections = pipeTile.getConnections()) != 0))) {
            this.onActiveModeChange(worldIn, pos, isActiveNodeNow, false);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (level.isClientSide()) {
            return;
        }
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null) {
            PipeNet<NodeDataType> net;
            Direction facing = GTUtil.getFacingToNeighbor(pos, neighbor);
            if (facing == null) {
                return;
            }
            CoverBehavior cover = pipeTile.getCoverContainer().getCoverAtSide(facing);
            if (!ConfigHolder.INSTANCE.machines.gt6StylePipesCables) {
                boolean canConnect;
                boolean open = pipeTile.isConnected(facing);
                boolean bl = canConnect = cover != null || this.canConnect(pipeTile, facing);
                if (!open && canConnect) {
                    pipeTile.setConnection(facing, true, false);
                }
                if (open && !canConnect) {
                    pipeTile.setConnection(facing, false, false);
                }
                this.updateActiveNodeStatus(pipeTile.getPipeLevel(), pos, pipeTile);
            }
            if ((net = pipeTile.getPipeNet()) != null) {
                pipeTile.getPipeNet().onNeighbourUpdate(neighbor);
            }
            if (cover != null) {
                cover.onNeighborChanged(state.getBlock(), pos, false);
            }
        }
    }

    @Nullable
    public IPipeNode<PipeType, NodeDataType> getPipeTile(BlockGetter level, BlockPos pos) {
        IPipeNode pipeTile;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IPipeNode && ((IPipeType)(pipeTile = (IPipeNode)blockEntity).getPipeType()).type().equals((Object)((IPipeType)this.pipeType).type())) {
            return pipeTile;
        }
        return null;
    }

    protected void onActiveModeChange(Level world, BlockPos pos, boolean isActiveNow, boolean isInitialChange) {
    }

    public boolean canConnect(IPipeNode<PipeType, NodeDataType> selfTile, Direction facing) {
        if (selfTile.getPipeLevel().getBlockState(selfTile.getPipePos().relative(facing)).getBlock() == Blocks.AIR) {
            return false;
        }
        CoverBehavior cover = selfTile.getCoverContainer().getCoverAtSide(facing);
        if (cover != null && !cover.canPipePassThrough()) {
            return false;
        }
        BlockEntity other = selfTile.getNeighbor(facing);
        if (other instanceof IPipeNode) {
            IPipeNode node = (IPipeNode)other;
            cover = node.getCoverContainer().getCoverAtSide(facing.getOpposite());
            if (cover != null && !cover.canPipePassThrough()) {
                return false;
            }
            return this.canPipesConnect(selfTile, facing, (IPipeNode)other);
        }
        return this.canPipeConnectToBlock(selfTile, facing, other);
    }

    public abstract boolean canPipesConnect(IPipeNode<PipeType, NodeDataType> var1, Direction var2, IPipeNode<PipeType, NodeDataType> var3);

    public abstract boolean canPipeConnectToBlock(IPipeNode<PipeType, NodeDataType> var1, Direction var2, @Nullable BlockEntity var3);

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null && placer instanceof Player) {
            Player player = (Player)placer;
            ItemStack offhand = placer.getOffhandItem();
            for (int i = 0; i < DyeColor.values().length; ++i) {
                if (!offhand.is((Item)GTItems.SPRAY_CAN_DYES[i].get())) continue;
                ((IInteractionItem)((ComponentItem)GTItems.SPRAY_CAN_DYES[i].get()).getComponents().get(0)).useOn(new UseOnContext(player, InteractionHand.OFF_HAND, new BlockHitResult(Vec3.ZERO, player.getDirection(), pos, false)));
                break;
            }
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 1);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null) {
            Direction facing = GTUtil.getFacingToNeighbor(pos, fromPos);
            if (facing == null) {
                return;
            }
            if (!ConfigHolder.INSTANCE.machines.gt6StylePipesCables) {
                boolean canConnect;
                boolean open = pipeTile.isConnected(facing);
                boolean bl = canConnect = pipeTile.getCoverContainer().getCoverAtSide(facing) != null || this.canConnect(pipeTile, facing);
                if (!open && canConnect && state.getBlock() != block) {
                    pipeTile.setConnection(facing, true, false);
                }
                if (open && !canConnect) {
                    pipeTile.setConnection(facing, false, false);
                }
                this.updateActiveNodeStatus(level, pos, pipeTile);
            }
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.hasBlockEntity() && !pState.is(pNewState.getBlock())) {
            pLevel.removeBlockEntity(pPos);
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                ((LevelPipeNet)((Object)this.getWorldPipeNet(serverLevel))).removeNode(pPos);
            }
        }
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null) {
            pipeTile.getCoverContainer().dropAllCovers();
        }
        super.destroy(level, pos, state);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((LevelPipeNet)((Object)this.getWorldPipeNet(serverLevel))).removeNode(pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        IPipeNode<PipeType, NodeDataType> pipeTile = this.getPipeTile((BlockGetter)level, pos);
        if (pipeTile != null) {
            int activeConnections = pipeTile.getConnections();
            boolean isActiveNode = activeConnections != 0;
            ((LevelPipeNet)((Object)this.getWorldPipeNet(level))).addNode(pos, this.createRawData(state, null), 0, activeConnections, isActiveNode);
            this.onActiveModeChange((Level)level, pos, isActiveNode, true);
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Set<GTToolType> types;
        MaterialBlock frameBlock;
        ItemStack itemStack = player.getItemInHand(hand);
        BlockEntity entity = level.getBlockEntity(pos);
        PipeBlockEntity pipeBlockEntity = null;
        if (entity instanceof PipeBlockEntity) {
            PipeBlockEntity pbe;
            pipeBlockEntity = pbe = (PipeBlockEntity)entity;
        }
        if (pipeBlockEntity == null) {
            return InteractionResult.FAIL;
        }
        if (pipeBlockEntity.getFrameMaterial().isNull() && ((IPipeType)this.pipeType).getThickness() < 1.0f && (frameBlock = MaterialBlock.getFrameboxFromItem(itemStack)) != null) {
            pipeBlockEntity.setFrameMaterial(frameBlock.material);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            SoundType type = VanillaRecipeHelper.isMaterialWood(frameBlock.material) ? SoundType.WOOD : SoundType.METAL;
            level.playSound(player, pos, type.getPlaceSound(), SoundSource.BLOCKS, (type.getVolume() + 1.0f) / 2.0f, type.getPitch() * 0.8f);
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        Item type = itemStack.getItem();
        if (type instanceof PipeBlockItem) {
            PipeBlockItem itemPipe = (PipeBlockItem)type;
            BlockPos offsetPos = pos.offset(hit.getDirection().getNormal());
            BlockState stateAtSide = level.getBlockState(offsetPos);
            Block block = stateAtSide.getBlock();
            if (block instanceof MaterialBlock) {
                MaterialBlock matBlock = (MaterialBlock)block;
                if (matBlock.tagPrefix == TagPrefix.frameGt && itemPipe.getBlock().pipeType == this.pipeType) {
                    boolean wasPlaced = matBlock.replaceWithFramedPipe(level, offsetPos, stateAtSide, player, itemStack, hit);
                    if (wasPlaced) {
                        pipeBlockEntity.setConnection(hit.getDirection(), true, false);
                    }
                    return wasPlaced ? InteractionResult.CONSUME : InteractionResult.FAIL;
                }
            }
        }
        if (!(types = ToolHelper.getToolTypes(itemStack)).isEmpty() && ToolHelper.canUse(itemStack) || types.isEmpty() && player.isShiftKeyDown()) {
            Pair<GTToolType, InteractionResult> result = pipeBlockEntity.onToolClick(types, itemStack, new UseOnContext(player, hand, hit));
            if (result.getSecond() == InteractionResult.CONSUME && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ToolHelper.playToolSound((GTToolType)result.getFirst(), serverPlayer);
                if (!serverPlayer.isCreative()) {
                    ToolHelper.damageItem(itemStack, (LivingEntity)serverPlayer, 1);
                }
            }
            return (InteractionResult)result.getSecond();
        }
        return InteractionResult.PASS;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        IPipeNode<PipeType, NodeDataType> pipeNode = this.getPipeTile((BlockGetter)level, pos);
        if (pipeNode == null) {
            GTCEu.LOGGER.error("Pipe was null");
            return;
        }
        if (!pipeNode.getFrameMaterial().isNull()) {
            BlockState frameState = ((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)pipeNode.getFrameMaterial())).getDefaultState();
            frameState.getBlock().entityInside(frameState, level, pos, entity);
        }
        super.entityInside(state, level, pos, entity);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        IPipeNode<PipeType, NodeDataType> pipeNode = this.getPipeTile(level, pos);
        if (pipeNode != null && !pipeNode.getFrameMaterial().isNull()) {
            return false;
        }
        return false;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        IPipeNode<PipeType, NodeDataType> pipeNode = this.getPipeTile(level, pos);
        if (pipeNode != null && !pipeNode.getFrameMaterial().isNull()) {
            return MaterialBlock.FRAME_COLLISION_BOX;
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext context) {
        int connections;
        block5: {
            VoxelShape shape;
            block6: {
                block7: {
                    BlockItem blockItem;
                    EntityCollisionContext entityCtx;
                    Entity entity;
                    IPipeNode<PipeType, NodeDataType> pipeNode = this.getPipeTile(pLevel, pPos);
                    connections = 0;
                    if (pipeNode == null) break block5;
                    if (!pipeNode.getFrameMaterial().isNull()) {
                        return Shapes.block();
                    }
                    connections = pipeNode.getVisualConnections();
                    shape = this.getPipeModel().getShapes(connections);
                    shape = Shapes.or((VoxelShape)shape, (VoxelShape[])pipeNode.getCoverContainer().addCoverCollisionBoundingBox());
                    if (!(context instanceof EntityCollisionContext) || !((entity = (entityCtx = (EntityCollisionContext)context).getEntity()) instanceof Player)) break block6;
                    Player player = (Player)entity;
                    ICoverable coverable = pipeNode.getCoverContainer();
                    ItemStack held = player.getMainHandItem();
                    Set<GTToolType> types = Set.of(GTToolType.WIRE_CUTTER, GTToolType.WRENCH);
                    BlockEntity tile = pLevel.getBlockEntity(pPos);
                    if (tile instanceof PipeBlockEntity) {
                        PipeBlockEntity pipeTile = (PipeBlockEntity)tile;
                        types = Set.of(pipeTile.getPipeTuneTool());
                    }
                    if (player.isShiftKeyDown() && held.isEmpty() && coverable.hasAnyCover() || types.stream().anyMatch(type -> type.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)held).is(arg_0)))) break block7;
                    if (CoverPlaceBehavior.isCoverBehaviorItem(held, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) break block7;
                    Item item = held.getItem();
                    if (!(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).getBlock()) instanceof PipeBlock)) break block6;
                    PipeBlock pipeBlock = (PipeBlock)item;
                    if (!((IPipeType)pipeBlock.pipeType).type().equals((Object)((IPipeType)this.pipeType).type())) break block6;
                }
                return Shapes.block();
            }
            return shape;
        }
        return this.getPipeModel().getShapes(connections);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == this.getBlockEntityType() && !level.isClientSide) {
            return (pLevel, pPos, pState, pTile) -> {
                if (pTile instanceof IPipeNode) {
                    IPipeNode pipeNode = (IPipeNode)pTile;
                    pipeNode.serverTick();
                }
            };
        }
        return null;
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        BlockState appearance;
        IPipeNode<PipeType, NodeDataType> pipe = this.getPipeTile((BlockGetter)level, pos);
        if (pipe != null && (appearance = pipe.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos)) != null) {
            return appearance;
        }
        return super.getAppearance(state, level, pos, side, sourceState, sourcePos);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        LootParams context = builder.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
        BlockEntity tileEntity = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.getDrops(state, builder));
        if (tileEntity instanceof IPipeNode) {
            IPipeNode pipeTile = (IPipeNode)tileEntity;
            if (!pipeTile.getFrameMaterial().isNull()) {
                drops.addAll(((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)pipeTile.getFrameMaterial())).getDefaultState().getDrops(builder));
            }
            for (Direction direction : GTUtil.DIRECTIONS) {
                pipeTile.getCoverContainer().removeCover(direction, null);
            }
        }
        return drops;
    }

    public GTToolType getPipeTuneTool() {
        return GTToolType.WRENCH;
    }
}

