/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.blockentity;

import appeng.api.networking.IInWorldGridNodeHost;
import appeng.capabilities.Capabilities;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.ICentralMonitor;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.capability.IMonitorComponent;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.ITurbineMachine;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.misc.EnergyInfoProviderList;
import com.gregtechceu.gtceu.api.misc.LaserContainerList;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.client.model.IBlockEntityRendererBakedModel;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.common.datafixers.TagFixer;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.syncdata.managed.MultiManagedStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaMachineBlockEntity
extends BlockEntity
implements IMachineBlockEntity,
IManaged {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MetaMachineBlockEntity.class);
    public final MultiManagedStorage managedStorage = new MultiManagedStorage();
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    public final MetaMachine metaMachine;
    @Persisted
    @DescSynced
    @RequireRerender
    private MachineRenderState renderState;
    private final long offset = GTValues.RNG.nextInt(20);

    public MetaMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.renderState = this.getDefinition().defaultRenderState();
        this.metaMachine = this.getDefinition().createMetaMachine(this);
        this.getRootStorage().attach((IManagedStorage)this.getSyncStorage());
    }

    @Override
    public MultiManagedStorage getRootStorage() {
        return this.managedStorage;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.getLevel();
        if (level != null && !level.isClientSide && level.getServer() != null) {
            level.getServer().execute(this::setChanged);
        }
    }

    public boolean triggerEvent(int id, int para) {
        if (id == 1) {
            if (this.level != null && this.level.isClientSide) {
                this.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setRenderState(MachineRenderState state) {
        this.renderState = state;
        this.scheduleRenderUpdate();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void setRemoved() {
        super.setRemoved();
        this.metaMachine.onUnload();
    }

    public void onLoad() {
        super.onLoad();
        this.metaMachine.onLoad();
    }

    @Override
    public boolean shouldRenderGrid(Player player, BlockPos pos, BlockState state, ItemStack held, Set<GTToolType> toolTypes) {
        return this.metaMachine.shouldRenderGrid(player, pos, state, held, toolTypes);
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        return this.metaMachine.sideTips(player, pos, state, toolTypes, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = MetaMachineBlockEntity.getCapability(this.getMetaMachine(), cap, side);
        return result.isPresent() ? result : super.getCapability(cap, side);
    }

    public void setChanged() {
        if (this.getLevel() != null) {
            this.getLevel().blockEntityChanged(this.getBlockPos());
        }
    }

    public static <T> LazyOptional<T> getCapability(MetaMachine machine, @NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<?> opt;
        if (cap == GTCapability.CAPABILITY_COVERABLE) {
            return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(machine::getCoverContainer));
        }
        if (cap == GTCapability.CAPABILITY_TOOLABLE) {
            return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> machine));
        }
        if (cap == GTCapability.CAPABILITY_WORKABLE) {
            if (machine instanceof IWorkable) {
                IWorkable workable = (IWorkable)((Object)machine);
                return GTCapability.CAPABILITY_WORKABLE.orEmpty(cap, LazyOptional.of(() -> workable));
            }
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof IWorkable)) continue;
                IWorkable workable = (IWorkable)((Object)trait);
                return GTCapability.CAPABILITY_WORKABLE.orEmpty(cap, LazyOptional.of(() -> workable));
            }
        } else if (cap == GTCapability.CAPABILITY_CONTROLLABLE) {
            if (machine instanceof IControllable) {
                IControllable controllable = (IControllable)((Object)machine);
                return GTCapability.CAPABILITY_CONTROLLABLE.orEmpty(cap, LazyOptional.of(() -> controllable));
            }
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof IControllable)) continue;
                IControllable controllable = (IControllable)((Object)trait);
                return GTCapability.CAPABILITY_CONTROLLABLE.orEmpty(cap, LazyOptional.of(() -> controllable));
            }
        } else if (cap == GTCapability.CAPABILITY_RECIPE_LOGIC) {
            for (MachineTrait trait : machine.getTraits()) {
                if (!(trait instanceof RecipeLogic)) continue;
                RecipeLogic recipeLogic = (RecipeLogic)trait;
                return GTCapability.CAPABILITY_RECIPE_LOGIC.orEmpty(cap, LazyOptional.of(() -> recipeLogic));
            }
        } else if (cap == GTCapability.CAPABILITY_ENERGY_CONTAINER) {
            if (machine instanceof IEnergyContainer) {
                IEnergyContainer energyContainer = (IEnergyContainer)((Object)machine);
                return GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(cap, LazyOptional.of(() -> energyContainer));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IEnergyContainer.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (IEnergyContainer)list.get(0) : new EnergyContainerList(list)));
            }
        } else if (cap == GTCapability.CAPABILITY_ENERGY_INFO_PROVIDER) {
            if (machine instanceof IEnergyInfoProvider) {
                IEnergyInfoProvider energyInfoProvider = (IEnergyInfoProvider)((Object)machine);
                return GTCapability.CAPABILITY_ENERGY_INFO_PROVIDER.orEmpty(cap, LazyOptional.of(() -> energyInfoProvider));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IEnergyInfoProvider.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_ENERGY_INFO_PROVIDER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (IEnergyInfoProvider)list.get(0) : new EnergyInfoProviderList(list)));
            }
        } else if (cap == GTCapability.CAPABILITY_CLEANROOM_RECEIVER) {
            if (machine instanceof ICleanroomReceiver) {
                ICleanroomReceiver cleanroomReceiver = (ICleanroomReceiver)((Object)machine);
                return GTCapability.CAPABILITY_CLEANROOM_RECEIVER.orEmpty(cap, LazyOptional.of(() -> cleanroomReceiver));
            }
        } else if (cap == GTCapability.CAPABILITY_MAINTENANCE_MACHINE) {
            if (machine instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenanceMachine = (IMaintenanceMachine)((Object)machine);
                return GTCapability.CAPABILITY_MAINTENANCE_MACHINE.orEmpty(cap, LazyOptional.of(() -> maintenanceMachine));
            }
        } else if (cap == GTCapability.CAPABILITY_TURBINE_MACHINE) {
            if (machine instanceof ITurbineMachine) {
                ITurbineMachine turbineMachine = (ITurbineMachine)((Object)machine);
                return GTCapability.CAPABILITY_TURBINE_MACHINE.orEmpty(cap, LazyOptional.of(() -> turbineMachine));
            }
        } else if (cap == ForgeCapabilities.ITEM_HANDLER) {
            handler = machine.getItemHandlerCap(side, true);
            if (handler != null) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> MetaMachineBlockEntity.lambda$getCapability$13((IItemHandlerModifiable)handler)));
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER) {
            handler = machine.getFluidHandlerCap(side, true);
            if (handler != null) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> MetaMachineBlockEntity.lambda$getCapability$14((IFluidHandlerModifiable)handler)));
            }
        } else if (cap == ForgeCapabilities.ENERGY) {
            if (machine instanceof IEnergyStorage) {
                IEnergyStorage energyStorage = (IEnergyStorage)machine;
                return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> energyStorage));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IEnergyStorage.class);
            if (!list.isEmpty()) {
                return ForgeCapabilities.ENERGY.orEmpty(cap, LazyOptional.of(() -> (IEnergyStorage)list.get(0)));
            }
        } else if (cap == GTCapability.CAPABILITY_LASER) {
            if (machine instanceof ILaserContainer) {
                ILaserContainer energyContainer = (ILaserContainer)((Object)machine);
                return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> energyContainer));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, ILaserContainer.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_LASER.orEmpty(cap, LazyOptional.of(() -> list.size() == 1 ? (ILaserContainer)list.get(0) : new LaserContainerList(list)));
            }
        } else if (cap == GTCapability.CAPABILITY_COMPUTATION_PROVIDER) {
            if (machine instanceof IOpticalComputationProvider) {
                IOpticalComputationProvider computationProvider = (IOpticalComputationProvider)((Object)machine);
                return GTCapability.CAPABILITY_COMPUTATION_PROVIDER.orEmpty(cap, LazyOptional.of(() -> computationProvider));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IOpticalComputationProvider.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_COMPUTATION_PROVIDER.orEmpty(cap, LazyOptional.of(() -> (IOpticalComputationProvider)list.get(0)));
            }
        } else if (cap == GTCapability.CAPABILITY_DATA_ACCESS) {
            if (machine instanceof IDataAccessHatch) {
                IDataAccessHatch computationProvider = (IDataAccessHatch)((Object)machine);
                return GTCapability.CAPABILITY_DATA_ACCESS.orEmpty(cap, LazyOptional.of(() -> computationProvider));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IDataAccessHatch.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_DATA_ACCESS.orEmpty(cap, LazyOptional.of(() -> (IDataAccessHatch)list.get(0)));
            }
        } else if (cap == GTCapability.CAPABILITY_MONITOR_COMPONENT) {
            if (machine instanceof IMonitorComponent) {
                IMonitorComponent monitorComponent = (IMonitorComponent)((Object)machine);
                return GTCapability.CAPABILITY_MONITOR_COMPONENT.orEmpty(cap, LazyOptional.of(() -> monitorComponent));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IMonitorComponent.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_MONITOR_COMPONENT.orEmpty(cap, LazyOptional.of(() -> (IMonitorComponent)list.get(0)));
            }
        } else if (cap == GTCapability.CAPABILITY_CENTRAL_MONITOR) {
            if (machine instanceof ICentralMonitor) {
                ICentralMonitor centralMonitor = (ICentralMonitor)((Object)machine);
                return GTCapability.CAPABILITY_CENTRAL_MONITOR.orEmpty(cap, LazyOptional.of(() -> centralMonitor));
            }
            list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, ICentralMonitor.class);
            if (!list.isEmpty()) {
                return GTCapability.CAPABILITY_CENTRAL_MONITOR.orEmpty(cap, LazyOptional.of(() -> (ICentralMonitor)list.get(0)));
            }
        }
        if (GTCEu.Mods.isAE2Loaded() && (opt = AE2CallWrapper.getGridNodeHostCapability(cap, machine, side)).isPresent()) {
            return opt;
        }
        return LazyOptional.empty();
    }

    public static <T> List<T> getCapabilitiesFromTraits(List<MachineTrait> traits, Direction accessSide, Class<T> capability) {
        if (traits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (MachineTrait trait : traits) {
            if (!trait.hasCapability(accessSide) || !capability.isInstance(trait)) continue;
            list.add(capability.cast(trait));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        IBlockEntityRendererBakedModel modelWithBER;
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = blockRenderDispatcher.getBlockModel(this.getBlockState());
        if (model instanceof IBlockEntityRendererBakedModel && (modelWithBER = (IBlockEntityRendererBakedModel)model).getBlockEntityType() == this.getType()) {
            return modelWithBER.getRenderBoundingBox(this);
        }
        return new AABB(this.worldPosition.offset(-1, 0, -1), this.worldPosition.offset(2, 2, 2));
    }

    public void load(CompoundTag tag) {
        TagFixer.fixFluidTags(tag);
        super.load(tag);
    }

    @Generated
    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Override
    @Generated
    public MetaMachine getMetaMachine() {
        return this.metaMachine;
    }

    @Override
    @Generated
    public MachineRenderState getRenderState() {
        return this.renderState;
    }

    private static /* synthetic */ IFluidHandler lambda$getCapability$14(IFluidHandlerModifiable handler) {
        return handler;
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$13(IItemHandlerModifiable handler) {
        return handler;
    }

    public static class AE2CallWrapper {
        public static LazyOptional<?> getGridNodeHostCapability(Capability<?> cap, MetaMachine machine, Direction side) {
            if (cap == Capabilities.IN_WORLD_GRID_NODE_HOST) {
                if (machine instanceof IInWorldGridNodeHost) {
                    IInWorldGridNodeHost nodeHost = (IInWorldGridNodeHost)machine;
                    return Capabilities.IN_WORLD_GRID_NODE_HOST.orEmpty(cap, LazyOptional.of(() -> nodeHost));
                }
                List<IInWorldGridNodeHost> list = MetaMachineBlockEntity.getCapabilitiesFromTraits(machine.getTraits(), side, IInWorldGridNodeHost.class);
                if (!list.isEmpty()) {
                    return Capabilities.IN_WORLD_GRID_NODE_HOST.orEmpty(cap, LazyOptional.of(() -> (IInWorldGridNodeHost)list.get(0)));
                }
            }
            return LazyOptional.empty();
        }
    }
}

