/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability;

import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.fluids.attribute.IAttributedFluid;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public interface IPropertyFluidFilter
extends Predicate<FluidStack> {
    @Override
    default public boolean test(@NotNull FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidType fluidType = fluid.getFluidType();
        if (fluidType.getTemperature() < 120 && !this.isCryoProof()) {
            return false;
        }
        if (fluid instanceof IAttributedFluid) {
            IAttributedFluid attributedFluid = (IAttributedFluid)fluid;
            FluidState state = attributedFluid.getState();
            if (!this.canContain(state)) {
                return false;
            }
            for (FluidAttribute attribute : attributedFluid.getAttributes()) {
                if (this.canContain(attribute)) continue;
                return false;
            }
            if (state == FluidState.PLASMA) {
                return true;
            }
        } else {
            if (fluidType.isLighterThanAir() && !this.canContain(FluidState.GAS)) {
                return false;
            }
            if (!this.canContain(FluidState.LIQUID)) {
                return false;
            }
        }
        return fluidType.getTemperature() <= this.getMaxFluidTemperature();
    }

    public boolean canContain(@NotNull FluidState var1);

    public boolean canContain(@NotNull FluidAttribute var1);

    public void setCanContain(@NotNull FluidAttribute var1, boolean var2);

    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull FluidAttribute> getContainedAttributes();

    default public void appendTooltips(@NotNull List<Component> tooltip, boolean showToolsInfo, boolean showTemperatureInfo) {
        if (GTUtil.isShiftDown()) {
            if (showTemperatureInfo) {
                tooltip.add((Component)Component.translatable((String)"gtceu.fluid_pipe.max_temperature", (Object[])new Object[]{FormattingUtil.formatNumbers(this.getMaxFluidTemperature())}));
            }
            if (this.isGasProof()) {
                tooltip.add((Component)Component.translatable((String)"gtceu.fluid_pipe.gas_proof"));
            } else {
                tooltip.add((Component)Component.translatable((String)"gtceu.fluid_pipe.not_gas_proof"));
            }
            if (this.isPlasmaProof()) {
                tooltip.add((Component)Component.translatable((String)"gtceu.fluid_pipe.plasma_proof"));
            }
            if (this.isCryoProof()) {
                tooltip.add((Component)Component.translatable((String)"gtceu.fluid_pipe.cryo_proof"));
            }
            this.getContainedAttributes().forEach(a -> a.appendContainerTooltips(tooltip::add));
        } else if (this.isGasProof() || this.isCryoProof() || this.isPlasmaProof() || !this.getContainedAttributes().isEmpty()) {
            if (showToolsInfo) {
                tooltip.add((Component)Component.translatable((String)"gtceu.tooltip.tool_fluid_hold_shift"));
            } else {
                tooltip.add((Component)Component.translatable((String)"gtceu.tooltip.fluid_pipe_hold_shift"));
            }
        }
    }

    public int getMaxFluidTemperature();

    public boolean isGasProof();

    public boolean isCryoProof();

    public boolean isPlasmaProof();
}

