/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroup;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupDistinctness;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item.CustomMapIngredient;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.common.valueprovider.ModifiedIntProvider;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import com.gregtechceu.gtceu.core.mixins.forge.IntersectionIngredientAccessor;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemStackList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemTagList;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemEntryHandler;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemStackHandler;
import com.gregtechceu.gtceu.integration.xei.widgets.GTRecipeWidget;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.IngredientEquality;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class ItemRecipeCapability
extends RecipeCapability<Ingredient> {
    public static final ItemRecipeCapability CAP = new ItemRecipeCapability();

    protected ItemRecipeCapability() {
        super("item", -2531066, true, 0, SerializerIngredient.INSTANCE);
    }

    @Override
    public Ingredient copyInner(Ingredient content) {
        return SizedIngredient.copy(content);
    }

    @Override
    public Ingredient copyWithModifier(Ingredient content, ContentModifier modifier) {
        if (content instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)content;
            return SizedIngredient.create(sizedIngredient.getInner(), modifier.apply(sizedIngredient.getAmount()));
        }
        if (content instanceof IntProviderIngredient) {
            IntProviderIngredient provider = (IntProviderIngredient)content;
            return IntProviderIngredient.of(provider.getInner(), ModifiedIntProvider.of(provider.getCountProvider(), modifier));
        }
        return SizedIngredient.create(content, modifier.apply(1));
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        ObjectArrayList list = new ObjectArrayList(ingredients.size());
        for (Object item : ingredients) {
            boolean isEqual;
            if (item instanceof Ingredient) {
                IntProviderIngredient intProvider;
                SizedIngredient sized;
                Ingredient ingredient = (Ingredient)item;
                isEqual = false;
                for (Object obj : list) {
                    ItemStack stack;
                    if (obj instanceof Ingredient) {
                        Ingredient ingredient1 = (Ingredient)obj;
                        if (!IngredientEquality.ingredientEquals(ingredient, ingredient1)) continue;
                        isEqual = true;
                        break;
                    }
                    if (!(obj instanceof ItemStack) || !ingredient.test(stack = (ItemStack)obj)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                if (ingredient instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                if (ingredient instanceof SizedIngredient && (sized = (SizedIngredient)ingredient).getInner() instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                if (ingredient instanceof IntProviderIngredient && (intProvider = (IntProviderIngredient)ingredient).getInner() instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                list.add(ingredient);
                continue;
            }
            if (!(item instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)item;
            isEqual = false;
            for (Object obj : list) {
                ItemStack stack1;
                if (obj instanceof Ingredient) {
                    Ingredient ingredient = (Ingredient)obj;
                    if (!ingredient.test(stack)) continue;
                    isEqual = true;
                    break;
                }
                if (!(obj instanceof ItemStack) || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)(stack1 = (ItemStack)obj))) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            list.add(stack);
        }
        return list;
    }

    @Override
    @Nullable
    public List<AbstractMapIngredient> getDefaultMapIngredient(Object object) {
        if (object instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)object;
            return CustomMapIngredient.from(ingredient);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isRecipeSearchFilter() {
        return true;
    }

    @Override
    public int limitMaxParallelByOutput(IRecipeCapabilityHolder holder, GTRecipe recipe, int multiplier, boolean tick) {
        if (holder instanceof ICustomParallel) {
            ICustomParallel p = (ICustomParallel)((Object)holder);
            return p.limitItemParallel(recipe, multiplier, tick);
        }
        List<Content> outputContents = (tick ? recipe.tickOutputs : recipe.outputs).get(this);
        if (outputContents == null || outputContents.isEmpty()) {
            return multiplier;
        }
        if (!holder.hasCapabilityProxies()) {
            return 0;
        }
        List<IRecipeHandler<?>> handlers = holder.getCapabilitiesFlat(IO.OUT, this);
        if (handlers.isEmpty()) {
            return 0;
        }
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        int maxCount = 0;
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(outputContents.size());
        for (Content content : outputContents) {
            int count;
            Ingredient ing = (Ingredient)this.of(content.content);
            if (ing instanceof SizedIngredient) {
                SizedIngredient sized = (SizedIngredient)ing;
                count = sized.getAmount();
            } else if (ing instanceof IntProviderIngredient) {
                IntProviderIngredient provider = (IntProviderIngredient)ing;
                count = provider.getCountProvider().getMaxValue();
            } else {
                count = 1;
            }
            maxCount = Math.max(maxCount, count);
            ingredients.add(ing);
        }
        if (maxCount == 0) {
            return multiplier;
        }
        if (multiplier > Integer.MAX_VALUE / maxCount) {
            maxMultiplier = multiplier = Integer.MAX_VALUE / maxCount;
        }
        while (minMultiplier != maxMultiplier) {
            IRecipeHandler handler;
            List<Object> copied = new ArrayList<Ingredient>();
            for (Ingredient ing : ingredients) {
                copied.add(this.copyWithModifier(ing, ContentModifier.multiplier(multiplier)));
            }
            Iterator<IRecipeHandler<?>> iterator = handlers.iterator();
            while (iterator.hasNext() && (copied = (handler = iterator.next()).handleRecipe(IO.OUT, recipe, copied, true)) != null) {
            }
            int[] nArray = ParallelLogic.adjustMultiplier(copied == null, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = nArray[0];
            multiplier = nArray[1];
            maxMultiplier = nArray[2];
        }
        return multiplier;
    }

    @Override
    public int getMaxParallelByInput(IRecipeCapabilityHolder holder, GTRecipe recipe, int limit, boolean tick) {
        if (!holder.hasCapabilityProxies()) {
            return 0;
        }
        List<Content> inputs = (tick ? recipe.tickInputs : recipe.inputs).get(this);
        if (inputs == null || inputs.isEmpty()) {
            return limit;
        }
        List<Object2LongMap<ItemStack>> inventoryGroups = ItemRecipeCapability.getInputContents(holder);
        if (inventoryGroups.isEmpty()) {
            return 0;
        }
        Object2LongOpenHashMap nonConsumables = new Object2LongOpenHashMap();
        Object2LongOpenHashMap consumables = new Object2LongOpenHashMap();
        for (Content content : inputs) {
            int count;
            Ingredient ing = (Ingredient)this.of(content.content);
            if (ing instanceof IntCircuitIngredient) continue;
            if (ing instanceof SizedIngredient) {
                SizedIngredient sized = (SizedIngredient)ing;
                count = sized.getAmount();
            } else if (ing instanceof IntProviderIngredient) {
                IntProviderIngredient provider = (IntProviderIngredient)ing;
                count = provider.getCountProvider().getMaxValue();
            } else {
                count = 1;
            }
            if (content.chance == 0) {
                nonConsumables.addTo((Object)ing, (long)count);
                continue;
            }
            boolean has = false;
            for (Object2LongMap.Entry recipeIng : consumables.object2LongEntrySet()) {
                ItemStack stack = ing.getItems()[0];
                if (!((Ingredient)recipeIng.getKey()).test(stack)) continue;
                recipeIng.setValue(recipeIng.getLongValue() + (long)stack.getCount());
                has = true;
                break;
            }
            if (has) continue;
            consumables.addTo((Object)ing, (long)count);
        }
        if (consumables.isEmpty() && nonConsumables.isEmpty()) {
            return limit;
        }
        int maxMultiplier = 0;
        for (Object2LongMap<ItemStack> group : inventoryGroups) {
            boolean satisfied = true;
            for (Object2LongMap.Entry ncEntry : Object2LongMaps.fastIterable((Object2LongMap)nonConsumables)) {
                Ingredient ingredient = (Ingredient)ncEntry.getKey();
                long needed = ncEntry.getLongValue();
                for (Object2LongMap.Entry stackEntry : Object2LongMaps.fastIterable(group)) {
                    if (!ingredient.test((ItemStack)stackEntry.getKey())) continue;
                    long count = stackEntry.getLongValue();
                    long lesser = Math.min(needed, count);
                    stackEntry.setValue(count -= lesser);
                    if ((needed -= lesser) != 0L) continue;
                    break;
                }
                if (needed <= 0L) continue;
                satisfied = false;
                break;
            }
            if (!satisfied) continue;
            if (consumables.isEmpty()) {
                return limit;
            }
            int invMultiplier = Integer.MAX_VALUE;
            for (Object2LongMap.Entry cEntry : Object2LongMaps.fastIterable((Object2LongMap)consumables)) {
                Object2LongMap.Entry stackEntry;
                Ingredient ingredient = (Ingredient)cEntry.getKey();
                long needed = cEntry.getLongValue();
                long maxNeeded = needed * (long)limit;
                long available = 0L;
                ObjectIterator objectIterator = Object2LongMaps.fastIterable(group).iterator();
                while (objectIterator.hasNext() && (!ingredient.test((ItemStack)(stackEntry = (Object2LongMap.Entry)objectIterator.next()).getKey()) || (available += stackEntry.getLongValue()) < maxNeeded)) {
                }
                int ratio = GTMath.saturatedCast(Math.min((long)limit, available / needed));
                invMultiplier = Math.min(invMultiplier, ratio);
                if (ratio != 0) continue;
                break;
            }
            if (invMultiplier == limit) {
                return limit;
            }
            maxMultiplier = Math.max(maxMultiplier, invMultiplier);
        }
        return maxMultiplier;
    }

    private static List<Object2LongMap<ItemStack>> getInputContents(IRecipeCapabilityHolder holder) {
        List<RecipeHandlerList> handlerLists = holder.getCapabilitiesForIO(IO.IN);
        if (handlerLists.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<RecipeHandlerGroup, List<RecipeHandlerList>> handlerGroups = new HashMap<RecipeHandlerGroup, List<RecipeHandlerList>>();
        for (RecipeHandlerList handler : handlerLists) {
            if (!handler.hasCapability(CAP)) continue;
            RecipeHelper.addToRecipeHandlerMap(handler.getGroup(), handler, handlerGroups);
        }
        ItemStackHashStrategy strat = ItemStackHashStrategy.comparingAllButCount();
        List distinctHandlerLists = handlerGroups.getOrDefault(RecipeHandlerGroupDistinctness.BUS_DISTINCT, Collections.emptyList());
        ArrayList<Object2LongMap<ItemStack>> invs = new ArrayList<Object2LongMap<ItemStack>>(distinctHandlerLists.size() + 1);
        for (RecipeHandlerList recipeHandlerList : distinctHandlerLists) {
            List<IRecipeHandler<?>> handlers = recipeHandlerList.getCapability(CAP);
            Object2LongOpenCustomHashMap distinctInv = new Object2LongOpenCustomHashMap((Hash.Strategy)strat);
            for (IRecipeHandler<?> handler : handlers) {
                for (Object object : handler.getContents()) {
                    ItemStack stack;
                    if (!(object instanceof ItemStack) || (stack = (ItemStack)object).isEmpty()) continue;
                    distinctInv.addTo((Object)stack, (long)stack.getCount());
                }
            }
            if (distinctInv.isEmpty()) continue;
            invs.add((Object2LongMap<ItemStack>)distinctInv);
        }
        for (Map.Entry entry : handlerGroups.entrySet()) {
            if (entry.getKey() == RecipeHandlerGroupDistinctness.BUS_DISTINCT) continue;
            Object2LongOpenCustomHashMap inventory = new Object2LongOpenCustomHashMap((Hash.Strategy)strat);
            for (RecipeHandlerList handlerList : (List)entry.getValue()) {
                List<IRecipeHandler<?>> handlers = handlerList.getCapability(CAP);
                for (IRecipeHandler iRecipeHandler : handlers) {
                    for (Object content : iRecipeHandler.getContents()) {
                        ItemStack stack;
                        if (!(content instanceof ItemStack) || (stack = (ItemStack)content).isEmpty()) continue;
                        inventory.addTo((Object)stack, (long)stack.getCount());
                    }
                }
            }
            if (inventory.isEmpty()) continue;
            invs.add((Object2LongMap<ItemStack>)inventory);
        }
        return invs;
    }

    @Override
    @NotNull
    public List<Object> createXEIContainerContents(List<Content> contents, GTRecipe recipe, IO io) {
        List<Object> entryLists = contents.stream().map(Content::getContent).map(this::of).map(ItemRecipeCapability::mapItem).collect(Collectors.toList());
        if (io == IO.OUT && recipe.recipeType.isScanner()) {
            ArrayList<Object> scannerPossibilities = new ArrayList<Object>();
            ResearchManager.ResearchItem researchData = null;
            for (Content stack : recipe.getOutputContents(this)) {
                ItemStack[] stacks = ((Ingredient)this.of(stack.content)).getItems();
                if (stacks.length == 0 || stacks[0].isEmpty() || (researchData = ResearchManager.readResearchId(stacks[0])) == null) continue;
                break;
            }
            if (researchData != null) {
                Collection<GTRecipe> possibleRecipes = researchData.recipeType().getDataStickEntry(researchData.researchId());
                ObjectOpenCustomHashSet cache = new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingItem());
                if (possibleRecipes != null) {
                    for (GTRecipe r : possibleRecipes) {
                        ItemStack researchStack;
                        List<Content> outputs = r.getOutputContents(this);
                        if (outputs.isEmpty()) continue;
                        Content outputContent = outputs.get(0);
                        ItemStack[] stacks = ((Ingredient)this.of(outputContent.content)).getItems();
                        if (stacks.length == 0 || (researchStack = stacks[0]).isEmpty() || cache.contains(researchStack)) continue;
                        cache.add(researchStack);
                        scannerPossibilities.add(ItemStackList.of(researchStack.copyWithCount(1)));
                    }
                }
                scannerPossibilities.add(entryLists.get(0));
                entryLists = scannerPossibilities;
            }
        }
        while (entryLists.size() < recipe.recipeType.getMaxOutputs(this)) {
            entryLists.add(null);
        }
        return entryLists;
    }

    @Override
    public Object createXEIContainer(List<?> contents) {
        return new CycleItemEntryHandler(contents);
    }

    @Override
    @NotNull
    public Widget createWidget() {
        SlotWidget slot = new SlotWidget();
        slot.initTemplate();
        return slot;
    }

    @Override
    @NotNull
    public Class<? extends Widget> getWidgetClass() {
        return SlotWidget.class;
    }

    @Override
    public void applyWidgetInfo(@NotNull Widget widget, int index, boolean isXEI, IO io,  @UnknownNullability(value="null when storage == null") GTRecipeTypeUI.RecipeHolder recipeHolder, @NotNull GTRecipeType recipeType, @UnknownNullability(value="null when content == null") GTRecipe recipe, @Nullable Content content, @Nullable Object storage, int recipeTier, int chanceTier) {
        if (widget instanceof SlotWidget) {
            SlotWidget slot = (SlotWidget)widget;
            if (storage instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable items = (IItemHandlerModifiable)storage;
                if (index >= 0 && index < items.getSlots()) {
                    slot.setHandlerSlot(items, index);
                    slot.setIngredientIO(io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT);
                    slot.setCanTakeItems(!isXEI);
                    slot.setCanPutItems(!isXEI && io.support(IO.IN));
                }
                if (isXEI && recipeType.isHasResearchSlot() && index == items.getSlots() && ConfigHolder.INSTANCE.machines.enableResearch) {
                    ResearchCondition condition = recipeHolder.conditions().stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
                    if (condition != null) {
                        ArrayList<ItemStack> dataItems = new ArrayList<ItemStack>();
                        for (ResearchData.ResearchEntry entry : condition.data) {
                            ItemStack dataStick = entry.getDataItem().copy();
                            ResearchManager.writeResearchToNBT(dataStick.getOrCreateTag(), entry.getResearchId(), recipeType);
                            dataItems.add(dataStick);
                        }
                        CycleItemStackHandler handler = new CycleItemStackHandler(List.of(dataItems));
                        slot.setHandlerSlot(handler, 0);
                        slot.setIngredientIO(IngredientIO.CATALYST);
                        slot.setCanTakeItems(false);
                        slot.setCanPutItems(false);
                    }
                }
            }
            if (content != null) {
                float chance = (float)recipeType.getChanceFunction().getBoostedChance(content, recipeTier, chanceTier) / (float)content.maxChance;
                slot.setXEIChance(chance);
                slot.setOnAddedTooltips((w, tooltips) -> {
                    GTRecipeWidget.setConsumedChance(content, recipe.getChanceLogicForCapability(this, io, this.isTickSlot(index, io, recipe)), tooltips, recipeTier, chanceTier, recipeType.getChanceFunction());
                    Object patt22206$temp = this.of(content.content);
                    if (patt22206$temp instanceof IntProviderIngredient) {
                        IntProviderIngredient ingredient = (IntProviderIngredient)((Object)((Object)patt22206$temp));
                        countProvider = ingredient.getCountProvider();
                        tooltips.add(Component.translatable((String)"gtceu.gui.content.count_range", (Object[])new Object[]{countProvider.getMinValue(), countProvider.getMaxValue()}).withStyle(ChatFormatting.GOLD));
                    } else {
                        SizedIngredient sizedIngredient;
                        Ingredient patt22742$temp;
                        Object patt22641$temp = this.of(content.content);
                        if (patt22641$temp instanceof SizedIngredient && (patt22742$temp = (sizedIngredient = (SizedIngredient)((Object)((Object)patt22641$temp))).getInner()) instanceof IntProviderIngredient) {
                            IntProviderIngredient ingredient = (IntProviderIngredient)patt22742$temp;
                            countProvider = ingredient.getCountProvider();
                            tooltips.add(Component.translatable((String)"gtceu.gui.content.count_range", (Object[])new Object[]{countProvider.getMinValue(), countProvider.getMaxValue()}).withStyle(ChatFormatting.GOLD));
                        }
                    }
                    if (this.isTickSlot(index, io, recipe)) {
                        tooltips.add(Component.translatable((String)"gtceu.gui.content.per_tick"));
                    }
                });
                if (io == IO.IN && (content.chance == 0 || this.of(content.content) instanceof IntCircuitIngredient)) {
                    slot.setIngredientIO(IngredientIO.CATALYST);
                }
            }
        }
    }

    private static ItemEntryList mapItem(Ingredient ingredient) {
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            int amount = sizedIngredient.getAmount();
            ItemEntryList mapped = ItemRecipeCapability.tryMapInner(sizedIngredient.getInner(), amount);
            if (mapped != null) {
                return mapped;
            }
            Ingredient ingredient2 = sizedIngredient.getInner();
            if (ingredient2 instanceof IntProviderIngredient) {
                IntProviderIngredient intProvider = (IntProviderIngredient)ingredient2;
                ItemStackList stackList = new ItemStackList();
                for (ItemStack i : intProvider.getInner().getItems()) {
                    stackList.add(i);
                }
                return stackList;
            }
        } else {
            if (ingredient instanceof IntProviderIngredient) {
                IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
                boolean amount = true;
                ItemEntryList mapped = ItemRecipeCapability.tryMapInner(intProvider.getInner(), 1);
                if (mapped != null) {
                    return mapped;
                }
                ItemStackList stackList = new ItemStackList();
                for (ItemStack i : intProvider.getInner().getItems()) {
                    stackList.add(i);
                }
                return stackList;
            }
            if (ingredient instanceof IntersectionIngredient) {
                IntersectionIngredient intersection = (IntersectionIngredient)ingredient;
                return ItemRecipeCapability.mapIntersection(intersection, -1);
            }
            ItemTagList tagList = ItemRecipeCapability.tryMapTag(ingredient, 1);
            if (tagList != null) {
                return tagList;
            }
        }
        ItemStackList stackList = new ItemStackList();
        for (ItemStack i : ingredient.getItems()) {
            stackList.add(i);
        }
        return stackList;
    }

    @Nullable
    private static ItemEntryList tryMapInner(Ingredient inner, int amount) {
        if (inner instanceof IntersectionIngredient) {
            IntersectionIngredient intersection = (IntersectionIngredient)inner;
            return ItemRecipeCapability.mapIntersection(intersection, amount);
        }
        return ItemRecipeCapability.tryMapTag(inner, amount);
    }

    private static ItemEntryList mapIntersection(IntersectionIngredient intersection, int amount) {
        List<Ingredient> children = ((IntersectionIngredientAccessor)intersection).getChildren();
        if (children.isEmpty()) {
            return new ItemStackList();
        }
        ItemEntryList childList = ItemRecipeCapability.mapItem(children.get(0));
        ItemStackList stackList = new ItemStackList();
        for (ItemStack stack : childList.getStacks()) {
            if (!children.stream().skip(1L).allMatch(child -> child.test(stack))) continue;
            if (amount > 0) {
                stackList.add(stack.copyWithCount(amount));
                continue;
            }
            stackList.add(stack.copy());
        }
        return stackList;
    }

    @Nullable
    private static ItemTagList tryMapTag(Ingredient ingredient, int amount) {
        Ingredient.Value value;
        Ingredient.Value[] values = ((IngredientAccessor)ingredient).getValues();
        if (values.length > 0 && (value = values[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            return ItemTagList.of(((TagValueAccessor)tagValue).getTag(), amount, null);
        }
        return null;
    }

    @Override
    public Object2IntMap<Ingredient> makeChanceCache() {
        return new Object2IntOpenCustomHashMap((Hash.Strategy)IngredientEquality.IngredientHashStrategy.INSTANCE);
    }

    @Override
    public boolean shouldBypassDistinct() {
        return false;
    }

    public static interface ICustomParallel {
        public int limitItemParallel(GTRecipe var1, int var2, boolean var3);
    }
}

