/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cosmetics;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cosmetics.event.RegisterGTCapesEvent;
import com.gregtechceu.gtceu.common.commands.GTCommands;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.SPacketNotifyCapeChange;
import com.gregtechceu.gtceu.integration.kjs.GTCEuServerEvents;
import com.gregtechceu.gtceu.integration.kjs.events.RegisterCapesEventJS;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapeRegistry
extends SavedData {
    public static final Map<ResourceLocation, ResourceLocation> ALL_CAPES = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Set<ResourceLocation> FREE_CAPES = new HashSet<ResourceLocation>();
    private static final Map<UUID, Set<ResourceLocation>> UNLOCKED_CAPES = new HashMap<UUID, Set<ResourceLocation>>();
    private static final Map<UUID, ResourceLocation> CURRENT_CAPES = new HashMap<UUID, ResourceLocation>();
    private static final CapeRegistry INSTANCE = new CapeRegistry();
    private static final Comparator<ResourceLocation> SET_COMPARATOR = (o1, o2) -> {
        int result = o1.compareTo(o2);
        boolean isFirstFree = FREE_CAPES.contains(o1);
        if (isFirstFree ^ FREE_CAPES.contains(o2)) {
            if (isFirstFree) {
                return -1;
            }
            return 1;
        }
        return result;
    };

    private CapeRegistry() {
    }

    private static void initCapes() {
        RegisterGTCapesEvent event = new RegisterGTCapesEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (GTCEu.Mods.isKubeJSLoaded()) {
            KJSCallWrapper.fireKJSEvent(event);
        }
        CapeRegistry.save();
    }

    public static void registerToServer(ServerLevel level) {
        level.getDataStorage().computeIfAbsent(INSTANCE::load, INSTANCE::init, "gtceu_capes");
    }

    private CapeRegistry init() {
        CapeRegistry.clearMaps();
        CapeRegistry.initCapes();
        return this;
    }

    public static void save() {
        INSTANCE.setDirty();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag) {
        ListTag unlockedCapesTag = new ListTag();
        for (Map.Entry<UUID, Set<ResourceLocation>> entry : UNLOCKED_CAPES.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putUUID("owner", entry.getKey());
            ListTag capesTag = new ListTag();
            for (ResourceLocation cape : entry.getValue()) {
                capesTag.add((Object)StringTag.valueOf((String)cape.toString()));
            }
            entryTag.put("capes", (Tag)capesTag);
            unlockedCapesTag.add((Object)entryTag);
        }
        tag.put("unlocked_capes", (Tag)unlockedCapesTag);
        ListTag currentCapesTag = new ListTag();
        for (Map.Entry<UUID, ResourceLocation> entry : CURRENT_CAPES.entrySet()) {
            if (entry.getValue() == null) continue;
            String capeLocation = entry.getValue().toString();
            CompoundTag entryTag = new CompoundTag();
            entryTag.putString("cape", capeLocation);
            entryTag.putUUID("owner", entry.getKey());
            currentCapesTag.add((Object)entryTag);
        }
        tag.put("current_capes", (Tag)currentCapesTag);
        return tag;
    }

    private CapeRegistry load(CompoundTag tag) {
        this.init();
        ListTag unlockedCapesTag = tag.getList("unlocked_capes", 10);
        for (int i = 0; i < unlockedCapesTag.size(); ++i) {
            CompoundTag entryTag = unlockedCapesTag.getCompound(i);
            UUID uuid = entryTag.getUUID("owner");
            Set capes = UNLOCKED_CAPES.computeIfAbsent(uuid, CapeRegistry::makeSet);
            ListTag capesTag = entryTag.getList("capes", 8);
            for (int j = 0; j < capesTag.size(); ++j) {
                String capeId = capesTag.getString(j);
                if (capeId.isEmpty()) continue;
                capes.add(new ResourceLocation(capeId));
            }
            UNLOCKED_CAPES.put(uuid, capes);
        }
        ListTag currentCapesTag = tag.getList("current_capes", 10);
        for (int i = 0; i < currentCapesTag.size(); ++i) {
            CompoundTag entryTag = currentCapesTag.getCompound(i);
            String capeId = entryTag.getString("cape");
            if (capeId.isEmpty()) continue;
            UUID uuid = entryTag.getUUID("owner");
            CURRENT_CAPES.put(uuid, new ResourceLocation(capeId));
        }
        return this;
    }

    @Nullable
    public static ResourceLocation getPlayerCapeId(UUID uuid) {
        return CURRENT_CAPES.get(uuid);
    }

    @Nullable
    public static ResourceLocation getPlayerCapeTexture(UUID uuid) {
        return ALL_CAPES.getOrDefault(CapeRegistry.getPlayerCapeId(uuid), null);
    }

    public static Set<ResourceLocation> getUnlockedCapes(UUID uuid) {
        return UNLOCKED_CAPES.getOrDefault(uuid, Collections.emptySet());
    }

    @ApiStatus.Internal
    public static void registerCape(ResourceLocation id, ResourceLocation texture) {
        ALL_CAPES.put(id, texture);
    }

    @ApiStatus.Internal
    public static void registerFreeCape(ResourceLocation id, ResourceLocation texture) {
        CapeRegistry.registerCape(id, texture);
        FREE_CAPES.add(id);
    }

    public static boolean unlockCape(UUID owner, @NotNull ResourceLocation cape) {
        if (!ALL_CAPES.containsKey(cape)) {
            throw GTCommands.ERROR_NO_SUCH_CAPE.create((Object)cape.toString());
        }
        Set capes = UNLOCKED_CAPES.computeIfAbsent(owner, CapeRegistry::makeSet);
        if (capes.contains(cape)) {
            return false;
        }
        capes.add(cape);
        UNLOCKED_CAPES.put(owner, capes);
        return true;
    }

    public static boolean removeCape(UUID owner, @NotNull ResourceLocation cape) {
        if (!ALL_CAPES.containsKey(cape)) {
            throw GTCommands.ERROR_NO_SUCH_CAPE.create((Object)cape.toString());
        }
        if (FREE_CAPES.contains(cape)) {
            return false;
        }
        Set<ResourceLocation> capes = UNLOCKED_CAPES.get(owner);
        if (capes == null || !capes.contains(cape)) {
            return false;
        }
        capes.remove(cape);
        UNLOCKED_CAPES.put(owner, capes);
        if (cape.equals((Object)CapeRegistry.getPlayerCapeId(owner))) {
            CapeRegistry.setActiveCape(owner, null);
        }
        return true;
    }

    public static void clearMaps() {
        UNLOCKED_CAPES.clear();
        CURRENT_CAPES.clear();
    }

    public static void giveRawCape(UUID uuid, @NotNull ResourceLocation cape) {
        if (!ALL_CAPES.containsKey(cape)) {
            throw GTCommands.ERROR_NO_SUCH_CAPE.create((Object)cape.toString());
        }
        CURRENT_CAPES.put(uuid, cape);
    }

    public static boolean setActiveCape(UUID player, @Nullable ResourceLocation cape) {
        if (cape != null && !ALL_CAPES.containsKey(cape)) {
            throw GTCommands.ERROR_NO_SUCH_CAPE.create((Object)cape.toString());
        }
        Set<ResourceLocation> capes = UNLOCKED_CAPES.get(player);
        if (capes == null || cape != null && !capes.contains(cape)) {
            return false;
        }
        CURRENT_CAPES.put(player, cape);
        GTNetwork.sendToAll(new SPacketNotifyCapeChange(player, cape));
        CapeRegistry.save();
        return true;
    }

    public static void loadCurrentCapesOnLogin(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            UUID uuid = player.getUUID();
            GTNetwork.sendToAll(new SPacketNotifyCapeChange(uuid, CURRENT_CAPES.get(uuid)));
            for (ServerPlayer otherPlayer : serverPlayer.getServer().getPlayerList().getPlayers()) {
                uuid = otherPlayer.getUUID();
                GTNetwork.sendToPlayer(serverPlayer, new SPacketNotifyCapeChange(uuid, CURRENT_CAPES.get(uuid)));
            }
        }
    }

    public static void detectNewCapes(Player player) {
        Set<ResourceLocation> playerCapes;
        if (player instanceof ServerPlayer && ((playerCapes = UNLOCKED_CAPES.get(player.getUUID())) == null || !new HashSet<ResourceLocation>(playerCapes).containsAll(FREE_CAPES))) {
            for (ResourceLocation cape : FREE_CAPES) {
                CapeRegistry.unlockCape(player.getUUID(), cape);
            }
            CapeRegistry.save();
        }
    }

    private static Set<ResourceLocation> makeSet(UUID ignored) {
        return new TreeSet<ResourceLocation>(SET_COMPARATOR);
    }

    private static class KJSCallWrapper {
        private KJSCallWrapper() {
        }

        public static void fireKJSEvent(RegisterGTCapesEvent event) {
            GTCEuServerEvents.REGISTER_CAPES.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new RegisterCapesEventJS(event));
        }
    }
}

