/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class CoverDefinition {
    private final ResourceLocation id;
    private final CoverBehaviourProvider behaviorCreator;
    @Nullable
    private final Supplier<ICoverRenderer> coverRenderer;

    public CoverDefinition(ResourceLocation id, CoverBehaviourProvider behaviorCreator, Supplier<Supplier<ICoverRenderer>> coverRenderer) {
        this.behaviorCreator = behaviorCreator;
        this.id = id;
        this.coverRenderer = GTCEu.isClientSide() ? ClientHelper.initRenderer(coverRenderer) : null;
    }

    public CoverBehavior createCoverBehavior(ICoverable metaTileEntity, Direction side) {
        return this.behaviorCreator.create(this, metaTileEntity, side);
    }

    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Nullable
    @Generated
    public Supplier<ICoverRenderer> getCoverRenderer() {
        return this.coverRenderer;
    }

    public static interface CoverBehaviourProvider {
        public CoverBehavior create(CoverDefinition var1, ICoverable var2, Direction var3);
    }

    private static class ClientHelper {
        private ClientHelper() {
        }

        private static Supplier<ICoverRenderer> initRenderer(Supplier<Supplier<ICoverRenderer>> coverRenderer) {
            ICoverRenderer value = coverRenderer.get().get();
            return () -> value;
        }
    }

    public static interface TieredCoverBehaviourProvider {
        public CoverBehavior create(CoverDefinition var1, ICoverable var2, Direction var3, int var4);
    }
}

