/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.filter.Filter;
import com.gregtechceu.gtceu.api.cover.filter.SmartItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class FilterHandler<T, F extends Filter<T, F>>
implements IEnhancedManaged {
    private final IEnhancedManaged container;
    @Persisted
    @DescSynced
    @NotNull
    private ItemStack filterItem = ItemStack.EMPTY;
    @Nullable
    private F filter;
    @Nullable
    private CustomItemStackHandler filterSlot;
    @Nullable
    private WidgetGroup filterGroup;
    @NotNull
    private Consumer<F> onFilterLoaded = filter -> {};
    @NotNull
    private Consumer<F> onFilterRemoved = filter -> {};
    @NotNull
    private Consumer<F> onFilterUpdated = filter -> {};
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FilterHandler.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);

    public FilterHandler(IEnhancedManaged container) {
        this.container = container;
    }

    protected abstract F loadFilter(ItemStack var1);

    protected abstract F getEmptyFilter();

    protected abstract boolean canInsertFilterItem(ItemStack var1);

    public Widget createFilterSlotUI(int xPos, int yPos) {
        return new SlotWidget((IItemHandlerModifiable)this.getFilterSlot(), 0, xPos, yPos).setChangeListener(this::updateFilter).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY}));
    }

    public Widget createFilterConfigUI(int xPos, int yPos, int width, int height) {
        this.filterGroup = new WidgetGroup(xPos, yPos, width, height);
        if (!this.filterItem.isEmpty()) {
            this.filterGroup.addWidget((Widget)this.getFilter().openConfigurator(0, 0));
        }
        return this.filterGroup;
    }

    public boolean isFilterPresent() {
        return this.filter != null || !this.filterItem.isEmpty();
    }

    public F getFilter() {
        if (this.filter == null) {
            if (this.filterItem.isEmpty()) {
                return this.getEmptyFilter();
            }
            this.loadFilterFromItem();
        }
        return this.filter;
    }

    public boolean test(T resource) {
        return this.getFilter().test(resource);
    }

    public FilterHandler<T, F> onFilterLoaded(Consumer<F> onFilterLoaded) {
        this.onFilterLoaded = onFilterLoaded;
        return this;
    }

    public FilterHandler<T, F> onFilterRemoved(Consumer<F> onFilterRemoved) {
        this.onFilterRemoved = onFilterRemoved;
        return this;
    }

    public FilterHandler<T, F> onFilterUpdated(Consumer<F> onFilterUpdated) {
        this.onFilterUpdated = onFilterUpdated;
        return this;
    }

    private CustomItemStackHandler getFilterSlot() {
        if (this.filterSlot == null) {
            this.filterSlot = new CustomItemStackHandler(this.filterItem){

                public int getSlotLimit(int slot) {
                    return 1;
                }
            };
            this.filterSlot.setFilter(this::canInsertFilterItem);
        }
        return this.filterSlot;
    }

    private void updateFilter() {
        CustomItemStackHandler filterContainer = this.getFilterSlot();
        if (GTCEu.isClientThread() && !filterContainer.getStackInSlot(0).isEmpty() && !this.filterItem.isEmpty()) {
            return;
        }
        this.filterItem = filterContainer.getStackInSlot(0);
        if (this.filter != null) {
            this.filter = null;
            this.onFilterRemoved.accept(this.filter);
        }
        this.loadFilterFromItem();
    }

    private void loadFilterFromItem() {
        if (!this.filterItem.isEmpty()) {
            this.filter = this.loadFilter(this.filterItem);
            this.filter.setOnUpdated(this.onFilterUpdated);
            Object object = this.filter;
            if (object instanceof SmartItemFilter) {
                SmartItemFilter smart = (SmartItemFilter)object;
                object = this.container;
                if (object instanceof CoverBehavior) {
                    MachineCoverContainer mcc;
                    MetaMachine machine;
                    CoverBehavior cover = (CoverBehavior)object;
                    object = cover.coverHolder;
                    if (object instanceof MachineCoverContainer && (machine = MetaMachine.getMachine((BlockGetter)(mcc = (MachineCoverContainer)object).getLevel(), mcc.getPos())) != null) {
                        smart.setModeFromMachine(machine.getDefinition().getName());
                    }
                }
            }
            this.onFilterLoaded.accept(this.filter);
        }
        this.updateFilterGroupUI();
    }

    private void updateFilterGroupUI() {
        if (this.filterGroup == null) {
            return;
        }
        this.filterGroup.clearAllWidgets();
        if (!this.filterItem.isEmpty() && this.filter != null) {
            this.filterGroup.addWidget((Widget)this.filter.openConfigurator(0, 0));
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        this.container.onChanged();
    }

    public void scheduleRenderUpdate() {
        this.container.scheduleRenderUpdate();
    }

    @NotNull
    @Generated
    public ItemStack getFilterItem() {
        return this.filterItem;
    }

    @Generated
    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }
}

