/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.Filter;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.NotImplementedException;

public interface ItemFilter
extends Filter<ItemStack, ItemFilter> {
    public static final Map<ItemLike, Function<ItemStack, ItemFilter>> FILTERS = new HashMap<ItemLike, Function<ItemStack, ItemFilter>>();
    public static final ItemFilter EMPTY = new ItemFilter(){

        @Override
        public int testItemCount(ItemStack itemStack) {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return true;
        }

        @Override
        public WidgetGroup openConfigurator(int x, int y) {
            throw new NotImplementedException("Not available for empty item filter");
        }

        @Override
        public CompoundTag saveFilter() {
            throw new NotImplementedException("Not available for empty item filter");
        }

        @Override
        public void setOnUpdated(Consumer<ItemFilter> onUpdated) {
            throw new NotImplementedException("Not available for empty item filter");
        }
    };

    public static ItemFilter loadFilter(ItemStack itemStack) {
        return FILTERS.get(itemStack.getItem()).apply(itemStack);
    }

    public int testItemCount(ItemStack var1);

    default public boolean supportsAmounts() {
        return !this.isBlackList();
    }
}

