/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.Filter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.TagExprFilter;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class TagFilter<T, S extends Filter<T, S>>
implements Filter<T, S> {
    private static final Pattern DOUBLE_WILDCARD = Pattern.compile("\\*{2,}");
    private static final Pattern DOUBLE_AND = Pattern.compile("&{2,}");
    private static final Pattern DOUBLE_OR = Pattern.compile("\\|{2,}");
    private static final Pattern DOUBLE_NOT = Pattern.compile("!{2,}");
    private static final Pattern DOUBLE_XOR = Pattern.compile("\\^{2,}");
    private static final Pattern DOUBLE_SPACE = Pattern.compile(" {2,}");
    protected String oreDictFilterExpression = "";
    protected Consumer<S> itemWriter = filter -> {};
    protected Consumer<S> onUpdated = filter -> this.itemWriter.accept(filter);
    protected TagExprFilter.TagExprParser.MatchExpr matchExpr = null;

    protected TagFilter() {
    }

    @Override
    public boolean isBlank() {
        return this.oreDictFilterExpression.isBlank();
    }

    @Override
    public CompoundTag saveFilter() {
        if (this.isBlank()) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.putString("oreDict", this.oreDictFilterExpression);
        return tag;
    }

    public void setOreDict(String oreDict) {
        this.oreDictFilterExpression = oreDict;
        this.matchExpr = TagExprFilter.parseExpression(this.oreDictFilterExpression);
        this.onUpdated.accept(this);
    }

    @Override
    public WidgetGroup openConfigurator(int x, int y) {
        WidgetGroup group = new WidgetGroup(x, y, 79, 54);
        group.addWidget(new ImageWidget(0, 0, 20, 20, (IGuiTexture)GuiTextures.INFO_ICON).setHoverTooltips((Component[])LangHandler.getMultiLang("cover.tag_filter.info").toArray(new MutableComponent[0])));
        group.addWidget((Widget)new TextFieldWidget(0, 29, 79, 12, () -> this.oreDictFilterExpression, this::setOreDict).setMaxStringLength(64).setValidator(input -> {
            int i;
            input = DOUBLE_WILDCARD.matcher((CharSequence)input).replaceAll("*");
            input = DOUBLE_AND.matcher((CharSequence)input).replaceAll("&");
            input = DOUBLE_OR.matcher((CharSequence)input).replaceAll("|");
            input = DOUBLE_NOT.matcher((CharSequence)input).replaceAll("!");
            input = DOUBLE_XOR.matcher((CharSequence)input).replaceAll("^");
            input = DOUBLE_SPACE.matcher((CharSequence)input).replaceAll(" ");
            StringBuilder builder = new StringBuilder();
            int unclosed = 0;
            char last = ' ';
            for (i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == ' ') {
                    if (last == 40) continue;
                    builder.append(" ");
                    continue;
                }
                if (c == '(') {
                    ++unclosed;
                } else if (c == ')') {
                    --unclosed;
                    if (last == '&' || last == '|' || last == '^') {
                        int l2;
                        int l = builder.lastIndexOf(" " + last);
                        builder.insert(l == (l2 = builder.lastIndexOf(String.valueOf(last))) - 1 ? l : l2, ")");
                        continue;
                    }
                    if (i > 0 && builder.charAt(builder.length() - 1) == ' ') {
                        builder.deleteCharAt(builder.length() - 1);
                    }
                } else if ((c == '&' || c == '|' || c == '^') && last == '(') {
                    builder.deleteCharAt(builder.lastIndexOf("("));
                    builder.append(c).append(" (");
                    continue;
                }
                builder.append(c);
                last = c;
            }
            if (unclosed > 0) {
                builder.append(")".repeat(unclosed));
            } else if (unclosed < 0) {
                unclosed = -unclosed;
                for (i = 0; i < unclosed; ++i) {
                    builder.insert(0, "(");
                }
            }
            input = builder.toString();
            input = input.replaceAll(" {2,}", " ");
            return input;
        }));
        return group;
    }

    @Override
    public void setOnUpdated(Consumer<S> onUpdated) {
        this.onUpdated = filter -> {
            this.itemWriter.accept(filter);
            onUpdated.accept(filter);
        };
    }

    @Generated
    public String getOreDictFilterExpression() {
        return this.oreDictFilterExpression;
    }
}

