/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.indicators.SurfaceIndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.ClassicVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.CuboidVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.DikeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.GeodeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.LayeredVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.StandardVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.VeinedVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTOreDefinition {
    public static final Codec<GTOreDefinition> CODEC = ResourceLocation.CODEC.flatXmap(rl -> Optional.ofNullable((GTOreDefinition)GTRegistries.ORE_VEINS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No GTOreDefinition with id " + String.valueOf(rl) + " registered")), obj -> Optional.ofNullable((ResourceLocation)GTRegistries.ORE_VEINS.getKey((GTOreDefinition)obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "GTOreDefinition " + String.valueOf(obj) + " not registered")));
    public static final Codec<GTOreDefinition> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("cluster_size").forGetter(ft -> ft.clusterSize), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("density").forGetter(ft -> Float.valueOf(ft.density)), (App)Codec.INT.fieldOf("weight").forGetter(ft -> ft.weight), (App)IWorldGenLayer.CODEC.fieldOf("layer").forGetter(ft -> ft.layer), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).listOf().fieldOf("dimension_filter").forGetter(ft -> new ArrayList<ResourceKey<Level>>(ft.dimensionFilter)), (App)HeightRangePlacement.CODEC.fieldOf("height_range").forGetter(ft -> ft.range), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(ft -> Float.valueOf(ft.discardChanceOnAirExposure)), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes", (Object)HolderSet.direct((Holder[])new Holder[0])).forGetter(ext -> ext.biomes == null ? HolderSet.direct((Holder[])new Holder[0]) : ext.biomes.get()), (App)BiomeWeightModifier.CODEC.optionalFieldOf("weight_modifier", (Object)BiomeWeightModifier.EMPTY).forGetter(ext -> ext.biomeWeightModifier), (App)VeinGenerator.DIRECT_CODEC.fieldOf("generator").forGetter(ft -> ft.veinGenerator), (App)Codec.list(IndicatorGenerator.DIRECT_CODEC).fieldOf("indicators").forGetter(ft -> ft.indicatorGenerators)).apply((Applicative)instance, (clusterSize, density, weight, layer, dimensionFilter, range, discardChanceOnAirExposure, biomes, biomeWeightModifier, veinGenerator, indicatorGenerators) -> new GTOreDefinition((IntProvider)clusterSize, density.floatValue(), (int)weight, (IWorldGenLayer)layer, (Set<ResourceKey<Level>>)new HashSet<ResourceKey<Level>>((Collection<ResourceKey<Level>>)dimensionFilter), (HeightRangePlacement)range, discardChanceOnAirExposure.floatValue(), (Supplier<HolderSet<Biome>>)(biomes == null ? () -> HolderSet.direct((Holder[])new Holder[0]) : () -> biomes), (BiomeWeightModifier)biomeWeightModifier, (VeinGenerator)veinGenerator, (List<IndicatorGenerator>)indicatorGenerators)));
    private final InferredProperties inferredProperties = new InferredProperties();
    private IntProvider clusterSize;
    private float density;
    private int weight;
    private IWorldGenLayer layer;
    private Set<ResourceKey<Level>> dimensionFilter;
    private HeightRangePlacement range;
    private float discardChanceOnAirExposure;
    @Nullable
    private Supplier<HolderSet<Biome>> biomes;
    private BiomeWeightModifier biomeWeightModifier = BiomeWeightModifier.EMPTY;
    private VeinGenerator veinGenerator;
    private List<IndicatorGenerator> indicatorGenerators;

    public GTOreDefinition(GTOreDefinition other) {
        this(other.clusterSize, other.density, other.weight, other.layer, Set.copyOf(other.dimensionFilter), other.range, other.discardChanceOnAirExposure, other.biomes, other.biomeWeightModifier, other.veinGenerator, List.copyOf(other.indicatorGenerators));
    }

    public GTOreDefinition(IntProvider clusterSize, float density, int weight, IWorldGenLayer layer, Set<ResourceKey<Level>> dimensionFilter, HeightRangePlacement range, float discardChanceOnAirExposure, @Nullable Supplier<HolderSet<Biome>> biomes, @Nullable BiomeWeightModifier biomeWeightModifier, @Nullable VeinGenerator veinGenerator, @Nullable List<IndicatorGenerator> indicatorGenerators) {
        this.clusterSize = clusterSize;
        this.density = density;
        this.weight = weight;
        this.layer = layer;
        this.dimensionFilter = dimensionFilter;
        this.range = range;
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        this.biomes = biomes;
        this.biomeWeightModifier = biomeWeightModifier;
        this.veinGenerator = veinGenerator;
        this.indicatorGenerators = Objects.requireNonNullElseGet(indicatorGenerators, ArrayList::new);
    }

    public boolean isForBiome(Holder<Biome> biome) {
        if (this.biomes == null) {
            return true;
        }
        HolderSet<Biome> set = this.biomes.get();
        return set.size() == 0 || set.contains(biome);
    }

    public int weightForBiome(Holder<Biome> biome) {
        int w = this.weight;
        if (this.biomeWeightModifier != null) {
            w += this.biomeWeightModifier.applyAsInt(biome);
        }
        return w;
    }

    @HideFromJS
    public void register(ResourceLocation id) {
        GTRegistries.ORE_VEINS.registerOrOverride(id, this);
    }

    public GTOreDefinition clusterSize(IntProvider clusterSize) {
        this.clusterSize = clusterSize;
        return this;
    }

    public GTOreDefinition clusterSize(int clusterSize) {
        this.clusterSize = ConstantInt.of((int)clusterSize);
        return this;
    }

    public GTOreDefinition density(float density) {
        this.density = density;
        return this;
    }

    public GTOreDefinition weight(int weight) {
        this.weight = weight;
        return this;
    }

    public GTOreDefinition layer(IWorldGenLayer layer) {
        this.layer = layer;
        if (this.dimensionFilter == null || this.dimensionFilter.isEmpty()) {
            this.dimensions((ResourceLocation[])layer.getLevels().toArray(ResourceLocation[]::new));
        }
        return this;
    }

    public GTOreDefinition dimensions(ResourceLocation ... dimensions) {
        this.dimensionFilter = Arrays.stream(dimensions).map(location -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location)).collect(Collectors.toSet());
        return this;
    }

    public GTOreDefinition biomes(String first, String ... biomes) {
        List<String> biomeList = Stream.of(Stream.of(first), Arrays.stream(biomes)).flatMap(Function.identity()).toList();
        this.biomes = OreVeinUtil.resolveBiomes(biomeList);
        return this;
    }

    public GTOreDefinition biomes(TagKey<Biome> biomes) {
        this.biomes = () -> GTRegistries.builtinRegistry().lookupOrThrow(Registries.BIOME).getOrThrow(biomes);
        return this;
    }

    public GTOreDefinition biomes(Supplier<HolderSet<Biome>> biomes) {
        this.biomes = biomes;
        return this;
    }

    public GTOreDefinition heightRangeUniform(int min, int max) {
        this.heightRange(HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)min), (VerticalAnchor)VerticalAnchor.absolute((int)max)));
        this.inferredProperties.heightRange = IntIntPair.of((int)min, (int)max);
        return this;
    }

    public GTOreDefinition heightRangeTriangle(int min, int max) {
        this.heightRange(HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)min), (VerticalAnchor)VerticalAnchor.absolute((int)max)));
        this.inferredProperties.heightRange = IntIntPair.of((int)min, (int)max);
        return this;
    }

    public GTOreDefinition heightRange(HeightRangePlacement range) {
        this.range = range;
        return this;
    }

    public GTOreDefinition standardVeinGenerator(Consumer<StandardVeinGenerator> config) {
        StandardVeinGenerator veinGenerator = new StandardVeinGenerator(this);
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition layeredVeinGenerator(Consumer<LayeredVeinGenerator> config) {
        LayeredVeinGenerator veinGenerator = new LayeredVeinGenerator(this);
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition geodeVeinGenerator(Consumer<GeodeVeinGenerator> config) {
        GeodeVeinGenerator veinGenerator = new GeodeVeinGenerator(this);
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition dikeVeinGenerator(Consumer<DikeVeinGenerator> config) {
        DikeVeinGenerator veinGenerator = new DikeVeinGenerator(this);
        if (this.inferredProperties.heightRange != null) {
            veinGenerator.minYLevel(this.inferredProperties.heightRange.firstInt());
            veinGenerator.maxYLevel(this.inferredProperties.heightRange.secondInt());
        }
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition veinedVeinGenerator(Consumer<VeinedVeinGenerator> config) {
        VeinedVeinGenerator veinGenerator = new VeinedVeinGenerator(this);
        if (this.inferredProperties.heightRange != null) {
            veinGenerator.minYLevel(this.inferredProperties.heightRange.firstInt());
            veinGenerator.maxYLevel(this.inferredProperties.heightRange.secondInt());
        }
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition classicVeinGenerator(Consumer<ClassicVeinGenerator> config) {
        ClassicVeinGenerator veinGenerator = new ClassicVeinGenerator(this);
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    public GTOreDefinition cuboidVeinGenerator(Consumer<CuboidVeinGenerator> config) {
        CuboidVeinGenerator veinGenerator = new CuboidVeinGenerator(this);
        if (this.inferredProperties.heightRange != null) {
            veinGenerator.minY(this.inferredProperties.heightRange.firstInt());
            veinGenerator.maxY(this.inferredProperties.heightRange.secondInt());
        }
        config.accept(veinGenerator);
        this.veinGenerator = veinGenerator;
        return this;
    }

    @Nullable
    public VeinGenerator veinGenerator(ResourceLocation id) {
        if (this.veinGenerator == null) {
            this.veinGenerator = WorldGeneratorUtils.VEIN_GENERATOR_FUNCTIONS.containsKey((Object)id) ? (VeinGenerator)((Function)WorldGeneratorUtils.VEIN_GENERATOR_FUNCTIONS.get((Object)id)).apply(this) : null;
        }
        return this.veinGenerator;
    }

    public GTOreDefinition surfaceIndicatorGenerator(Consumer<SurfaceIndicatorGenerator> config) {
        config.accept(this.getOrCreateIndicatorGenerator(SurfaceIndicatorGenerator.class, SurfaceIndicatorGenerator::new));
        return this;
    }

    private <T extends IndicatorGenerator> T getOrCreateIndicatorGenerator(Class<T> indicatorClass, Function<GTOreDefinition, T> constructor) {
        IndicatorGenerator existingGenerator = this.indicatorGenerators.stream().filter(indicatorClass::isInstance).map(indicatorClass::cast).findFirst().orElse(null);
        if (existingGenerator != null) {
            return (T)existingGenerator;
        }
        IndicatorGenerator generator = (IndicatorGenerator)constructor.apply(this);
        this.indicatorGenerators.add(generator);
        return (T)generator;
    }

    @Generated
    public IntProvider clusterSize() {
        return this.clusterSize;
    }

    @Generated
    public float density() {
        return this.density;
    }

    @Generated
    public int weight() {
        return this.weight;
    }

    @Generated
    public IWorldGenLayer layer() {
        return this.layer;
    }

    @Generated
    public Set<ResourceKey<Level>> dimensionFilter() {
        return this.dimensionFilter;
    }

    @NotNull
    @Generated
    public GTOreDefinition dimensionFilter(Set<ResourceKey<Level>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
        return this;
    }

    @Generated
    public HeightRangePlacement range() {
        return this.range;
    }

    @NotNull
    @Generated
    public GTOreDefinition range(HeightRangePlacement range) {
        this.range = range;
        return this;
    }

    @Generated
    public float discardChanceOnAirExposure() {
        return this.discardChanceOnAirExposure;
    }

    @NotNull
    @Generated
    public GTOreDefinition discardChanceOnAirExposure(float discardChanceOnAirExposure) {
        this.discardChanceOnAirExposure = discardChanceOnAirExposure;
        return this;
    }

    @Nullable
    @Generated
    public Supplier<HolderSet<Biome>> biomes() {
        return this.biomes;
    }

    @Generated
    public BiomeWeightModifier biomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    @NotNull
    @Generated
    public GTOreDefinition biomeWeightModifier(BiomeWeightModifier biomeWeightModifier) {
        this.biomeWeightModifier = biomeWeightModifier;
        return this;
    }

    @Generated
    public VeinGenerator veinGenerator() {
        return this.veinGenerator;
    }

    @NotNull
    @Generated
    public GTOreDefinition veinGenerator(VeinGenerator veinGenerator) {
        this.veinGenerator = veinGenerator;
        return this;
    }

    @Generated
    public List<IndicatorGenerator> indicatorGenerators() {
        return this.indicatorGenerators;
    }

    @NotNull
    @Generated
    public GTOreDefinition indicatorGenerators(List<IndicatorGenerator> indicatorGenerators) {
        this.indicatorGenerators = indicatorGenerators;
        return this;
    }

    private static class InferredProperties {
        public IntIntPair heightRange = null;

        private InferredProperties() {
        }
    }
}

