/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryInfo;
import java.util.Set;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.jetbrains.annotations.NotNull;

public enum WorldGenLayers implements IWorldGenLayer,
StringRepresentable
{
    STONE("stone", (RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), Set.of(Level.OVERWORLD.location())),
    DEEPSLATE("deepslate", (RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), Set.of(Level.OVERWORLD.location())),
    NETHERRACK("netherrack", (RuleTest)new TagMatchTest(BlockTags.NETHER_CARVER_REPLACEABLES), Set.of(Level.NETHER.location())),
    ENDSTONE("endstone", WorldGeneratorUtils.END_ORE_REPLACEABLES, Set.of(Level.END.location()));

    private final String name;
    private Set<ResourceLocation> levels;
    private RuleTest target;

    private WorldGenLayers(String name, RuleTest target, Set<ResourceLocation> levels) {
        this.name = name;
        this.target = target;
        this.levels = levels;
        WorldGeneratorUtils.WORLD_GEN_LAYERS.put(name, this);
    }

    public static void registerAll() {
        AddonFinder.getAddons().forEach(IGTAddon::registerWorldgenLayers);
        if (GTCEu.Mods.isKubeJSLoaded()) {
            GTRegistryInfo.registerFor(GTRegistryInfo.WORLD_GEN_LAYER.registryKey);
        }
    }

    public static IWorldGenLayer getByName(String name) {
        return (IWorldGenLayer)WorldGeneratorUtils.WORLD_GEN_LAYERS.get(name);
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    @Override
    public boolean isApplicableForLevel(ResourceLocation level) {
        return this.levels.contains(level);
    }

    @Override
    @Generated
    public Set<ResourceLocation> getLevels() {
        return this.levels;
    }

    @Generated
    public void setLevels(Set<ResourceLocation> levels) {
        this.levels = levels;
    }

    @Override
    @Generated
    public RuleTest getTarget() {
        return this.target;
    }

    @Generated
    public void setTarget(RuleTest target) {
        this.target = target;
    }
}

