/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.OreVeinWorldEntry;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.WeightedMaterial;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTMath;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BedrockOreVeinSavedData
extends SavedData {
    public static final int VEIN_CHUNK_SIZE = 3;
    public static final int MAXIMUM_VEIN_OPERATIONS = 100000;
    public final HashMap<ChunkPos, OreVeinWorldEntry> veinOres = new HashMap();
    private final Object2IntMap<Holder<Biome>> biomeWeights = new Object2IntOpenHashMap();
    private final ServerLevel serverLevel;

    public static BedrockOreVeinSavedData getOrCreate(ServerLevel serverLevel) {
        return (BedrockOreVeinSavedData)serverLevel.getDataStorage().computeIfAbsent(tag -> new BedrockOreVeinSavedData(serverLevel, (CompoundTag)tag), () -> new BedrockOreVeinSavedData(serverLevel), "gtceu_bedrock_ore");
    }

    public BedrockOreVeinSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public BedrockOreVeinSavedData(ServerLevel serverLevel, CompoundTag nbt) {
        this(serverLevel);
        ListTag list = nbt.getList("veinInfo", 10);
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)tag;
            ChunkPos chunkPos = new ChunkPos(compoundTag.getLong("pos"));
            this.veinOres.put(chunkPos, OreVeinWorldEntry.readFromNBT(compoundTag.getCompound("data")));
        }
    }

    public CompoundTag save(CompoundTag nbt) {
        ListTag oreList = new ListTag();
        for (Map.Entry<ChunkPos, OreVeinWorldEntry> entry : this.veinOres.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.putLong("pos", entry.getKey().toLong());
            tag.put("data", (Tag)entry.getValue().writeToNBT());
            oreList.add((Object)tag);
        }
        nbt.put("veinInfo", (Tag)oreList);
        return nbt;
    }

    public static int getVeinCoord(int chunkCoord) {
        return Math.floorDiv(chunkCoord, 3);
    }

    public OreVeinWorldEntry getOreVeinWorldEntry(int chunkX, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        if (!this.veinOres.containsKey(pos)) {
            int minDistance = ConfigHolder.INSTANCE.worldgen.oreVeins.bedrockOreDistance;
            if (chunkX % minDistance != 0 || chunkZ % minDistance != 0) {
                OreVeinWorldEntry entry = new OreVeinWorldEntry(null, 0, 100000);
                this.veinOres.put(pos, entry);
                return entry;
            }
            BedrockOreDefinition definition = null;
            int query = RandomSource.create((long)GTMath.hashLongs(this.serverLevel.getSeed(), BedrockOreVeinSavedData.getVeinCoord(chunkX), BedrockOreVeinSavedData.getVeinCoord(chunkZ))).nextInt();
            Holder biome = this.serverLevel.getBiome(new BlockPos(chunkX << 4, 64, chunkZ << 4));
            int totalWeight = this.getTotalWeight((Holder<Biome>)biome);
            if (totalWeight > 0) {
                int weight = Math.abs(query % totalWeight);
                for (BedrockOreDefinition oreDefinition : GTRegistries.BEDROCK_ORE_DEFINITIONS) {
                    int veinWeight = oreDefinition.weight() + (oreDefinition.biomeWeightModifier() != null ? oreDefinition.biomeWeightModifier().applyAsInt((Holder<Biome>)biome) : 0);
                    if (veinWeight <= 0 || oreDefinition.dimensionFilter != null && !oreDefinition.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((ResourceKey<Level>)dim, (ResourceKey<Level>)this.serverLevel.dimension())) || (weight -= veinWeight) >= 0) continue;
                    definition = oreDefinition;
                    break;
                }
            }
            this.createVein(pos, definition);
            this.setDirty();
        }
        if (!this.veinOres.containsKey(pos)) {
            OreVeinWorldEntry entry = new OreVeinWorldEntry(null, 0, 100000);
            this.veinOres.put(pos, entry);
            return entry;
        }
        return this.veinOres.get(pos);
    }

    public void createVein(ChunkPos pos, @Nullable BedrockOreDefinition definition) {
        if (definition != null) {
            int radius = definition.size() / 2;
            for (int x = pos.x - radius; x <= pos.x + radius; ++x) {
                for (int z = pos.z - radius; z <= pos.z + radius; ++z) {
                    int maximumYield;
                    ChunkPos pos2 = new ChunkPos(x, z);
                    float distanceFromOriginal = Math.abs(pos.x - x) + Math.abs(pos.z - z);
                    distanceFromOriginal = distanceFromOriginal == 0.0f ? 1.0f : distanceFromOriginal;
                    distanceFromOriginal = (float)Math.pow(distanceFromOriginal, 2.0);
                    RandomSource random = RandomSource.create((long)(961L * (long)pos2.x + (long)pos2.z * 31L + (long)Long.hashCode(this.serverLevel.getSeed())));
                    if ((float)(definition.yield().getMaxValue() - definition.yield().getMinValue()) / distanceFromOriginal <= 0.0f) {
                        maximumYield = definition.yield().getMinValue();
                    } else {
                        maximumYield = (int)((float)(definition.yield().sample(random) + definition.yield().getMinValue()) / distanceFromOriginal);
                        maximumYield = Math.max(maximumYield, definition.yield().getMinValue());
                    }
                    maximumYield = Math.min(maximumYield, definition.yield().getMaxValue());
                    this.veinOres.put(pos2, new OreVeinWorldEntry(definition, maximumYield, 100000));
                }
            }
        }
    }

    public int getTotalWeight(Holder<Biome> biome) {
        return this.biomeWeights.computeIfAbsent(biome, b -> {
            int totalWeight = 0;
            for (BedrockOreDefinition definition : GTRegistries.BEDROCK_ORE_DEFINITIONS) {
                if (definition.dimensionFilter != null && !definition.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((ResourceKey<Level>)dim, (ResourceKey<Level>)this.serverLevel.dimension()))) continue;
                totalWeight += definition.biomeWeightModifier() != null ? definition.biomeWeightModifier().applyAsInt(biome) : 0;
                totalWeight += definition.weight();
            }
            return totalWeight;
        });
    }

    public int getOreYield(int chunkX, int chunkZ) {
        return this.getOreVeinWorldEntry(chunkX, chunkZ).getOreYield();
    }

    public int getDepletedOreYield(int chunkX, int chunkZ) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return 0;
        }
        return info.getDefinition().depletedYield();
    }

    public int getOperationsRemaining(int chunkX, int chunkZ) {
        return this.getOreVeinWorldEntry(chunkX, chunkZ).getOperationsRemaining();
    }

    @Nullable
    public List<WeightedMaterial> getOreInChunk(int chunkX, int chunkZ) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return null;
        }
        return info.getDefinition().materials();
    }

    public void depleteVein(int chunkX, int chunkZ, int amount, boolean ignoreVeinStats) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (ignoreVeinStats) {
            info.decreaseOperations(amount);
            if (amount != 0) {
                this.setDirty();
            }
            return;
        }
        BedrockOreDefinition definition = info.getDefinition();
        if (definition == null || definition.depletionChance() == 0) {
            return;
        }
        if (definition.depletionChance() == 100 || GTValues.RNG.nextInt(100) <= definition.depletionChance()) {
            info.decreaseOperations(definition.depletionAmount());
            this.setDirty();
        }
    }
}

