/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreIndicatorPlacer;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class IndicatorGenerator {
    public static final Codec<Codec<? extends IndicatorGenerator>> REGISTRY_CODEC = ResourceLocation.CODEC.flatXmap(rl -> Optional.ofNullable((Codec)WorldGeneratorUtils.INDICATOR_GENERATORS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No IndicatorGenerator with id " + String.valueOf(rl) + " registered")), obj -> Optional.ofNullable((ResourceLocation)WorldGeneratorUtils.INDICATOR_GENERATORS.inverse().get(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "IndicatorGenerator " + String.valueOf(obj) + " not registered")));
    public static final Codec<IndicatorGenerator> DIRECT_CODEC = REGISTRY_CODEC.dispatchStable(IndicatorGenerator::codec, Function.identity());
    protected GTOreDefinition entry;

    public IndicatorGenerator() {
    }

    public IndicatorGenerator(GTOreDefinition entry) {
        this.entry = entry;
    }

    @HideFromJS
    public abstract Map<ChunkPos, OreIndicatorPlacer> generate(WorldGenLevel var1, RandomSource var2, GeneratedVeinMetadata var3);

    @HideFromJS
    public GTOreDefinition parent() {
        return this.entry;
    }

    @Nullable
    public abstract Either<BlockState, Material> block();

    public abstract Codec<? extends IndicatorGenerator> codec();

    public abstract int getSearchRadiusModifier(int var1);
}

