/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public abstract class VeinGenerator {
    public static final Codec<Codec<? extends VeinGenerator>> REGISTRY_CODEC = ResourceLocation.CODEC.flatXmap(rl -> Optional.ofNullable((Codec)WorldGeneratorUtils.VEIN_GENERATORS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No VeinGenerator with id " + String.valueOf(rl) + " registered")), obj -> Optional.ofNullable((ResourceLocation)WorldGeneratorUtils.VEIN_GENERATORS.inverse().get(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "VeinGenerator " + String.valueOf(obj) + " not registered")));
    public static final Codec<VeinGenerator> DIRECT_CODEC = REGISTRY_CODEC.dispatchStable(VeinGenerator::codec, Function.identity());
    protected GTOreDefinition entry;

    public VeinGenerator() {
    }

    public VeinGenerator(GTOreDefinition entry) {
        this.entry = entry;
    }

    public abstract List<VeinEntry> getAllEntries();

    public List<BlockState> getAllBlocks() {
        return this.getAllEntries().stream().map(VeinEntry::mapToBlockState).toList();
    }

    public List<Material> getAllMaterials() {
        return this.getAllEntries().stream().sorted(Comparator.comparingInt(VeinEntry::chance)).map(VeinEntry::mapToMaterial).filter(mat -> !mat.isNull()).toList();
    }

    public IntList getAllChances() {
        return IntArrayList.toList((IntStream)this.getAllEntries().stream().mapToInt(VeinEntry::chance));
    }

    public List<ObjectIntPair<Material>> getValidMaterialsChances() {
        return this.getAllEntries().stream().map(entry -> ObjectIntPair.of((Object)entry.mapToMaterial(), (int)entry.chance)).filter(pair -> !((Material)pair.first()).isNull()).toList();
    }

    @HideFromJS
    public abstract Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel var1, RandomSource var2, GTOreDefinition var3, BlockPos var4);

    @HideFromJS
    public abstract VeinGenerator build();

    public abstract VeinGenerator copy();

    @HideFromJS
    public GTOreDefinition parent() {
        return this.entry;
    }

    public abstract Codec<? extends VeinGenerator> codec();

    public static Stream<Either<BlockState, Material>> mapTarget(Either<List<OreConfiguration.TargetBlockState>, Material> target) {
        return (Stream)target.map(tbs -> tbs.stream().map(state -> Either.left((Object)state.state)), mat -> Stream.of(Either.right((Object)mat)));
    }

    public static Stream<VeinEntry> mapTarget(Either<List<OreConfiguration.TargetBlockState>, Material> target, int weight) {
        return VeinGenerator.mapTarget(target).map(entry -> new VeinEntry((Either<BlockState, Material>)entry, weight));
    }

    public record VeinEntry(Either<BlockState, Material> vein, int chance) {
        public static VeinEntry ofBlock(BlockState state, int chance) {
            return new VeinEntry((Either<BlockState, Material>)Either.left((Object)state), chance);
        }

        public static VeinEntry ofMaterial(Material mat, int chance) {
            return new VeinEntry((Either<BlockState, Material>)Either.right((Object)mat), chance);
        }

        public <T> T map(Function<BlockState, T> left, Function<Material, T> right) {
            return (T)this.vein.map(left, right);
        }

        public BlockState mapToBlockState() {
            return (BlockState)this.vein.map(Function.identity(), material -> ChemicalHelper.getBlock(TagPrefix.ore, material).defaultBlockState());
        }

        public Material mapToMaterial() {
            return (Material)this.vein.map(state -> ChemicalHelper.getMaterialStack((ItemLike)state.getBlock()).material(), Function.identity());
        }
    }
}

