/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.ClassicVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.CuboidVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.DikeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.GeodeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.LayeredVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.NoopVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.StandardVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.VeinedVeinGenerator;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class VeinGenerators {
    public static final Codec<NoopVeinGenerator> NO_OP = VeinGenerators.register(GTCEu.id("no_op"), NoopVeinGenerator.CODEC, entry -> NoopVeinGenerator.INSTANCE);
    public static final Codec<StandardVeinGenerator> STANDARD = VeinGenerators.register(GTCEu.id("standard"), StandardVeinGenerator.CODEC, StandardVeinGenerator::new);
    public static final Codec<LayeredVeinGenerator> LAYER = VeinGenerators.register(GTCEu.id("layer"), LayeredVeinGenerator.CODEC, LayeredVeinGenerator::new);
    public static final Codec<GeodeVeinGenerator> GEODE = VeinGenerators.register(GTCEu.id("geode"), GeodeVeinGenerator.CODEC, GeodeVeinGenerator::new);
    public static final Codec<DikeVeinGenerator> DIKE = VeinGenerators.register(GTCEu.id("dike"), DikeVeinGenerator.CODEC, DikeVeinGenerator::new);
    public static final Codec<VeinedVeinGenerator> VEINED = VeinGenerators.register(GTCEu.id("veined"), VeinedVeinGenerator.CODEC, VeinedVeinGenerator::new);
    public static final Codec<ClassicVeinGenerator> CLASSIC = VeinGenerators.register(GTCEu.id("classic"), ClassicVeinGenerator.CODEC, ClassicVeinGenerator::new);
    public static final Codec<CuboidVeinGenerator> CUBOID = VeinGenerators.register(GTCEu.id("cuboid"), CuboidVeinGenerator.CODEC, CuboidVeinGenerator::new);

    public static <T extends VeinGenerator> Codec<T> register(ResourceLocation id, Codec<T> codec, Function<GTOreDefinition, ? extends VeinGenerator> function) {
        WorldGeneratorUtils.VEIN_GENERATORS.put((Object)id, codec);
        WorldGeneratorUtils.VEIN_GENERATOR_FUNCTIONS.put((Object)id, function);
        return codec;
    }

    public static void registerAddonGenerators() {
        AddonFinder.getAddons().forEach(IGTAddon::registerVeinGenerators);
    }
}

