/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.indicators;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreIndicatorPlacer;
import com.gregtechceu.gtceu.common.block.SurfaceRockBlock;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SurfaceIndicatorGenerator
extends IndicatorGenerator {
    public static final Codec<SurfaceIndicatorGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)BlockState.CODEC, GTCEuAPI.materialManager.codec()).fieldOf("block").forGetter(ext -> ext.block), (App)IntProvider.codec((int)1, (int)32).fieldOf("radius").forGetter(ext -> ext.radius), (App)FloatProvider.codec((float)0.0f, (float)2.0f).fieldOf("density").forGetter(ext -> ext.density), (App)IndicatorPlacement.CODEC.fieldOf("placement").forGetter(ext -> ext.placement)).apply((Applicative)instance, SurfaceIndicatorGenerator::new));
    private Either<BlockState, Material> block = Either.left((Object)Blocks.AIR.defaultBlockState());
    private IntProvider radius = ConstantInt.of((int)5);
    private FloatProvider density = ConstantFloat.of((float)0.2f);
    private IndicatorPlacement placement = IndicatorPlacement.SURFACE;

    public SurfaceIndicatorGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public SurfaceIndicatorGenerator(Either<BlockState, Material> block, IntProvider radius, FloatProvider density, IndicatorPlacement placement) {
        this.block = block;
        this.radius = radius;
        this.density = density;
        this.placement = placement;
        block.ifRight(SurfaceIndicatorGenerator::validateSurfaceRockMaterial);
    }

    public SurfaceIndicatorGenerator surfaceRock(Material material) {
        SurfaceIndicatorGenerator.validateSurfaceRockMaterial(material);
        this.block = Either.right((Object)material);
        return this;
    }

    public SurfaceIndicatorGenerator block(Block block) {
        return this.state(block.defaultBlockState());
    }

    public SurfaceIndicatorGenerator state(BlockState state) {
        this.block = Either.left((Object)state);
        return this;
    }

    public SurfaceIndicatorGenerator radius(int radius) {
        return this.radius((IntProvider)ConstantInt.of((int)radius));
    }

    public SurfaceIndicatorGenerator radius(IntProvider provider) {
        this.radius = provider;
        return this;
    }

    public SurfaceIndicatorGenerator density(float density) {
        return this.density((FloatProvider)ConstantFloat.of((float)density));
    }

    public SurfaceIndicatorGenerator density(FloatProvider provider) {
        this.density = provider;
        return this;
    }

    public SurfaceIndicatorGenerator placement(IndicatorPlacement placement) {
        this.placement = placement;
        return this;
    }

    private static void validateSurfaceRockMaterial(Material material) {
        if (GTMaterialBlocks.SURFACE_ROCK_BLOCKS.get(material) == null) {
            throw new IllegalArgumentException("No surface rock registered for material " + material.getName());
        }
    }

    @Override
    public Map<ChunkPos, OreIndicatorPlacer> generate(WorldGenLevel level, RandomSource random, GeneratedVeinMetadata metadata) {
        BlockState blockState = this.placement.stateTransformer.apply(this.block);
        int radius = this.radius.sample(random);
        float density = this.density.sample(random);
        BlockPos center = metadata.center();
        Stream<BlockPos> positionStream = BlockPos.betweenClosedStream((int)(center.getX() - radius), (int)center.getY(), (int)(center.getZ() - radius), (int)(center.getX() + radius), (int)center.getY(), (int)(center.getZ() + radius)).map(BlockPos::immutable);
        List<BlockPos> positions = positionStream.filter(pos -> pos.equals((Object)center) || random.nextFloat() <= density).filter(pos -> Math.sqrt(pos.distSqr((Vec3i)center)) <= (double)radius).toList();
        return WorldGeneratorUtils.groupByChunks(positions).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.createPlacer(level, (List)entry.getValue(), blockState)));
    }

    private OreIndicatorPlacer createPlacer(WorldGenLevel level, List<BlockPos> positionsWithoutY, BlockState blockState) {
        return access -> {
            List<BlockPos> positions = positionsWithoutY.stream().map(pos -> (BlockPos)this.placement.resolver.apply((Object)level, (Object)access, pos)).filter(pos -> !level.isOutsideBuildHeight(pos)).toList();
            for (BlockPos pos2 : positions) {
                int sectionZ;
                int sectionY;
                int sectionX;
                LevelChunkSection section = Objects.requireNonNull(access.getSection(pos2));
                if (!section.getBlockState(sectionX = SectionPos.sectionRelative((int)pos2.getX()), sectionY = SectionPos.sectionRelative((int)pos2.getY()), sectionZ = SectionPos.sectionRelative((int)pos2.getZ())).isAir()) {
                    return;
                }
                if (!blockState.canSurvive((LevelReader)level, pos2)) {
                    return;
                }
                section.setBlockState(sectionX, sectionY, sectionZ, blockState, false);
            }
        };
    }

    @Override
    @Nullable
    public Either<BlockState, Material> block() {
        return this.block;
    }

    @Override
    public int getSearchRadiusModifier(int veinRadius) {
        return Math.max(0, this.radius.getMaxValue() - veinRadius);
    }

    @Override
    public Codec<? extends IndicatorGenerator> codec() {
        return CODEC;
    }

    public static enum IndicatorPlacement implements StringRepresentable
    {
        SURFACE((TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos>)((TriFunction)(level, access, pos) -> pos.atY(Math.max(level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, pos.getX(), pos.getZ()), pos.getY()))), block -> IndicatorPlacement.getBlockState((Either<BlockState, Material>)block, Direction.DOWN)),
        ABOVE((TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos>)((TriFunction)(level, access, initialPos) -> WorldGeneratorUtils.findBlockPos(initialPos, pos -> access.getBlockState(pos).isAir() && access.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP), pos -> pos.move(Direction.UP, 1), level.getMaxBuildHeight() - initialPos.getY()).orElse((BlockPos)initialPos)), block -> IndicatorPlacement.getBlockState((Either<BlockState, Material>)block, Direction.DOWN)),
        BELOW((TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos>)((TriFunction)(level, access, initialPos) -> WorldGeneratorUtils.findBlockPos(initialPos, pos -> access.getBlockState(pos).isAir() && access.getBlockState(pos.above()).isFaceSturdy((BlockGetter)level, pos.above(), Direction.DOWN), pos -> pos.move(Direction.DOWN, 1), initialPos.getY() - level.getMinBuildHeight()).orElse((BlockPos)initialPos)), block -> IndicatorPlacement.getBlockState((Either<BlockState, Material>)block, Direction.UP));

        public static final Codec<IndicatorPlacement> CODEC;
        public final TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos> resolver;
        public final Function<Either<BlockState, Material>, BlockState> stateTransformer;

        private static BlockState getBlockState(Either<BlockState, Material> block, Direction direction) {
            return (BlockState)block.map(state -> state, material -> ((SurfaceRockBlock)((Object)((Object)GTMaterialBlocks.SURFACE_ROCK_BLOCKS.get(material).get()))).getStateForDirection(direction));
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @NotNull
        public static IndicatorPlacement getByName(String name) {
            return IndicatorPlacement.valueOf(name.toUpperCase(Locale.ROOT));
        }

        @Generated
        private IndicatorPlacement(TriFunction<WorldGenLevel, BulkSectionAccess, BlockPos, BlockPos> resolver, Function<Either<BlockState, Material>, BlockState> stateTransformer) {
            this.resolver = resolver;
            this.stateTransformer = stateTransformer;
        }

        static {
            CODEC = StringRepresentable.fromEnum(IndicatorPlacement::values);
        }
    }
}

