/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.NotNull;

public class ClassicVeinGenerator
extends VeinGenerator {
    public static final Codec<ClassicVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Layer.CODEC.fieldOf("primary").forGetter(val -> val.primary), (App)Layer.CODEC.fieldOf("secondary").forGetter(val -> val.secondary), (App)Layer.CODEC.fieldOf("between").forGetter(val -> val.between), (App)Layer.CODEC.fieldOf("sporadic").forGetter(val -> val.sporadic), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("y_radius", (Object)3).forGetter(val -> val.yRadius)).apply((Applicative)instance, ClassicVeinGenerator::new));
    private Layer primary;
    private Layer secondary;
    private Layer between;
    private Layer sporadic;
    private int yRadius = 6;
    private int sporadicDivisor;
    private int startPrimary;
    private int startBetween;
    private RuleTest[] rules;

    public ClassicVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public ClassicVeinGenerator(Layer primary, Layer secondary, Layer between, Layer sporadic, int yRadius) {
        this.primary = primary;
        this.secondary = secondary;
        this.between = between;
        this.sporadic = sporadic;
        this.yRadius = yRadius;
    }

    @Override
    public List<VeinGenerator.VeinEntry> getAllEntries() {
        ArrayList<VeinGenerator.VeinEntry> entries = new ArrayList<VeinGenerator.VeinEntry>(this.primary.size() + this.secondary.size() + this.between.size() + this.sporadic.size());
        VeinGenerator.mapTarget(this.primary.target, this.primary.layers).forEach(entries::add);
        VeinGenerator.mapTarget(this.secondary.target, this.secondary.layers).forEach(entries::add);
        VeinGenerator.mapTarget(this.between.target, this.between.layers).forEach(entries::add);
        VeinGenerator.mapTarget(this.sporadic.target, 1).forEach(entries::add);
        return entries;
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        int radius = entry.clusterSize().sample(random) / 2;
        int ySize = radius / 2;
        int xy2 = radius * radius * ySize * ySize;
        int xz2 = radius * radius * radius * radius;
        int yz2 = ySize * ySize * radius * radius;
        int xyz2 = xy2 * radius * radius;
        int xPos = origin.getX();
        int yPos = origin.getY();
        int zPos = origin.getZ();
        int max = Math.max(ySize, radius);
        int yMax = Math.min(max, this.yRadius);
        BlockPos minPos = new BlockPos(xPos - max, yPos - yMax, zPos - max);
        for (int xOffset = -max; xOffset <= max; ++xOffset) {
            int xr = yz2 * xOffset * xOffset;
            if (xr > xyz2) continue;
            for (int yOffset = -yMax; yOffset <= yMax; ++yOffset) {
                int yr = xr + xz2 * yOffset * yOffset + xy2;
                if (yr > xyz2 || level.isOutsideBuildHeight(yOffset + yPos)) continue;
                for (int zOffset = -max; zOffset <= max; ++zOffset) {
                    int zr = yr + xy2 * zOffset * zOffset;
                    if (zr > xyz2) continue;
                    long randomSeed = random.nextLong();
                    BlockPos currentPos = new BlockPos(xOffset + xPos, yOffset + yPos, zOffset + zPos);
                    generatedBlocks.put(currentPos, (access, section) -> this.placeBlock(access, section, randomSeed, entry, currentPos, minPos));
                }
            }
        }
        return generatedBlocks;
    }

    private void placeBlock(BulkSectionAccess access, LevelChunkSection section, long randomSeed, GTOreDefinition entry, BlockPos blockPos, BlockPos lowestPos) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(randomSeed);
        int x = SectionPos.sectionRelative((int)blockPos.getX());
        int y = SectionPos.sectionRelative((int)blockPos.getY());
        int z = SectionPos.sectionRelative((int)blockPos.getZ());
        BlockState blockState = section.getBlockState(x, y, z);
        int layer = blockPos.getY() - lowestPos.getY();
        if (layer >= this.startBetween && layer - this.startBetween + 1 <= this.between.layers && random.nextFloat() <= entry.density() / 2.0f) {
            this.between.place(blockState, access, section, randomSeed, entry, blockPos);
            return;
        }
        if (layer >= this.startPrimary) {
            if (random.nextFloat() <= entry.density()) {
                this.primary.place(blockState, access, section, randomSeed, entry, blockPos);
                return;
            }
        } else if (random.nextFloat() <= entry.density()) {
            this.secondary.place(blockState, access, section, randomSeed, entry, blockPos);
            return;
        }
        if (random.nextFloat() <= entry.density() / (float)this.sporadicDivisor) {
            this.sporadic.place(blockState, access, section, randomSeed, entry, blockPos);
        }
    }

    @Override
    public VeinGenerator build() {
        this.primary.layers = this.primary.layers == -1 ? 4 : this.primary.layers;
        this.secondary.layers = this.secondary.layers == -1 ? 3 : this.secondary.layers;
        this.between.layers = this.between.layers == -1 ? 3 : this.between.layers;
        Preconditions.checkArgument((this.primary.layers + this.secondary.layers >= this.between.layers ? 1 : 0) != 0, (Object)"Error: cannot have more \"between\" layers than primary and secondary layers combined!");
        this.sporadicDivisor = this.primary.layers + this.secondary.layers - 1;
        this.startPrimary = this.secondary.layers;
        this.startBetween = this.secondary.layers - this.between.layers / 2;
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new ClassicVeinGenerator(this.primary.copy(), this.secondary.copy(), this.between.copy(), this.sporadic.copy(), this.yRadius);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    public ClassicVeinGenerator primary(Consumer<Layer.Builder> builder) {
        RuleTest[] ruleTestArray;
        if (this.rules != null) {
            ruleTestArray = this.rules;
        } else {
            RuleTest[] ruleTestArray2 = new RuleTest[1];
            ruleTestArray = ruleTestArray2;
            ruleTestArray2[0] = AlwaysTrueTest.INSTANCE;
        }
        Layer.Builder layerBuilder = new Layer.Builder(ruleTestArray);
        builder.accept(layerBuilder);
        this.primary = layerBuilder.build();
        return this;
    }

    public ClassicVeinGenerator secondary(Consumer<Layer.Builder> builder) {
        RuleTest[] ruleTestArray;
        if (this.rules != null) {
            ruleTestArray = this.rules;
        } else {
            RuleTest[] ruleTestArray2 = new RuleTest[1];
            ruleTestArray = ruleTestArray2;
            ruleTestArray2[0] = AlwaysTrueTest.INSTANCE;
        }
        Layer.Builder layerBuilder = new Layer.Builder(ruleTestArray);
        builder.accept(layerBuilder);
        this.secondary = layerBuilder.build();
        return this;
    }

    public ClassicVeinGenerator between(Consumer<Layer.Builder> builder) {
        RuleTest[] ruleTestArray;
        if (this.rules != null) {
            ruleTestArray = this.rules;
        } else {
            RuleTest[] ruleTestArray2 = new RuleTest[1];
            ruleTestArray = ruleTestArray2;
            ruleTestArray2[0] = AlwaysTrueTest.INSTANCE;
        }
        Layer.Builder layerBuilder = new Layer.Builder(ruleTestArray);
        builder.accept(layerBuilder);
        this.between = layerBuilder.build();
        return this;
    }

    public ClassicVeinGenerator sporadic(Consumer<Layer.Builder> builder) {
        RuleTest[] ruleTestArray;
        if (this.rules != null) {
            ruleTestArray = this.rules;
        } else {
            RuleTest[] ruleTestArray2 = new RuleTest[1];
            ruleTestArray = ruleTestArray2;
            ruleTestArray2[0] = AlwaysTrueTest.INSTANCE;
        }
        Layer.Builder layerBuilder = new Layer.Builder(ruleTestArray);
        builder.accept(layerBuilder);
        this.sporadic = layerBuilder.build();
        return this;
    }

    @NotNull
    @Generated
    public ClassicVeinGenerator yRadius(int yRadius) {
        this.yRadius = yRadius;
        return this;
    }

    @NotNull
    @Generated
    public ClassicVeinGenerator rules(RuleTest[] rules) {
        this.rules = rules;
        return this;
    }

    public static class Layer {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)OreConfiguration.TargetBlockState.CODEC.listOf(), GTCEuAPI.materialManager.codec()).fieldOf("targets").forGetter(layer -> layer.target), (App)ExtraCodecs.intRange((int)-1, (int)Integer.MAX_VALUE).optionalFieldOf("layers", (Object)-1).forGetter(layer -> layer.layers)).apply((Applicative)instance, Layer::new));
        public final Either<List<OreConfiguration.TargetBlockState>, Material> target;
        public int layers;

        public void place(BlockState blockState, BulkSectionAccess access, LevelChunkSection section, long randomSeed, GTOreDefinition entry, BlockPos pos) {
            XoroshiroRandomSource random = new XoroshiroRandomSource(randomSeed);
            int x = SectionPos.sectionRelative((int)pos.getX());
            int y = SectionPos.sectionRelative((int)pos.getY());
            int z = SectionPos.sectionRelative((int)pos.getZ());
            this.target.ifLeft(arg_0 -> Layer.lambda$place$3(blockState, access, (RandomSource)random, entry, pos, section, x, y, z, arg_0)).ifRight(arg_0 -> Layer.lambda$place$4(blockState, access, (RandomSource)random, entry, pos, section, x, y, z, arg_0));
        }

        public Layer copy() {
            return new Layer((Either<List<OreConfiguration.TargetBlockState>, Material>)this.target.mapBoth(ArrayList::new, Function.identity()), this.layers);
        }

        public int size() {
            return this.target.left().isPresent() ? ((List)this.target.left().get()).size() : 1;
        }

        @Generated
        public Layer(Either<List<OreConfiguration.TargetBlockState>, Material> target, int layers) {
            this.target = target;
            this.layers = layers;
        }

        private static /* synthetic */ void lambda$place$4(BlockState blockState, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos pos, LevelChunkSection section, int x, int y, int z, Material material) {
            if (!OreVeinUtil.canPlaceOre(blockState, arg_0 -> ((BulkSectionAccess)access).getBlockState(arg_0), random, entry, pos)) {
                return;
            }
            BlockState currentState = access.getBlockState(pos);
            Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
            if (prefix.isEmpty()) {
                return;
            }
            Block toPlace = ChemicalHelper.getBlock(prefix.get(), material);
            if (toPlace == null || toPlace.defaultBlockState().isAir()) {
                return;
            }
            section.setBlockState(x, y, z, toPlace.defaultBlockState(), false);
        }

        private static /* synthetic */ void lambda$place$3(BlockState blockState, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos pos, LevelChunkSection section, int x, int y, int z, List blockStates) {
            for (OreConfiguration.TargetBlockState targetState : blockStates) {
                if (!OreVeinUtil.canPlaceOre(blockState, arg_0 -> ((BulkSectionAccess)access).getBlockState(arg_0), random, entry, targetState, pos) || targetState.state.isAir()) continue;
                section.setBlockState(x, y, z, targetState.state, false);
                break;
            }
        }

        public static class Builder {
            private Either<List<OreConfiguration.TargetBlockState>, Material> target;
            private int size = -1;
            private final RuleTest[] rules;

            protected Builder(RuleTest ... rules) {
                this.rules = rules;
            }

            public Builder block(Supplier<? extends Block> block) {
                return this.state(block.get().defaultBlockState());
            }

            public Builder state(Supplier<? extends BlockState> state) {
                return this.state(state.get());
            }

            public Builder state(BlockState state) {
                this.target = Either.left(Arrays.stream(this.rules).map(rule -> OreConfiguration.target((RuleTest)rule, (BlockState)state)).toList());
                return this;
            }

            public Builder mat(Material material) {
                this.target = Either.right((Object)material);
                return this;
            }

            public Builder size(int size) {
                this.size = size;
                return this;
            }

            public Layer build() {
                return new Layer(this.target, this.size);
            }
        }
    }
}

