/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTLayerPattern;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class LayeredVeinGenerator
extends VeinGenerator {
    public static final Codec<LayeredVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GTLayerPattern.CODEC.listOf().fieldOf("layer_patterns").forGetter(LayeredVeinGenerator::getLayerPatterns)).apply((Applicative)instance, LayeredVeinGenerator::new));
    private final List<NonNullSupplier<GTLayerPattern>> bakingLayerPatterns = new ArrayList<NonNullSupplier<GTLayerPattern>>();
    public List<GTLayerPattern> layerPatterns;

    public LayeredVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public List<GTLayerPattern> getLayerPatterns() {
        if (this.layerPatterns == null || this.layerPatterns.isEmpty()) {
            this.layerPatterns = this.bakingLayerPatterns.stream().map(Supplier::get).collect(Collectors.toList());
        }
        return this.layerPatterns;
    }

    @Override
    public List<VeinGenerator.VeinEntry> getAllEntries() {
        return this.getLayerPatterns().stream().flatMap(pattern -> pattern.layers.stream()).flatMap(GTLayerPattern.Layer::asVeinEntries).distinct().toList();
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        List<GTLayerPattern> patternPool = this.getLayerPatterns();
        if (patternPool.isEmpty()) {
            return Map.of();
        }
        GTLayerPattern layerPattern = patternPool.get(random.nextInt(patternPool.size()));
        int size = entry.clusterSize().sample(random);
        float density = entry.density();
        int radius = Mth.ceil((float)((float)size / 2.0f));
        int xMin = origin.getX() - radius;
        int yMin = origin.getY() - radius;
        int zMin = origin.getZ() - radius;
        int width = radius * 2 + 1;
        int length = radius * 2 + 1;
        int height = radius * 2 + 1;
        if (origin.getY() >= level.getMaxBuildHeight()) {
            return Map.of();
        }
        ArrayList<GTLayerPattern.Layer> resolvedLayers = new ArrayList<GTLayerPattern.Layer>();
        FloatArrayList layerDiameterOffsets = new FloatArrayList();
        int layerCoordinate = random.nextInt(4);
        int slantyCoordinate = random.nextInt(3);
        float slope = random.nextFloat() * 0.75f;
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            float sizeFractionX = (float)xOffset * 2.0f / (float)width - 1.0f;
            if (sizeFractionX * sizeFractionX > 1.0f) continue;
            for (int yOffset = 0; yOffset < height; ++yOffset) {
                float sizeFractionY = (float)yOffset * 2.0f / (float)height - 1.0f;
                if (sizeFractionX * sizeFractionX + sizeFractionY * sizeFractionY > 1.0f || level.isOutsideBuildHeight(yMin + yOffset)) continue;
                for (int zOffset = 0; zOffset < length; ++zOffset) {
                    int layerIndex;
                    float sizeFractionZ = (float)zOffset * 2.0f / (float)length - 1.0f;
                    int n = layerCoordinate == 0 ? zOffset : (layerIndex = layerCoordinate == 1 ? xOffset : yOffset);
                    if (slantyCoordinate != layerCoordinate) {
                        layerIndex = (int)((float)layerIndex + (float)Mth.floor((float)(slantyCoordinate == 0 ? (float)zOffset : (slantyCoordinate == 1 ? (float)xOffset : (float)yOffset))) * slope);
                    }
                    while (layerIndex >= resolvedLayers.size()) {
                        GTLayerPattern.Layer next = layerPattern.rollNext(resolvedLayers.isEmpty() ? null : (GTLayerPattern.Layer)resolvedLayers.get(resolvedLayers.size() - 1), random);
                        float offset = random.nextFloat() * 0.5f + 0.5f;
                        for (int i = 0; i < next.minSize + random.nextInt(1 + next.maxSize - next.minSize); ++i) {
                            resolvedLayers.add(next);
                            layerDiameterOffsets.add(offset);
                        }
                    }
                    if (sizeFractionX * sizeFractionX + sizeFractionY * sizeFractionY + sizeFractionZ * sizeFractionZ > 1.0f * layerDiameterOffsets.getFloat(layerIndex)) continue;
                    GTLayerPattern.Layer layer = (GTLayerPattern.Layer)resolvedLayers.get(layerIndex);
                    Either<List<OreConfiguration.TargetBlockState>, Material> state = layer.rollBlock(random);
                    int currentX = xMin + xOffset;
                    int currentY = yMin + yOffset;
                    int currentZ = zMin + zOffset;
                    long randomSeed = random.nextLong();
                    BlockPos currentPos = new BlockPos(currentX, currentY, currentZ);
                    generatedBlocks.put(currentPos, (access, section) -> LayeredVeinGenerator.placeBlock(access, section, randomSeed, entry, density, state, currentPos));
                }
            }
        }
        return generatedBlocks;
    }

    private static void placeBlock(BulkSectionAccess access, LevelChunkSection section, long randomSeed, GTOreDefinition entry, float density, Either<List<OreConfiguration.TargetBlockState>, Material> state, BlockPos pos) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(randomSeed);
        int x = SectionPos.sectionRelative((int)pos.getX());
        int y = SectionPos.sectionRelative((int)pos.getY());
        int z = SectionPos.sectionRelative((int)pos.getZ());
        BlockState blockState = section.getBlockState(x, y, z);
        BlockPos.MutableBlockPos posCursor = pos.mutable();
        if (random.nextFloat() <= density) {
            state.ifLeft(arg_0 -> LayeredVeinGenerator.lambda$placeBlock$3(blockState, access, (RandomSource)random, entry, posCursor, section, x, y, z, arg_0)).ifRight(arg_0 -> LayeredVeinGenerator.lambda$placeBlock$4(blockState, access, (RandomSource)random, entry, posCursor, section, x, y, z, arg_0));
        }
    }

    public LayeredVeinGenerator(List<GTLayerPattern> layerPatterns) {
        this.layerPatterns = layerPatterns;
    }

    public LayeredVeinGenerator buildLayerPattern(Consumer<GTLayerPattern.Builder> config) {
        GTLayerPattern.Builder builder = GTLayerPattern.builder(this.parent().layer().getTarget());
        config.accept(builder);
        return this.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)builder::build));
    }

    public LayeredVeinGenerator withLayerPattern(NonNullSupplier<GTLayerPattern> pattern) {
        this.bakingLayerPatterns.add(pattern);
        return this;
    }

    @Override
    public VeinGenerator build() {
        if (this.layerPatterns != null && !this.layerPatterns.isEmpty()) {
            return this;
        }
        this.layerPatterns = this.bakingLayerPatterns.stream().map(NonNullSupplier::get).toList();
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new LayeredVeinGenerator(new ArrayList<GTLayerPattern>(this.layerPatterns));
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    private static /* synthetic */ void lambda$placeBlock$4(BlockState blockState, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos.MutableBlockPos posCursor, LevelChunkSection section, int x, int y, int z, Material material) {
        if (!OreVeinUtil.canPlaceOre(blockState, arg_0 -> ((BulkSectionAccess)access).getBlockState(arg_0), random, entry, (BlockPos)posCursor)) {
            return;
        }
        BlockState currentState = access.getBlockState((BlockPos)posCursor);
        Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
        if (prefix.isEmpty()) {
            return;
        }
        Block toPlace = ChemicalHelper.getBlock(prefix.get(), material);
        if (toPlace == null || toPlace.defaultBlockState().isAir()) {
            return;
        }
        section.setBlockState(x, y, z, toPlace.defaultBlockState(), false);
    }

    private static /* synthetic */ void lambda$placeBlock$3(BlockState blockState, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos.MutableBlockPos posCursor, LevelChunkSection section, int x, int y, int z, List blockStates) {
        for (OreConfiguration.TargetBlockState targetState : blockStates) {
            if (!OreVeinUtil.canPlaceOre(blockState, arg_0 -> ((BulkSectionAccess)access).getBlockState(arg_0), random, entry, targetState, (BlockPos)posCursor) || targetState.state.isAir()) continue;
            section.setBlockState(x, y, z, targetState.state, false);
            break;
        }
    }
}

