/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.apache.commons.lang3.mutable.MutableInt;

public class StandardVeinGenerator
extends VeinGenerator {
    public static final Codec<StandardVeinGenerator> CODEC_SEPARATE = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(ext -> (Block)ext.block.get()), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("deep_block").forGetter(ext -> (Block)ext.deepBlock.get()), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("nether_block").forGetter(ext -> (Block)ext.netherBlock.get())).apply((Applicative)instance, StandardVeinGenerator::new));
    public static final Codec<StandardVeinGenerator> CODEC_LIST = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)OreConfiguration.TargetBlockState.CODEC.listOf(), GTCEuAPI.materialManager.codec()).fieldOf("targets").forGetter(ext -> ext.blocks)).apply((Applicative)instance, StandardVeinGenerator::new));
    public static final Codec<StandardVeinGenerator> CODEC = Codec.either(CODEC_SEPARATE, CODEC_LIST).xmap(either -> (StandardVeinGenerator)either.map(Function.identity(), Function.identity()), Either::left);
    public NonNullSupplier<? extends Block> block;
    public NonNullSupplier<? extends Block> deepBlock;
    public NonNullSupplier<? extends Block> netherBlock;
    public Either<List<OreConfiguration.TargetBlockState>, Material> blocks;
    private List<VeinGenerator.VeinEntry> defaultEntries = null;

    public StandardVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    public StandardVeinGenerator(Block block, Block deepBlock, Block netherBlock) {
        this.block = NonNullSupplier.of(() -> block);
        this.deepBlock = NonNullSupplier.of(() -> deepBlock);
        this.netherBlock = NonNullSupplier.of(() -> netherBlock);
    }

    public StandardVeinGenerator(Either<List<OreConfiguration.TargetBlockState>, Material> blocks) {
        this.blocks = blocks;
    }

    public StandardVeinGenerator withBlock(NonNullSupplier<? extends Block> block) {
        this.block = block;
        this.deepBlock = block;
        return this;
    }

    public StandardVeinGenerator withNetherBlock(NonNullSupplier<? extends Block> block) {
        this.netherBlock = block;
        return this;
    }

    public StandardVeinGenerator withMaterial(Material material) {
        this.blocks = Either.right((Object)material);
        return this;
    }

    private List<VeinGenerator.VeinEntry> getDefaultEntries() {
        if (this.defaultEntries == null) {
            this.defaultEntries = List.of(VeinGenerator.VeinEntry.ofBlock(((Block)this.block.get()).defaultBlockState(), 1), VeinGenerator.VeinEntry.ofBlock(((Block)this.deepBlock.get()).defaultBlockState(), 1), VeinGenerator.VeinEntry.ofBlock(((Block)this.netherBlock.get()).defaultBlockState(), 1));
        }
        return this.defaultEntries;
    }

    @Override
    public List<VeinGenerator.VeinEntry> getAllEntries() {
        if (this.blocks != null) {
            return VeinGenerator.mapTarget(this.blocks, 1).toList();
        }
        return this.getDefaultEntries();
    }

    @Override
    public VeinGenerator build() {
        if (this.blocks != null) {
            return this;
        }
        ArrayList<OreConfiguration.TargetBlockState> targetStates = new ArrayList<OreConfiguration.TargetBlockState>();
        if (this.block != null) {
            targetStates.add(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)this.block.get()).defaultBlockState()));
        }
        if (this.deepBlock != null) {
            targetStates.add(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)this.deepBlock.get()).defaultBlockState()));
        }
        if (this.netherBlock != null) {
            targetStates.add(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.NETHER_CARVER_REPLACEABLES), (BlockState)((Block)this.netherBlock.get()).defaultBlockState()));
        }
        this.blocks = Either.left(targetStates);
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new StandardVeinGenerator((Either<List<OreConfiguration.TargetBlockState>, Material>)this.blocks.mapBoth(ArrayList::new, Function.identity()));
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        int size = entry.clusterSize().sample(random);
        float f = random.nextFloat() * (float)Math.PI;
        float f1 = (float)size / 8.0f;
        int i = Mth.ceil((float)(((float)size / 16.0f * 2.0f + 1.0f) / 2.0f));
        double minX = (double)origin.getX() + Math.sin(f) * (double)f1;
        double maxX = (double)origin.getX() - Math.sin(f) * (double)f1;
        double minZ = (double)origin.getZ() + Math.cos(f) * (double)f1;
        double maxZ = (double)origin.getZ() - Math.cos(f) * (double)f1;
        double minY = origin.getY() + random.nextInt(3) - 2;
        double maxY = origin.getY() + random.nextInt(3) - 2;
        int x = origin.getX() - Mth.ceil((float)f1) - i;
        int y = origin.getY() - 2 - i;
        int z = origin.getZ() - Mth.ceil((float)f1) - i;
        int width = 2 * (Mth.ceil((float)f1) + i);
        int height = 2 * (2 + i);
        for (int heightmapX = x; heightmapX <= x + width; ++heightmapX) {
            for (int heightmapZ = z; heightmapZ <= z + width; ++heightmapZ) {
                this.doPlaceNormal((Map<BlockPos, OreBlockPlacer>)generatedBlocks, random, entry, origin, this.blocks, minX, maxX, minZ, maxZ, minY, maxY, x, y, z, width, height);
                if (generatedBlocks.isEmpty()) continue;
                return generatedBlocks;
            }
        }
        return generatedBlocks;
    }

    protected void doPlaceNormal(Map<BlockPos, OreBlockPlacer> generatedBlocks, RandomSource random, GTOreDefinition entry, BlockPos origin, Either<List<OreConfiguration.TargetBlockState>, Material> targets, double pMinX, double pMaxX, double pMinZ, double pMaxZ, double pMinY, double pMaxY, int pX, int pY, int pZ, int pWidth, int pHeight) {
        double randomShapeOffset;
        int centerOffset;
        MutableInt placedAmount = new MutableInt(1);
        BitSet placedBlocks = new BitSet(pWidth * pHeight * pWidth);
        BlockPos.MutableBlockPos posCursor = new BlockPos.MutableBlockPos();
        int size = entry.clusterSize().sample(random);
        float density = entry.density();
        double[] shape = new double[size * 4];
        for (centerOffset = 0; centerOffset < size; ++centerOffset) {
            float centerOffsetFraction = (float)centerOffset / (float)size;
            double x = Mth.lerp((double)centerOffsetFraction, (double)pMinX, (double)pMaxX);
            double y = Mth.lerp((double)centerOffsetFraction, (double)pMinY, (double)pMaxY);
            double z = Mth.lerp((double)centerOffsetFraction, (double)pMinZ, (double)pMaxZ);
            double randomOffsetModifier = random.nextDouble() * (double)size / 16.0;
            randomShapeOffset = ((double)(Mth.sin((float)((float)Math.PI * centerOffsetFraction)) + 1.0f) * randomOffsetModifier + 1.0) / 2.0;
            int shapeIdxOffset = centerOffset * 4;
            shape[shapeIdxOffset] = x;
            shape[shapeIdxOffset + 1] = y;
            shape[shapeIdxOffset + 2] = z;
            shape[shapeIdxOffset + 3] = randomShapeOffset;
        }
        for (centerOffset = 0; centerOffset < size - 1; ++centerOffset) {
            int shapeIdxOffset1 = centerOffset * 4;
            if (shape[shapeIdxOffset1 + 3] <= 0.0) continue;
            for (int i4 = centerOffset + 1; i4 < size; ++i4) {
                double z;
                double y;
                double x;
                int shapeIdxOffset2 = i4 * 4;
                if (shape[shapeIdxOffset2 + 3] <= 0.0 || !((randomShapeOffset = shape[shapeIdxOffset1 + 3] - shape[shapeIdxOffset2 + 3]) * randomShapeOffset > (x = shape[shapeIdxOffset1] - shape[shapeIdxOffset2]) * x + (y = shape[shapeIdxOffset1 + 1] - shape[shapeIdxOffset2 + 1]) * y + (z = shape[shapeIdxOffset1 + 2] - shape[shapeIdxOffset2 + 2]) * z)) continue;
                if (randomShapeOffset > 0.0) {
                    shape[shapeIdxOffset2 + 3] = -1.0;
                    continue;
                }
                shape[shapeIdxOffset1 + 3] = -1.0;
            }
        }
        for (centerOffset = 0; centerOffset < size; ++centerOffset) {
            int shapeIdxOffset = centerOffset * 4;
            StandardVeinGenerator.generateShape(generatedBlocks, random, entry, origin, targets, pX, pY, pZ, pWidth, pHeight, shape, shapeIdxOffset, placedBlocks, posCursor, density, placedAmount);
        }
    }

    private static void generateShape(Map<BlockPos, OreBlockPlacer> generatedBlocks, RandomSource random, GTOreDefinition entry, BlockPos origin, Either<List<OreConfiguration.TargetBlockState>, Material> targets, int pX, int pY, int pZ, int pWidth, int pHeight, double[] shape, int shapeIdxOffset, BitSet placedBlocks, BlockPos.MutableBlockPos posCursor, float density, MutableInt placedAmount) {
        double randomShapeOffset = shape[shapeIdxOffset + 3];
        if (randomShapeOffset < 0.0) {
            return;
        }
        double x = shape[shapeIdxOffset];
        double y = shape[shapeIdxOffset + 1];
        double z = shape[shapeIdxOffset + 2];
        int minX = Math.max(Mth.floor((double)(x - randomShapeOffset)), pX);
        int minY = Math.max(Mth.floor((double)(y - randomShapeOffset)), pY);
        int minZ = Math.max(Mth.floor((double)(z - randomShapeOffset)), pZ);
        int maxX = Math.max(Mth.floor((double)(x + randomShapeOffset)), minX);
        int maxY = Math.max(Mth.floor((double)(y + randomShapeOffset)), minY);
        int maxZ = Math.max(Mth.floor((double)(z + randomShapeOffset)), minZ);
        for (int posX = minX; posX <= maxX; ++posX) {
            double radX = ((double)posX + 0.5 - x) / randomShapeOffset;
            if (!(radX * radX < 1.0)) continue;
            posCursor.setX(posX);
            for (int posY = minY; posY <= maxY; ++posY) {
                double radY = ((double)posY + 0.5 - y) / randomShapeOffset;
                if (!(radX * radX + radY * radY < 1.0)) continue;
                posCursor.setY(posY);
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    double radZ = ((double)posZ + 0.5 - z) / randomShapeOffset;
                    if (!(radX * radX + radY * radY + radZ * radZ < 1.0)) continue;
                    posCursor.setZ(posZ);
                    int isPlaced = posX - pX + (posY - pY) * pWidth + (posZ - pZ) * pWidth * pHeight;
                    if (placedBlocks.get(isPlaced)) continue;
                    placedBlocks.set(isPlaced);
                    BlockPos pos = posCursor.immutable();
                    long randomSeed = random.nextLong();
                    generatedBlocks.put(pos, (access, section) -> StandardVeinGenerator.placeBlock(access, randomSeed, entry, targets, pos, density, placedAmount));
                }
            }
        }
    }

    private static void placeBlock(BulkSectionAccess access, long randomSeed, GTOreDefinition entry, Either<List<OreConfiguration.TargetBlockState>, Material> targets, BlockPos pos, float density, MutableInt placedAmount) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(randomSeed);
        BlockPos.MutableBlockPos posCursor = pos.mutable();
        LevelChunkSection levelchunksection = access.getSection((BlockPos)posCursor);
        if (levelchunksection == null) {
            return;
        }
        int sectionX = SectionPos.sectionRelative((int)pos.getX());
        int sectionY = SectionPos.sectionRelative((int)pos.getY());
        int sectionZ = SectionPos.sectionRelative((int)pos.getZ());
        BlockState blockstate = levelchunksection.getBlockState(sectionX, sectionY, sectionZ);
        if (!(random.nextFloat() <= density)) {
            return;
        }
        targets.ifLeft(arg_0 -> StandardVeinGenerator.lambda$placeBlock$11(blockstate, access, (RandomSource)random, entry, posCursor, levelchunksection, sectionX, sectionY, sectionZ, placedAmount, arg_0)).ifRight(arg_0 -> StandardVeinGenerator.lambda$placeBlock$12(blockstate, access, (RandomSource)random, entry, posCursor, levelchunksection, sectionX, sectionY, sectionZ, placedAmount, arg_0));
    }

    private static /* synthetic */ void lambda$placeBlock$12(BlockState blockstate, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos.MutableBlockPos posCursor, LevelChunkSection levelchunksection, int sectionX, int sectionY, int sectionZ, MutableInt placedAmount, Material material) {
        if (!OreVeinUtil.canPlaceOre(blockstate, arg_0 -> ((BulkSectionAccess)access).getBlockState(arg_0), random, entry, (BlockPos)posCursor)) {
            return;
        }
        BlockState currentState = access.getBlockState((BlockPos)posCursor);
        Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
        if (prefix.isEmpty()) {
            return;
        }
        Block toPlace = ChemicalHelper.getBlock(prefix.get(), material);
        if (toPlace == null || toPlace.defaultBlockState().isAir()) {
            return;
        }
        levelchunksection.setBlockState(sectionX, sectionY, sectionZ, toPlace.defaultBlockState(), false);
        placedAmount.increment();
    }

    private static /* synthetic */ void lambda$placeBlock$11(BlockState blockstate, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos.MutableBlockPos posCursor, LevelChunkSection levelchunksection, int sectionX, int sectionY, int sectionZ, MutableInt placedAmount, List blockStates) {
        for (OreConfiguration.TargetBlockState targetState : blockStates) {
            if (!OreVeinUtil.canPlaceOre(blockstate, arg_0 -> ((BulkSectionAccess)access).getBlockState(arg_0), random, entry, targetState, (BlockPos)posCursor)) continue;
            levelchunksection.setBlockState(sectionX, sectionY, sectionZ, targetState.state, false);
            placedAmount.increment();
            break;
        }
    }
}

