/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.gregtechceu.gtceu.common.data.GTFeatures;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.WeightedEntry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VeinedVeinGenerator
extends VeinGenerator {
    public static final Codec<Either<List<OreConfiguration.TargetBlockState>, Material>> BLOCK_ENTRY_CODEC = Codec.either((Codec)OreConfiguration.TargetBlockState.CODEC.listOf(), GTCEuAPI.materialManager.codec());
    public static final Codec<VeinedVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VeinBlockDefinition.CODEC.listOf().fieldOf("ore_blocks").forGetter(it -> it.oreBlocks), (App)VeinBlockDefinition.CODEC.listOf().fieldOf("rare_blocks").forGetter(it -> it.rareBlocks), (App)BlockState.CODEC.fieldOf("filler_block").orElse((Object)Blocks.AIR.defaultBlockState()).forGetter(it -> it.fillerBlock), (App)Codec.INT.fieldOf("min_y").forGetter(it -> it.minYLevel), (App)Codec.INT.fieldOf("max_y").forGetter(it -> it.maxYLevel), (App)Codec.FLOAT.fieldOf("veininess_threshold").orElse((Object)Float.valueOf(0.4f)).forGetter(it -> Float.valueOf(it.veininessThreshold)), (App)Codec.INT.fieldOf("edge_roundoff_begin").orElse((Object)20).forGetter(it -> it.edgeRoundoffBegin), (App)Codec.DOUBLE.fieldOf("max_edge_roundoff").orElse((Object)0.2).forGetter(it -> it.maxEdgeRoundoff), (App)Codec.FLOAT.fieldOf("min_richness").orElse((Object)Float.valueOf(0.1f)).forGetter(it -> Float.valueOf(it.minRichness)), (App)Codec.FLOAT.fieldOf("max_richness").orElse((Object)Float.valueOf(0.3f)).forGetter(it -> Float.valueOf(it.maxRichness)), (App)Codec.FLOAT.fieldOf("max_richness_threshold").orElse((Object)Float.valueOf(0.6f)).forGetter(it -> Float.valueOf(it.maxRichnessThreshold)), (App)Codec.FLOAT.fieldOf("rare_block_chance").orElse((Object)Float.valueOf(0.02f)).forGetter(it -> Float.valueOf(it.rareBlockChance))).apply((Applicative)instance, VeinedVeinGenerator::new));
    public List<VeinBlockDefinition> oreBlocks = new ArrayList<VeinBlockDefinition>();
    public List<VeinBlockDefinition> rareBlocks = new ArrayList<VeinBlockDefinition>();
    public BlockState fillerBlock = Blocks.AIR.defaultBlockState();
    public int minYLevel;
    public int maxYLevel;
    public float veininessThreshold = 0.4f;
    public int edgeRoundoffBegin = 20;
    public double maxEdgeRoundoff = 0.2;
    public float minRichness = 0.1f;
    public float maxRichness = 0.3f;
    public float maxRichnessThreshold = 0.6f;
    public float rareBlockChance = 0.02f;

    public VeinedVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<VeinGenerator.VeinEntry> getAllEntries() {
        ArrayList<VeinGenerator.VeinEntry> entries = new ArrayList<VeinGenerator.VeinEntry>(this.oreBlocks.size() + this.rareBlocks.size());
        for (VeinBlockDefinition def : this.oreBlocks) {
            VeinGenerator.mapTarget(def.block, def.weight).forEach(entries::add);
        }
        for (VeinBlockDefinition def : this.rareBlocks) {
            VeinGenerator.mapTarget(def.block, def.weight).forEach(entries::add);
        }
        return entries;
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        Blender blender;
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        Registry densityFunctions = (Registry)level.registryAccess().registry(Registries.DENSITY_FUNCTION).get();
        RandomState randomState = level.getLevel().getChunkSource().randomState();
        if (level instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)level;
            blender = Blender.of((WorldGenRegion)region);
        } else {
            blender = Blender.empty();
        }
        final Blender finalizedBlender = blender;
        DensityFunction veinToggle = VeinedVeinGenerator.mapToNoise((DensityFunction)densityFunctions.get(GTFeatures.NEW_ORE_VEIN_TOGGLE), randomState);
        DensityFunction veinRidged = VeinedVeinGenerator.mapToNoise((DensityFunction)densityFunctions.get(GTFeatures.NEW_ORE_VEIN_RIDGED), randomState);
        int size = entry.clusterSize().sample(random);
        int radius = Mth.ceil((float)((float)size / 2.0f));
        boolean placedCount = false;
        final int randOffsetX = random.nextInt(16);
        final int randOffsetY = random.nextInt(16);
        final int randOffsetZ = random.nextInt(16);
        BlockPos posMin = origin.offset(-radius, -radius, -radius);
        BlockPos posMax = origin.offset(radius, radius, radius);
        for (BlockPos chunkedPos : BlockPos.betweenClosed((BlockPos)posMin, (BlockPos)posMax)) {
            int lowY;
            double edgeRoundoff;
            final int x = chunkedPos.getX();
            final int y = chunkedPos.getY();
            final int z = chunkedPos.getZ();
            DensityFunction.FunctionContext functionContext = new DensityFunction.FunctionContext(){

                public int blockX() {
                    return x + randOffsetX;
                }

                public int blockY() {
                    return y + randOffsetY;
                }

                public int blockZ() {
                    return z + randOffsetZ;
                }

                public Blender getBlender() {
                    return finalizedBlender;
                }
            };
            double toggleNoise = veinToggle.compute(functionContext);
            int blockY = origin.getY();
            double absToggleNoise = Math.abs(toggleNoise);
            int minY = blockY - this.minYLevel;
            int maxY = this.maxYLevel - blockY;
            if (minY < 0 || maxY < 0 || absToggleNoise + (edgeRoundoff = Mth.clampedMap((double)(lowY = Math.min(maxY, minY)), (double)0.0, (double)this.edgeRoundoffBegin, (double)(-this.maxEdgeRoundoff), (double)0.0)) < (double)this.veininessThreshold || random.nextFloat() > entry.density() || veinRidged.compute(functionContext) >= 0.0) continue;
            double chance = Mth.clampedMap((double)absToggleNoise, (double)this.veininessThreshold, (double)this.maxRichnessThreshold, (double)this.minRichness, (double)this.maxRichness);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
            long randomSeed = random.nextLong();
            generatedBlocks.put(pos, (access, section) -> this.placeBlock(access, section, randomSeed, entry, chance, this.rareBlocks, pos, this.oreBlocks));
        }
        return generatedBlocks;
    }

    private void placeBlock(BulkSectionAccess access, LevelChunkSection section, long randomSeed, GTOreDefinition entry, double chance, List<VeinBlockDefinition> rareEntries, BlockPos.MutableBlockPos pos, List<VeinBlockDefinition> commonEntries) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(randomSeed);
        int sectionX = SectionPos.sectionRelative((int)pos.getX());
        int sectionY = SectionPos.sectionRelative((int)pos.getY());
        int sectionZ = SectionPos.sectionRelative((int)pos.getZ());
        BlockState current = section.getBlockState(sectionX, sectionY, sectionZ);
        if (random.nextFloat() <= entry.density()) {
            if ((double)random.nextFloat() < chance) {
                if (this.rareBlocks != null && !this.rareBlocks.isEmpty() && random.nextFloat() < this.rareBlockChance) {
                    VeinBlockDefinition ore = GTUtil.getRandomItem((RandomSource)random, rareEntries);
                    if (ore == null) {
                        return;
                    }
                    VeinedVeinGenerator.placeOre(ore.block, current, access, section, (RandomSource)random, pos, entry);
                } else {
                    VeinBlockDefinition ore = GTUtil.getRandomItem((RandomSource)random, commonEntries);
                    if (ore == null) {
                        return;
                    }
                    VeinedVeinGenerator.placeOre(ore.block, current, access, section, (RandomSource)random, pos, entry);
                }
            } else {
                if (this.fillerBlock == null || this.fillerBlock.isAir()) {
                    return;
                }
                if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((BulkSectionAccess)access).getBlockState(arg_0), (RandomSource)random, entry, (BlockPos)pos)) {
                    return;
                }
                section.setBlockState(sectionX, sectionY, sectionZ, this.fillerBlock, false);
            }
        }
    }

    protected static void placeOre(Either<List<OreConfiguration.TargetBlockState>, Material> block, BlockState current, BulkSectionAccess level, LevelChunkSection section, RandomSource random, BlockPos.MutableBlockPos pos, GTOreDefinition entry) {
        int x = SectionPos.sectionRelative((int)pos.getX());
        int y = SectionPos.sectionRelative((int)pos.getY());
        int z = SectionPos.sectionRelative((int)pos.getZ());
        block.ifLeft(blockStates -> {
            for (OreConfiguration.TargetBlockState targetState : blockStates) {
                if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((BulkSectionAccess)level).getBlockState(arg_0), random, entry, targetState, (BlockPos)pos) || targetState.state.isAir()) continue;
                section.setBlockState(x, y, z, targetState.state, false);
                break;
            }
        }).ifRight(material -> {
            if (!OreVeinUtil.canPlaceOre(current, arg_0 -> ((BulkSectionAccess)level).getBlockState(arg_0), random, entry, (BlockPos)pos)) {
                return;
            }
            BlockState currentState = level.getBlockState((BlockPos)pos);
            Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
            if (prefix.isEmpty()) {
                return;
            }
            Block toPlace = ChemicalHelper.getBlock(prefix.get(), material);
            if (toPlace == null || toPlace.defaultBlockState().isAir()) {
                return;
            }
            section.setBlockState(x, y, z, toPlace.defaultBlockState(), false);
        });
    }

    @Override
    public VeinGenerator build() {
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new VeinedVeinGenerator(new ArrayList<VeinBlockDefinition>(this.oreBlocks), new ArrayList<VeinBlockDefinition>(this.rareBlocks), this.fillerBlock, this.minYLevel, this.maxYLevel, this.veininessThreshold, this.edgeRoundoffBegin, this.maxEdgeRoundoff, this.minRichness, this.maxRichness, this.maxRichnessThreshold, this.rareBlockChance);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    public VeinedVeinGenerator oreBlock(Material block, int weight) {
        return this.oreBlock(new VeinBlockDefinition(block, weight));
    }

    public VeinedVeinGenerator oreBlock(BlockState blockState, int weight) {
        OreConfiguration.TargetBlockState target = OreConfiguration.target((RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)blockState);
        return this.oreBlock(new VeinBlockDefinition(List.of(target), weight));
    }

    public VeinedVeinGenerator oreBlock(VeinBlockDefinition material) {
        this.oreBlocks.add(material);
        return this;
    }

    public VeinedVeinGenerator rareBlock(Material block, int weight) {
        return this.rareBlock(new VeinBlockDefinition(block, weight));
    }

    public VeinedVeinGenerator rareBlock(BlockState blockState, int weight) {
        OreConfiguration.TargetBlockState target = OreConfiguration.target((RuleTest)AlwaysTrueTest.INSTANCE, (BlockState)blockState);
        return this.rareBlock(new VeinBlockDefinition(List.of(target), weight));
    }

    public VeinedVeinGenerator rareBlock(VeinBlockDefinition material) {
        this.rareBlocks.add(material);
        return this;
    }

    private static DensityFunction mapToNoise(DensityFunction function, final RandomState randomState) {
        return function.mapAll(new DensityFunction.Visitor(){

            public DensityFunction apply(DensityFunction densityFunction) {
                return densityFunction;
            }

            public DensityFunction.NoiseHolder visitNoise(DensityFunction.NoiseHolder noiseHolder) {
                Holder holder = noiseHolder.noiseData();
                NormalNoise noise = randomState.getOrCreateNoise((ResourceKey)holder.unwrapKey().orElseThrow());
                return new DensityFunction.NoiseHolder(holder, noise);
            }
        });
    }

    @Generated
    public VeinedVeinGenerator(List<VeinBlockDefinition> oreBlocks, List<VeinBlockDefinition> rareBlocks, BlockState fillerBlock, int minYLevel, int maxYLevel, float veininessThreshold, int edgeRoundoffBegin, double maxEdgeRoundoff, float minRichness, float maxRichness, float maxRichnessThreshold, float rareBlockChance) {
        this.oreBlocks = oreBlocks;
        this.rareBlocks = rareBlocks;
        this.fillerBlock = fillerBlock;
        this.minYLevel = minYLevel;
        this.maxYLevel = maxYLevel;
        this.veininessThreshold = veininessThreshold;
        this.edgeRoundoffBegin = edgeRoundoffBegin;
        this.maxEdgeRoundoff = maxEdgeRoundoff;
        this.minRichness = minRichness;
        this.maxRichness = maxRichness;
        this.maxRichnessThreshold = maxRichnessThreshold;
        this.rareBlockChance = rareBlockChance;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator fillerBlock(BlockState fillerBlock) {
        this.fillerBlock = fillerBlock;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator minYLevel(int minYLevel) {
        this.minYLevel = minYLevel;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator maxYLevel(int maxYLevel) {
        this.maxYLevel = maxYLevel;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator veininessThreshold(float veininessThreshold) {
        this.veininessThreshold = veininessThreshold;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator edgeRoundoffBegin(int edgeRoundoffBegin) {
        this.edgeRoundoffBegin = edgeRoundoffBegin;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator maxEdgeRoundoff(double maxEdgeRoundoff) {
        this.maxEdgeRoundoff = maxEdgeRoundoff;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator minRichness(float minRichness) {
        this.minRichness = minRichness;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator maxRichness(float maxRichness) {
        this.maxRichness = maxRichness;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator maxRichnessThreshold(float maxRichnessThreshold) {
        this.maxRichnessThreshold = maxRichnessThreshold;
        return this;
    }

    @NotNull
    @Generated
    public VeinedVeinGenerator rareBlockChance(float rareBlockChance) {
        this.rareBlockChance = rareBlockChance;
        return this;
    }

    public record VeinBlockDefinition(Either<List<OreConfiguration.TargetBlockState>, Material> block, int weight) implements WeightedEntry
    {
        public static final Codec<VeinBlockDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BLOCK_ENTRY_CODEC.fieldOf("block").forGetter(x -> x.block), (App)Codec.INT.fieldOf("weight").forGetter(x -> x.weight)).apply((Applicative)instance, VeinBlockDefinition::new));

        public VeinBlockDefinition(Material block, int weight) {
            this((Either<List<OreConfiguration.TargetBlockState>, Material>)Either.right((Object)block), weight);
        }

        public VeinBlockDefinition(List<OreConfiguration.TargetBlockState> block, int weight) {
            this((Either<List<OreConfiguration.TargetBlockState>, Material>)Either.left(block), weight);
        }
    }
}

