/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.modifier;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.mojang.serialization.Codec;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FrequencyModifier
extends PlacementModifier {
    public static final PlacementModifierType<FrequencyModifier> FREQUENCY_MODIFIER = GTRegistries.register(BuiltInRegistries.PLACEMENT_MODIFIER_TYPE, GTCEu.id("frequency"), () -> CODEC);
    public static final Codec<FrequencyModifier> CODEC = ExtraCodecs.POSITIVE_FLOAT.fieldOf("chance").xmap(FrequencyModifier::new, modifier -> Float.valueOf(modifier.frequency)).codec();
    private final float frequency;

    public FrequencyModifier(float frequency) {
        this.frequency = frequency;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        int count = this.getCount(this.frequency, random);
        if (count == 0) {
            return Stream.empty();
        }
        return Stream.of(pos);
    }

    public int getCount(float frequency, RandomSource random) {
        int floored = Mth.floor((float)frequency);
        return floored + (random.nextFloat() < frequency - (float)floored ? 1 : 0);
    }

    public PlacementModifierType<?> type() {
        return FREQUENCY_MODIFIER;
    }
}

