/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;

public final class GeneratedVeinMetadata {
    public static final Codec<ChunkPos> CHUNK_POS_CODEC = Codec.LONG.xmap(ChunkPos::new, ChunkPos::toLong);
    public static final Codec<GTOreDefinition> CLIENT_DEFINITION_CODEC = ResourceLocation.CODEC.flatXmap(rl -> Optional.ofNullable((GTOreDefinition)ClientProxy.CLIENT_ORE_VEINS.get(rl)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in client ore veins: " + String.valueOf(rl))), obj -> Optional.ofNullable((ResourceLocation)ClientProxy.CLIENT_ORE_VEINS.inverse().get(obj)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in client ore veins: " + String.valueOf(obj))));
    public static final Codec<GeneratedVeinMetadata> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(GeneratedVeinMetadata::id), (App)CHUNK_POS_CODEC.fieldOf("origin_chunk").forGetter(GeneratedVeinMetadata::originChunk), (App)BlockPos.CODEC.fieldOf("center").forGetter(GeneratedVeinMetadata::center), (App)GTRegistries.ORE_VEINS.codec().fieldOf("definition").forGetter(GeneratedVeinMetadata::definition), (App)Codec.BOOL.optionalFieldOf("depleted", (Object)false).forGetter(GeneratedVeinMetadata::depleted)).apply((Applicative)instance, GeneratedVeinMetadata::new));
    public static final Codec<GeneratedVeinMetadata> CLIENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(GeneratedVeinMetadata::id), (App)CHUNK_POS_CODEC.fieldOf("origin_chunk").forGetter(GeneratedVeinMetadata::originChunk), (App)BlockPos.CODEC.fieldOf("center").forGetter(GeneratedVeinMetadata::center), (App)CLIENT_DEFINITION_CODEC.fieldOf("definition").forGetter(GeneratedVeinMetadata::definition), (App)Codec.BOOL.optionalFieldOf("depleted", (Object)false).forGetter(GeneratedVeinMetadata::depleted)).apply((Applicative)instance, GeneratedVeinMetadata::new));
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final ChunkPos originChunk;
    @NotNull
    private final BlockPos center;
    @NotNull
    private GTOreDefinition definition;
    private boolean depleted;

    public GeneratedVeinMetadata(@NotNull ResourceLocation id, @NotNull ChunkPos originChunk, @NotNull BlockPos center, @NotNull GTOreDefinition definition) {
        this(id, originChunk, center, definition, false);
    }

    public GeneratedVeinMetadata(@NotNull ResourceLocation id, @NotNull ChunkPos originChunk, @NotNull BlockPos center, @NotNull GTOreDefinition definition, boolean depleted) {
        this.id = id;
        this.originChunk = originChunk;
        this.center = center;
        this.definition = definition;
        this.depleted = depleted;
    }

    public static GeneratedVeinMetadata readFromPacket(FriendlyByteBuf buf) {
        ResourceLocation id = buf.readResourceLocation();
        ChunkPos origin = new ChunkPos(buf.readVarLong());
        BlockPos center = BlockPos.of((long)buf.readVarLong());
        GTOreDefinition def = (GTOreDefinition)ClientProxy.CLIENT_ORE_VEINS.get((Object)buf.readResourceLocation());
        return new GeneratedVeinMetadata(id, origin, center, def, false);
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.id);
        buf.writeVarLong(this.originChunk.toLong());
        buf.writeVarLong(this.center.asLong());
        buf.writeResourceLocation((ResourceLocation)GTRegistries.ORE_VEINS.getKey(this.definition));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneratedVeinMetadata)) {
            return false;
        }
        GeneratedVeinMetadata that = (GeneratedVeinMetadata)object;
        return this.id.equals((Object)that.id) && this.originChunk.equals((Object)that.originChunk) && this.center.equals((Object)that.center) && this.definition.equals(that.definition);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.originChunk.hashCode();
        result = 31 * result + this.center.hashCode();
        result = 31 * result + this.definition.hashCode();
        return result;
    }

    @NotNull
    @Generated
    public ResourceLocation id() {
        return this.id;
    }

    @NotNull
    @Generated
    public ChunkPos originChunk() {
        return this.originChunk;
    }

    @NotNull
    @Generated
    public BlockPos center() {
        return this.center;
    }

    @NotNull
    @Generated
    public GTOreDefinition definition() {
        return this.definition;
    }

    @NotNull
    @Generated
    public GeneratedVeinMetadata definition(@NotNull GTOreDefinition definition) {
        if (definition == null) {
            throw new NullPointerException("definition is marked non-null but is null");
        }
        this.definition = definition;
        return this;
    }

    @Generated
    public boolean depleted() {
        return this.depleted;
    }

    @NotNull
    @Generated
    public GeneratedVeinMetadata depleted(boolean depleted) {
        this.depleted = depleted;
        return this;
    }
}

