/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.ores;

import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTOres;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OreVeinUtil {
    private OreVeinUtil() {
    }

    public static boolean canPlaceOre(BlockState pState, Function<BlockPos, BlockState> pAdjacentStateAccessor, RandomSource pRandom, GTOreDefinition entry, OreConfiguration.TargetBlockState pTargetState, BlockPos pMatablePos) {
        if (!pTargetState.target.test(pState, pRandom)) {
            return false;
        }
        if (OreVeinUtil.shouldSkipAirCheck(pRandom, entry.discardChanceOnAirExposure())) {
            return true;
        }
        return !Feature.isAdjacentToAir(pAdjacentStateAccessor, (BlockPos)pMatablePos);
    }

    public static boolean canPlaceOre(BlockState pState, Function<BlockPos, BlockState> pAdjacentStateAccessor, RandomSource pRandom, GTOreDefinition entry, BlockPos pMatablePos) {
        if (!entry.layer().getTarget().test(pState, pRandom)) {
            return false;
        }
        if (OreVeinUtil.shouldSkipAirCheck(pRandom, entry.discardChanceOnAirExposure())) {
            return true;
        }
        return !Feature.isAdjacentToAir(pAdjacentStateAccessor, (BlockPos)pMatablePos);
    }

    protected static boolean shouldSkipAirCheck(RandomSource pRandom, float pChance) {
        return pChance <= 0.0f || !(pChance >= 1.0f) && pRandom.nextFloat() >= pChance;
    }

    public static Optional<BlockPos> getVeinCenter(ChunkPos chunkPos, RandomSource random) {
        int gridSize = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinGridSize;
        int randomOffset = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinRandomOffset;
        if (chunkPos.x % gridSize != 0 || chunkPos.z % gridSize != 0) {
            return Optional.empty();
        }
        BlockPos chunkCenter = chunkPos.getMiddleBlockPosition(0);
        if (randomOffset == 0) {
            return Optional.of(chunkCenter);
        }
        return Optional.of(chunkCenter.offset(random.nextInt(-randomOffset, randomOffset), 0, random.nextInt(-randomOffset, randomOffset)));
    }

    static int getMaxVeinSearchDistance() {
        double halfVeinSize = (double)GTOres.getLargestVeinSize() / 2.0;
        int randomOffset = ConfigHolder.INSTANCE.worldgen.oreVeins.oreVeinRandomOffset;
        return (int)Math.ceil((halfVeinSize + (double)randomOffset) / 16.0);
    }

    static int getMaxIndicatorSearchDistance() {
        return OreVeinUtil.getMaxVeinSearchDistance() + (int)Math.ceil((double)GTOres.getLargestIndicatorOffset() / 16.0);
    }

    @Nullable
    public static Supplier<HolderSet<Biome>> resolveBiomes(List<String> biomes) {
        if (biomes.isEmpty()) {
            return null;
        }
        RegistryOps registryOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        JsonElement codecInput = OreVeinUtil.resolveBiomeCodecInput(biomes);
        return Suppliers.memoize(() -> (HolderSet)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).parse((DynamicOps)registryOps, (Object)codecInput).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
    }

    private static JsonElement resolveBiomeCodecInput(List<String> biomes) {
        if (biomes.size() == 1) {
            return new JsonPrimitive(biomes.get(0));
        }
        if (biomes.stream().anyMatch(filter -> filter.startsWith("#"))) {
            throw new IllegalStateException("Cannot resolve biomes: You may use either a single tag or multiple individual biomes.");
        }
        JsonArray jsonArray = new JsonArray();
        biomes.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray;
    }
}

