/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids;

import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttribute;
import com.gregtechceu.gtceu.api.fluids.attribute.IAttributedFluid;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class GTFluid
extends FlowingFluid
implements IAttributedFluid {
    private final Collection<FluidAttribute> attributes = new ObjectLinkedOpenHashSet();
    private final FluidState state;
    private final Supplier<? extends Item> bucketItem;
    private final Supplier<? extends Fluid> stillFluid;
    private final Supplier<? extends Fluid> flowingFluid;
    private final Supplier<? extends LiquidBlock> block;
    private final int burnTime;

    public GTFluid(@NotNull FluidState state, Supplier<? extends Fluid> stillFluid, Supplier<? extends Fluid> flowingFluid, Supplier<? extends LiquidBlock> block, Supplier<? extends Item> bucket, int burnTime) {
        this.state = state;
        this.stillFluid = stillFluid;
        this.flowingFluid = flowingFluid;
        this.block = block;
        this.bucketItem = bucket;
        this.burnTime = burnTime;
    }

    @Override
    public void addAttribute(@NotNull FluidAttribute attribute) {
        this.attributes.add(attribute);
    }

    protected boolean canBeReplacedWith(net.minecraft.world.level.material.FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.isSame(fluid);
    }

    public int getTickDelay(LevelReader level) {
        return 5;
    }

    protected float getExplosionResistance() {
        return 10.0f;
    }

    protected int getSlopeFindDistance(LevelReader level) {
        return 4;
    }

    protected int getDropOff(LevelReader level) {
        return 1;
    }

    protected BlockState createLegacyBlock(net.minecraft.world.level.material.FluidState state) {
        if (this.block != null && this.block.get() != null) {
            return (BlockState)this.block.get().defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(GTFluid.getLegacyLevel((net.minecraft.world.level.material.FluidState)state)));
        }
        return Blocks.AIR.defaultBlockState();
    }

    public Fluid getFlowing() {
        return this.flowingFluid != null && this.flowingFluid.get() != null ? this.flowingFluid.get() : Fluids.EMPTY;
    }

    public Fluid getSource() {
        return this.stillFluid != null && this.stillFluid.get() != null ? this.stillFluid.get() : Fluids.EMPTY;
    }

    public Item getBucket() {
        return this.bucketItem != null && this.bucketItem.get() != null ? this.bucketItem.get() : Items.AIR;
    }

    protected boolean canConvertToSource(Level world) {
        return false;
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    public boolean isSame(Fluid fluid) {
        boolean still = this.getSource() == fluid;
        boolean flowing = this.getFlowing() == fluid;
        return still || flowing;
    }

    @Override
    @Generated
    public Collection<FluidAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    @Generated
    public FluidState getState() {
        return this.state;
    }

    @Generated
    public int getBurnTime() {
        return this.burnTime;
    }
}

