/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.MutableInt;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PageSwitcher
implements IFancyUIProvider {
    private final Consumer<IFancyUIProvider> onPageSwitched;
    private List<IFancyUIProvider> pages = List.of();
    private IFancyUIProvider currentPage = null;

    public PageSwitcher(Consumer<IFancyUIProvider> onPageSwitched) {
        this.onPageSwitched = onPageSwitched;
    }

    public void setPageList(List<IFancyUIProvider> allPages, IFancyUIProvider currentPage) {
        this.pages = allPages;
        this.currentPage = currentPage;
    }

    @Override
    public Widget createMainPage(FancyMachineUIWidget widget) {
        WidgetGroup container = new WidgetGroup(0, 0, 176, 166);
        DraggableScrollableWidgetGroup scrollableGroup = new DraggableScrollableWidgetGroup(10, 10, 156, 146);
        scrollableGroup.setYScrollBarWidth(8);
        scrollableGroup.setYBarStyle((IGuiTexture)GuiTextures.SLIDER_BACKGROUND_VERTICAL, (IGuiTexture)GuiTextures.BUTTON);
        container.addWidget((Widget)scrollableGroup);
        Map<IFancyUIProvider.PageGroupingData, List<IFancyUIProvider>> groupedPages = this.pages.stream().collect(Collectors.groupingBy(page -> Objects.requireNonNullElse(page.getPageGroupingData(), new IFancyUIProvider.PageGroupingData(null, -1))));
        MutableInt currentY = new MutableInt(0);
        groupedPages.keySet().stream().sorted(Comparator.comparingInt(IFancyUIProvider.PageGroupingData::groupPositionWeight)).forEachOrdered(group -> {
            if (group.groupKey() != null) {
                scrollableGroup.addWidget((Widget)new LabelWidget(0, currentY.getAndAdd(12), group.groupKey()).setDropShadow(false));
            }
            MutableInt currentPage = new MutableInt(0);
            currentY.subtract(30);
            ((List)groupedPages.get(group)).forEach(page -> {
                int index = currentPage.getAndIncrement();
                int y = currentY.addAndGet(index % 5 == 0 ? 30 : 0);
                WidgetGroup pageWidget = new WidgetGroup(index % 5 * 30, y, 25, 25);
                pageWidget.addWidget((Widget)new ButtonWidget(0, 0, 25, 25, (IGuiTexture)GuiTextures.BACKGROUND, clickData -> this.onPageSwitched.accept((IFancyUIProvider)page)));
                pageWidget.addWidget((Widget)new ImageWidget(4, 4, 17, 17, page.getTabIcon()));
                ((Widget)pageWidget.widgets.get(0)).setHoverTooltips(new String[]{page.getTitle().getString()});
                scrollableGroup.addWidget((Widget)pageWidget);
            });
            if (!((List)groupedPages.get(group)).isEmpty()) {
                currentY.add(30);
            }
        });
        return container;
    }

    @Override
    public IGuiTexture getTabIcon() {
        return new TextTexture("+").setDropShadow(false).setColor(ChatFormatting.BLACK.getColor().intValue());
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"gtceu.gui.title_bar.page_switcher");
    }

    @Override
    public boolean hasPlayerInventory() {
        return false;
    }
}

