/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public abstract class NumberInputWidget<T extends Number>
extends WidgetGroup {
    private final ChangeValues<T> CHANGE_VALUES = this.getChangeValues();
    private final T ONE_POSITIVE = this.getOne(true);
    private final T ONE_NEGATIVE = this.getOne(false);
    private Supplier<T> valueSupplier;
    private T min = this.defaultMin();
    private T max = this.defaultMax();
    private final Consumer<T> onChanged;
    private TextFieldWidget textField;

    protected abstract T defaultMin();

    protected abstract T defaultMax();

    protected abstract String toText(T var1);

    protected abstract T fromText(String var1);

    protected abstract ChangeValues<T> getChangeValues();

    protected abstract T add(T var1, T var2);

    protected abstract T multiply(T var1, T var2);

    protected abstract T clamp(T var1, T var2, T var3);

    protected abstract void setTextFieldRange(TextFieldWidget var1, T var2, T var3);

    protected abstract T getOne(boolean var1);

    public NumberInputWidget(Supplier<T> valueSupplier, Consumer<T> onChanged) {
        this(0, 0, 100, 20, valueSupplier, onChanged);
    }

    public NumberInputWidget(Position position, Supplier<T> valueSupplier, Consumer<T> onChanged) {
        this(position, new Size(100, 20), valueSupplier, onChanged);
    }

    public NumberInputWidget(Position position, Size size, Supplier<T> valueSupplier, Consumer<T> onChanged) {
        this(position.x, position.y, size.width, size.height, valueSupplier, onChanged);
    }

    public NumberInputWidget(int x, int y, int width, int height, Supplier<T> valueSupplier, Consumer<T> onChanged) {
        super(x, y, width, height);
        this.valueSupplier = valueSupplier;
        this.onChanged = onChanged;
        this.buildUI();
    }

    public void initWidget() {
        super.initWidget();
        this.textField.setCurrentString((Object)this.toText((Number)this.valueSupplier.get()));
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        buffer.writeUtf(this.toText((Number)this.valueSupplier.get()));
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.textField.setCurrentString((Object)buffer.readUtf());
    }

    public Widget setHoverTooltips(String ... tooltipText) {
        this.textField.setHoverTooltips(tooltipText);
        return super.setHoverTooltips(tooltipText);
    }

    private void buildUI() {
        int buttonWidth = Mth.clamp((int)(this.getSize().width / 5), (int)15, (int)40);
        int textFieldWidth = this.getSize().width - 2 * buttonWidth - 4;
        this.addWidget(new ButtonWidget(0, 0, buttonWidth, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, this.getButtonTexture("-", buttonWidth)}), this::decrease).setHoverTooltips(new String[]{"gui.widget.incrementButton.default_tooltip"}));
        this.textField = new TextFieldWidget(buttonWidth + 2, 0, textFieldWidth, 20, () -> this.toText((Number)this.valueSupplier.get()), stringValue -> this.setValue(this.clamp(this.fromText((String)stringValue), this.min, this.max)));
        this.updateTextFieldRange();
        this.addWidget((Widget)this.textField);
        this.addWidget(new ButtonWidget(buttonWidth + textFieldWidth + 4, 0, buttonWidth, 20, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, this.getButtonTexture("+", buttonWidth)}), this::increase).setHoverTooltips(new String[]{"gui.widget.incrementButton.default_tooltip"}));
    }

    private IGuiTexture getButtonTexture(String prefix, int buttonWidth) {
        TextTexture texture = new TextTexture(prefix + "1");
        if (!GTCEu.isClientThread()) {
            return texture;
        }
        int maxTextWidth = buttonWidth - 4;
        texture.setSupplier(() -> {
            Object amount = GTUtil.isCtrlDown() ? (GTUtil.isShiftDown() ? this.CHANGE_VALUES.ctrlShift : this.CHANGE_VALUES.ctrl) : (GTUtil.isShiftDown() ? this.CHANGE_VALUES.shift : this.CHANGE_VALUES.regular);
            String text = prefix + this.toText(amount);
            texture.scale((float)maxTextWidth / (float)Math.max(Minecraft.getInstance().font.width(text), maxTextWidth));
            return text;
        });
        return texture;
    }

    private void increase(ClickData cd) {
        this.changeValue(cd, this.ONE_POSITIVE);
    }

    private void decrease(ClickData cd) {
        this.changeValue(cd, this.ONE_NEGATIVE);
    }

    private void changeValue(ClickData cd, T multiplier) {
        if (!cd.isRemote) {
            Object amount = cd.isCtrlClick ? (cd.isShiftClick ? this.CHANGE_VALUES.ctrlShift : this.CHANGE_VALUES.ctrl) : (cd.isShiftClick ? this.CHANGE_VALUES.shift : this.CHANGE_VALUES.regular);
            this.setValue(this.clamp(this.add((Number)this.valueSupplier.get(), this.multiply(amount, multiplier)), this.min, this.max));
        }
    }

    public NumberInputWidget<T> setMin(T min) {
        this.min = min;
        this.updateTextFieldRange();
        return this;
    }

    public NumberInputWidget<T> setMax(T max) {
        this.max = max;
        this.updateTextFieldRange();
        return this;
    }

    public NumberInputWidget<T> setValue(T value) {
        this.onChanged.accept(value);
        return this;
    }

    protected void updateTextFieldRange() {
        this.setTextFieldRange(this.textField, this.min, this.max);
        this.setValue(this.clamp((Number)this.valueSupplier.get(), this.min, this.max));
    }

    @Generated
    public Supplier<T> getValueSupplier() {
        return this.valueSupplier;
    }

    @Generated
    public T getMin() {
        return this.min;
    }

    @Generated
    public T getMax() {
        return this.max;
    }

    protected record ChangeValues<T extends Number>(T regular, T shift, T ctrl, T ctrlShift) {
    }
}

