/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemStackList;
import com.gregtechceu.gtceu.integration.xei.entry.item.ItemTagList;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemEntryHandler;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemStackHandler;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="gtm_item_slot", group="widget.gtm_container", priority=50)
public class SlotWidget
extends com.lowdragmc.lowdraglib.gui.widget.SlotWidget {
    public SlotWidget() {
    }

    public SlotWidget(Container inventory, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(inventory, slotIndex, xPosition, yPosition, canTakeItems, canPutItems);
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        this.setSelfPosition(xPosition, yPosition);
        this.setSize(18, 18);
        this.recomputePosition();
        this.setVisible(true);
        this.setActive(true);
        this.drawHoverOverlay = true;
        this.drawHoverTips = true;
        this.ingredientIO = IngredientIO.RENDER_ONLY;
        this.XEIChance = 1.0f;
        this.setBackgroundTexture((IGuiTexture)ITEM_SLOT_TEXTURE);
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.setHandlerSlot(itemHandler, slotIndex);
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        this(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget(Container container, int slotIndex, int xPosition, int yPosition) {
        this(container, slotIndex, xPosition, yPosition, true, true);
    }

    protected Slot createSlot(IItemHandlerModifiable itemHandler, int index) {
        return new WidgetSlotItemHandler(itemHandler, index, 0, 0);
    }

    public SlotWidget setContainerSlot(Container inventory, int slotIndex) {
        super.setContainerSlot(inventory, slotIndex);
        return this;
    }

    public void updateSlot(Slot slot) {
        super.updateSlot(slot);
    }

    public SlotWidget setHandlerSlot(IItemTransfer itemHandler, int slotIndex) {
        super.setHandlerSlot(itemHandler, slotIndex);
        return this;
    }

    public SlotWidget setHandlerSlot(IItemHandlerModifiable itemHandler, int slotIndex) {
        this.updateSlot(this.createSlot(itemHandler, slotIndex));
        return this;
    }

    public SlotWidget setBackgroundTexture(IGuiTexture backgroundTexture) {
        super.setBackgroundTexture(backgroundTexture);
        return this;
    }

    public SlotWidget setLocationInfo(boolean isPlayerContainer, boolean isPlayerHotBar) {
        super.setLocationInfo(isPlayerContainer, isPlayerHotBar);
        return this;
    }

    public SlotWidget setCanTakeItems(boolean canTakeItems) {
        super.setCanTakeItems(canTakeItems);
        return this;
    }

    public SlotWidget setCanPutItems(boolean canPutItems) {
        super.setCanPutItems(canPutItems);
        return this;
    }

    public SlotWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        super.setDrawHoverOverlay(drawHoverOverlay);
        return this;
    }

    public SlotWidget setDrawHoverTips(boolean drawHoverTips) {
        super.setDrawHoverTips(drawHoverTips);
        return this;
    }

    public SlotWidget setIngredientIO(IngredientIO ingredientIO) {
        super.setIngredientIO(ingredientIO);
        return this;
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        super.setChangeListener(changeListener);
        return this;
    }

    public SlotWidget setXEIChance(float XEIChance) {
        super.setXEIChance(XEIChance);
        return this;
    }

    public SlotWidget setItemHook(Function<ItemStack, ItemStack> itemHook) {
        super.setItemHook(itemHook);
        return this;
    }

    public SlotWidget setOnAddedTooltips(BiConsumer<com.lowdragmc.lowdraglib.gui.widget.SlotWidget, List<Component>> onAddedTooltips) {
        super.setOnAddedTooltips(onAddedTooltips);
        return this;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        ItemStackHandler handler = new ItemStackHandler();
        handler.setStackInSlot(0, Blocks.STONE.asItem().getDefaultInstance());
        father.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", (Widget)new SlotWidget(){

            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(SlotWidget.this.tooltipTexts);
                this.backgroundTexture = SlotWidget.this.backgroundTexture;
                this.hoverTexture = SlotWidget.this.hoverTexture;
                this.drawHoverOverlay = SlotWidget.this.drawHoverOverlay;
                this.drawHoverTips = SlotWidget.this.drawHoverTips;
                this.overlay = SlotWidget.this.overlay;
            }
        }.setCanPutItems(false).setCanTakeItems(false).setHandlerSlot((IItemHandlerModifiable)handler, 0))});
        ConfiguratorParser.createConfigurators((ConfiguratorGroup)father, new HashMap(), ((Object)((Object)this)).getClass(), (Object)((Object)this));
    }

    @Nullable
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (this.self().isMouseOverElement(mouseX, mouseY)) {
            Slot handler = this.getHandler();
            if (handler == null) {
                return null;
            }
            ItemStack realStack = this.getRealStack(handler.getItem());
            if (handler instanceof WidgetSlotItemHandler) {
                WidgetSlotItemHandler slotHandler = (WidgetSlotItemHandler)handler;
                IItemHandlerModifiable iItemHandlerModifiable = slotHandler.itemHandler;
                if (iItemHandlerModifiable instanceof CycleItemStackHandler) {
                    CycleItemStackHandler stackHandler = (CycleItemStackHandler)iItemHandlerModifiable;
                    return this.getXEIIngredientsClickable(stackHandler, slotHandler.index);
                }
                iItemHandlerModifiable = slotHandler.itemHandler;
                if (iItemHandlerModifiable instanceof CycleItemEntryHandler) {
                    CycleItemEntryHandler entryHandler = (CycleItemEntryHandler)iItemHandlerModifiable;
                    return this.getXEIIngredientsClickable(entryHandler, slotHandler.index);
                }
            }
            if (GTCEu.Mods.isJEILoaded() && !realStack.isEmpty()) {
                return JEICallWrapper.getJEIStackClickable(realStack, this.getPosition(), this.getSize());
            }
            if (GTCEu.Mods.isREILoaded()) {
                return EntryStacks.of((ItemStack)realStack);
            }
            if (GTCEu.Mods.isEMILoaded()) {
                return EmiStack.of((ItemStack)realStack).setChance(this.getXEIChance());
            }
            return realStack;
        }
        return null;
    }

    public List<Object> getXEIIngredients() {
        if (this.slotReference == null || this.slotReference.getItem().isEmpty()) {
            return Collections.emptyList();
        }
        Slot handler = this.getHandler();
        if (handler == null) {
            return Collections.emptyList();
        }
        ItemStack realStack = this.getRealStack(handler.getItem());
        if (handler instanceof WidgetSlotItemHandler) {
            WidgetSlotItemHandler slotHandler = (WidgetSlotItemHandler)handler;
            IItemHandlerModifiable iItemHandlerModifiable = slotHandler.itemHandler;
            if (iItemHandlerModifiable instanceof CycleItemStackHandler) {
                CycleItemStackHandler stackHandler = (CycleItemStackHandler)iItemHandlerModifiable;
                return this.getXEIIngredientsClickable(stackHandler, slotHandler.index);
            }
            iItemHandlerModifiable = slotHandler.itemHandler;
            if (iItemHandlerModifiable instanceof CycleItemEntryHandler) {
                CycleItemEntryHandler entryHandler = (CycleItemEntryHandler)iItemHandlerModifiable;
                return this.getXEIIngredientsClickable(entryHandler, slotHandler.index);
            }
        }
        if (GTCEu.Mods.isJEILoaded() && !realStack.isEmpty()) {
            return List.of(JEICallWrapper.getJEIStackClickable(realStack, this.getPosition(), this.getSize()));
        }
        if (GTCEu.Mods.isREILoaded()) {
            return List.of(EntryStacks.of((ItemStack)realStack));
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return List.of(EmiStack.of((ItemStack)realStack).setChance(this.getXEIChance()));
        }
        return List.of(realStack);
    }

    private List<Object> getXEIIngredients(CycleItemStackHandler handler, int index) {
        ItemStackList stackList = handler.getStackList(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredients(stackList, arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(stackList, arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(stackList, this.getXEIChance(), arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsClickable(CycleItemStackHandler handler, int index) {
        ItemStackList stackList = handler.getStackList(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredientsClickable(stackList, this.getPosition(), this.getSize(), arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(stackList, arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(stackList, this.getXEIChance(), arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredients(CycleItemEntryHandler handler, int index) {
        ItemEntryList entryList = handler.getEntry(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredients(entryList, arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(entryList, arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(entryList, this.getXEIChance(), arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsClickable(CycleItemEntryHandler handler, int index) {
        ItemEntryList entryList = handler.getEntry(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredientsClickable(entryList, this.getPosition(), this.getSize(), arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(entryList, arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(entryList, this.getXEIChance(), arg_0 -> ((SlotWidget)this).getRealStack(arg_0));
        }
        return Collections.emptyList();
    }

    public class WidgetSlotItemHandler
    extends Slot {
        private static final Container emptyInventory = new SimpleContainer(0);
        private final IItemHandlerModifiable itemHandler;
        private final int index;

        public WidgetSlotItemHandler(IItemHandlerModifiable itemHandler, int index, int xPosition, int yPosition) {
            super(emptyInventory, index, xPosition, yPosition);
            this.itemHandler = itemHandler;
            this.index = index;
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && !stack.isEmpty() && this.itemHandler.isItemValid(this.index, stack);
        }

        public boolean mayPickup(@Nullable Player playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && !this.itemHandler.extractItem(this.index, 1, true).isEmpty();
        }

        @NotNull
        public ItemStack getItem() {
            return this.itemHandler.getStackInSlot(this.index);
        }

        public void setByPlayer(@NotNull ItemStack stack) {
            this.itemHandler.setStackInSlot(this.index, stack);
        }

        public void set(@NotNull ItemStack stack) {
            this.itemHandler.setStackInSlot(this.index, stack);
            this.setChanged();
        }

        public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
        }

        public int getMaxStackSize() {
            return this.itemHandler.getSlotLimit(this.index);
        }

        public int getMaxStackSize(@NotNull ItemStack stack) {
            ItemStack maxAdd = stack.copy();
            int maxInput = stack.getMaxStackSize();
            maxAdd.setCount(maxInput);
            ItemStack currentStack = this.itemHandler.getStackInSlot(this.index);
            this.itemHandler.setStackInSlot(this.index, ItemStack.EMPTY);
            ItemStack remainder = this.itemHandler.insertItem(this.index, maxAdd, true);
            this.itemHandler.setStackInSlot(this.index, currentStack);
            return maxInput - remainder.getCount();
        }

        @NotNull
        public ItemStack remove(int amount) {
            ItemStack result = this.itemHandler.extractItem(this.index, amount, false);
            if (SlotWidget.this.changeListener != null && !this.getItem().isEmpty()) {
                SlotWidget.this.changeListener.run();
            }
            return result;
        }

        public void setChanged() {
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
            SlotWidget.this.onSlotChanged();
        }

        public boolean isActive() {
            return SlotWidget.this.isEnabled() && (HOVER_SLOT == null || HOVER_SLOT == this);
        }

        @Generated
        public IItemHandlerModifiable getItemHandler() {
            return this.itemHandler;
        }
    }

    public static final class JEICallWrapper {
        public static Object getJEIStackClickable(ItemStack stack, Position pos, Size size) {
            return JEIPlugin.getItemIngredient((ItemStack)stack, (int)pos.x, (int)pos.y, (int)size.width, (int)size.height);
        }

        public static List<Object> getJEIIngredients(ItemEntryList list, UnaryOperator<ItemStack> realStack) {
            return list.getStacks().stream().filter(stack -> !stack.isEmpty()).map(realStack).collect(Collectors.toList());
        }

        public static List<Object> getJEIIngredientsClickable(ItemEntryList list, Position pos, Size size, UnaryOperator<ItemStack> realStack) {
            return list.getStacks().stream().filter(stack -> !stack.isEmpty()).map(realStack).map(stack -> JEICallWrapper.getJEIStackClickable(stack, pos, size)).collect(Collectors.toList());
        }
    }

    public static final class REICallWrapper {
        private static EntryIngredient toREIIngredient(Stream<ItemStack> stream, UnaryOperator<ItemStack> realStack) {
            return EntryIngredient.of(stream.map(realStack).map(EntryStacks::of).toList());
        }

        public static List<Object> getREIIngredients(ItemStackList list, UnaryOperator<ItemStack> realStack) {
            return List.of(REICallWrapper.toREIIngredient(list.stream(), realStack));
        }

        public static List<Object> getREIIngredients(ItemTagList list, UnaryOperator<ItemStack> realStack) {
            return list.getEntries().stream().map(ItemTagList.ItemTagEntry::stacks).map(stream -> REICallWrapper.toREIIngredient(stream, realStack)).collect(Collectors.toList());
        }

        public static List<Object> getREIIngredients(ItemEntryList list, UnaryOperator<ItemStack> realStack) {
            if (list instanceof ItemTagList) {
                ItemTagList tagList = (ItemTagList)list;
                return REICallWrapper.getREIIngredients(tagList, realStack);
            }
            if (list instanceof ItemStackList) {
                ItemStackList stackList = (ItemStackList)list;
                return REICallWrapper.getREIIngredients(stackList, realStack);
            }
            return Collections.emptyList();
        }
    }

    public static final class EMICallWrapper {
        private static EmiIngredient toEMIIngredient(Stream<ItemStack> stream, UnaryOperator<ItemStack> realStack) {
            return EmiIngredient.of(stream.map(realStack).map(EmiStack::of).toList());
        }

        public static List<Object> getEMIIngredients(ItemStackList list, float xeiChance, UnaryOperator<ItemStack> realStack) {
            return List.of(EMICallWrapper.toEMIIngredient(list.stream(), realStack).setChance(xeiChance));
        }

        public static List<Object> getEMIIngredients(ItemTagList list, float xeiChance, UnaryOperator<ItemStack> realStack) {
            return list.getEntries().stream().map(ItemTagList.ItemTagEntry::stacks).map(stream -> EMICallWrapper.toEMIIngredient(stream, realStack).setChance(xeiChance)).collect(Collectors.toList());
        }

        public static List<Object> getEMIIngredients(ItemEntryList list, float xeiChance, UnaryOperator<ItemStack> realStack) {
            if (list instanceof ItemTagList) {
                ItemTagList tagList = (ItemTagList)list;
                return EMICallWrapper.getEMIIngredients(tagList, xeiChance, realStack);
            }
            if (list instanceof ItemStackList) {
                ItemStackList stackList = (ItemStackList)list;
                return EMICallWrapper.getEMIIngredients(stackList, xeiChance, realStack);
            }
            return Collections.emptyList();
        }
    }
}

