/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget.directional.handlers;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.widget.CoverConfigurator;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedButtonWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.directional.IDirectionalConfigHandler;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CoverableConfigHandler
implements IDirectionalConfigHandler {
    private static final IGuiTexture CONFIG_BTN_TEXTURE = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.IO_CONFIG_COVER_SETTINGS});
    private final ICoverable machine;
    private CustomItemStackHandler handler;
    private Direction side;
    private ConfiguratorPanel panel;
    private ConfiguratorPanel.FloatingTab coverConfigurator;
    private SlotWidget slotWidget;
    private CoverBehavior coverBehavior;

    public CoverableConfigHandler(ICoverable machine) {
        this.machine = machine;
        this.handler = this.createItemStackHandler();
    }

    private CustomItemStackHandler createItemStackHandler() {
        CustomItemStackHandler handler = new CustomItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        handler.setFilter(itemStack -> {
            if (itemStack.isEmpty()) {
                return true;
            }
            if (this.side == null) {
                return false;
            }
            return CoverPlaceBehavior.isCoverBehaviorItem(itemStack, () -> false, coverDef -> ICoverable.canPlaceCover(coverDef, this.machine));
        });
        return handler;
    }

    @Override
    public Widget getSideSelectorWidget(SceneWidget scene, FancyMachineUIWidget machineUI) {
        WidgetGroup group = new WidgetGroup(0, 0, 37, 18);
        this.panel = machineUI.getConfiguratorPanel();
        this.slotWidget = new SlotWidget((IItemHandlerModifiable)this.handler, 0, 19, 0){

            public boolean canPutStack(ItemStack stack) {
                return super.canPutStack(stack) && CoverPlaceBehavior.isCoverBehaviorItem(stack, () -> false, def -> def.createCoverBehavior(CoverableConfigHandler.this.machine, CoverableConfigHandler.this.side).canAttach());
            }
        }.setChangeListener(this::coverItemChanged).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.IO_CONFIG_COVER_SLOT_OVERLAY}));
        group.addWidget((Widget)this.slotWidget);
        group.addWidget((Widget)new PredicatedButtonWidget(0, 0, 18, 18, CONFIG_BTN_TEXTURE, this::toggleConfigTab, () -> this.side != null && this.coverBehavior != null && this.machine.getCoverAtSide(this.side) instanceof IUICover));
        this.checkCoverBehaviour();
        return group;
    }

    private void coverItemChanged() {
        Object object;
        ServerPlayer serverPlayer;
        block7: {
            block6: {
                this.closeConfigTab();
                Player player = this.panel.getGui().entityPlayer;
                if (!(player instanceof ServerPlayer)) break block6;
                serverPlayer = (ServerPlayer)player;
                if (this.side != null) break block7;
            }
            return;
        }
        ItemStack item = this.handler.getStackInSlot(0);
        if (this.machine.getCoverAtSide(this.side) != null) {
            this.machine.removeCover(false, this.side, (Player)serverPlayer);
        }
        if (!item.isEmpty() && this.machine.getCoverAtSide(this.side) == null && (object = item.getItem()) instanceof IComponentItem) {
            IComponentItem componentItem = (IComponentItem)object;
            for (IItemComponent component : componentItem.getComponents()) {
                if (!(component instanceof CoverPlaceBehavior)) continue;
                CoverPlaceBehavior placeBehavior = (CoverPlaceBehavior)component;
                this.machine.placeCoverOnSide(this.side, item, placeBehavior.coverDefinition(), serverPlayer);
                break;
            }
        }
        this.checkCoverBehaviour();
    }

    @Override
    public void onSideSelected(BlockPos pos, Direction side) {
        this.side = side;
        this.checkCoverBehaviour();
        this.closeConfigTab();
    }

    private void updateWidgetVisibility() {
        boolean sideSelected = this.side != null;
        this.slotWidget.setVisible(sideSelected);
        this.slotWidget.setActive(sideSelected);
    }

    public void checkCoverBehaviour() {
        if (this.side == null) {
            return;
        }
        CoverBehavior coverBehaviour = this.machine.getCoverAtSide(this.side);
        if (coverBehaviour != this.coverBehavior) {
            this.coverBehavior = coverBehaviour;
            ItemStack attachItem = coverBehaviour == null ? ItemStack.EMPTY : coverBehaviour.getAttachItem();
            this.handler.setStackInSlot(0, attachItem);
            this.handler.onContentsChanged(0);
        }
        this.updateWidgetVisibility();
    }

    private void toggleConfigTab(ClickData cd) {
        if (this.coverConfigurator == null) {
            this.openConfigTab();
        } else {
            this.closeConfigTab();
        }
    }

    private void openConfigTab() {
        CoverConfigurator configurator = new CoverConfigurator(this.machine, this.side, this.coverBehavior){

            @Override
            public Component getTitle() {
                return Component.empty();
            }

            @Override
            public IGuiTexture getIcon() {
                return GuiTextures.CLOSE_ICON;
            }

            @Override
            public Widget createConfigurator() {
                CoverBehavior coverBehavior;
                WidgetGroup group = new WidgetGroup(new Position(0, 0));
                if (this.side == null || !((coverBehavior = this.coverable.getCoverAtSide(this.side)) instanceof IUICover)) {
                    return group;
                }
                IUICover iuiCover = (IUICover)((Object)coverBehavior);
                Widget coverConfigurator = iuiCover.createUIWidget();
                coverConfigurator.addSelfPosition(-1, -20);
                group.addWidget(coverConfigurator);
                group.setSize(new Size(Math.max(120, coverConfigurator.getSize().width), Math.max(80, coverConfigurator.getSize().height - 20)));
                return group;
            }
        };
        this.coverConfigurator = this.panel.createFloatingTab(configurator);
        this.coverConfigurator.setGui(this.panel.getGui());
        this.panel.addWidget((Widget)this.coverConfigurator);
        this.panel.expandTab(this.coverConfigurator);
        this.coverConfigurator.onClose(() -> {
            if (this.coverConfigurator != null) {
                this.panel.removeWidget((Widget)this.coverConfigurator);
            }
            this.coverConfigurator = null;
        });
    }

    private void closeConfigTab() {
        if (this.coverConfigurator != null) {
            this.panel.collapseTab();
        }
    }

    @Override
    public IDirectionalConfigHandler.ScreenSide getScreenSide() {
        return IDirectionalConfigHandler.ScreenSide.RIGHT;
    }
}

