/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.NotNull;

public class GTBucketItem
extends BucketItem {
    final Material material;
    final String langKey;

    public GTBucketItem(Supplier<? extends Fluid> fluid, Item.Properties properties, Material material, String langKey) {
        super(fluid, properties);
        this.material = material;
        this.langKey = langKey;
    }

    public static int color(ItemStack itemStack, int index) {
        Item item = itemStack.getItem();
        if (item instanceof GTBucketItem) {
            GTBucketItem item2 = (GTBucketItem)item;
            if (index == 1) {
                return IClientFluidTypeExtensions.of((Fluid)item2.getFluid()).getTintColor();
            }
        }
        return -1;
    }

    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable CompoundTag nbt) {
        return ((Object)((Object)this)).getClass() == GTBucketItem.class ? new FluidBucketWrapper(stack) : super.initCapabilities(stack, nbt);
    }

    public String getDescriptionId() {
        return "item.gtceu.bucket";
    }

    public Component getDescription() {
        MutableComponent materialName = this.material.getLocalizedName();
        return Component.translatable((String)"item.gtceu.bucket", (Object[])new Object[]{Component.translatable((String)this.langKey, (Object[])new Object[]{materialName})});
    }

    public Component getName(ItemStack stack) {
        return this.getDescription();
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        Fluid fluid;
        FluidProperty property = this.material.getProperty(PropertyKey.FLUID);
        if (property != null && (fluid = this.material.getFluid()) instanceof GTFluid) {
            GTFluid gtFluid = (GTFluid)fluid;
            return gtFluid.getBurnTime();
        }
        return -1;
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result, @Nullable ItemStack container) {
        LiquidBlockContainer blockContainer;
        LiquidBlockContainer lbc;
        boolean canPlace;
        if (!(this.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = level.getBlockState(pos);
        Block block = blockstate.getBlock();
        boolean canReplace = blockstate.canBeReplaced(this.getFluid());
        boolean bl = canPlace = blockstate.isAir() || canReplace || block instanceof LiquidBlockContainer && (lbc = (LiquidBlockContainer)block).canPlaceLiquid((BlockGetter)level, pos, blockstate, this.getFluid());
        if (!canPlace) {
            return result != null && this.emptyContents(player, level, result.getBlockPos().relative(result.getDirection()), null, container);
        }
        FluidType fluidType = this.getFluid().getFluidType();
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (containedFluidStack.isPresent() && fluidType.isVaporizedOnPlacement(level, pos, (FluidStack)containedFluidStack.get())) {
            fluidType.onVaporize(player, level, pos, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (this.doesFluidVaporize(this.material, level)) {
            int i = pos.getX();
            int j = pos.getY();
            int k = pos.getZ();
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                double xi = (double)i + GTValues.RNG.nextDouble();
                double xj = (double)j + GTValues.RNG.nextDouble();
                double xk = (double)k + GTValues.RNG.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, xi, xj, xk, 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && (blockContainer = (LiquidBlockContainer)block).canPlaceLiquid((BlockGetter)level, pos, blockstate, this.getFluid())) {
            FlowingFluid flowingFluid = (FlowingFluid)this.getFluid();
            blockContainer.placeLiquid((LevelAccessor)level, pos, blockstate, flowingFluid.getSource(false));
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.isClientSide && canReplace && !blockstate.liquid()) {
            level.destroyBlock(pos, true);
        }
        BlockState fluidBlockState = this.material.getFluid().defaultFluidState().createLegacyBlock();
        if (GTBucketItem.hasFluidBlock(this.material) && level.setBlock(pos, fluidBlockState, 11) && fluidBlockState.getFluidState().isSource()) {
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        return false;
    }

    private static boolean hasFluidBlock(Material mat) {
        FluidStorage fluidStorage = mat.getProperty(PropertyKey.FLUID).getStorage();
        for (FluidStorageKey key : FluidStorageKey.allKeys()) {
            FluidBuilder fluidBuilder;
            FluidStorage.FluidEntry fluidEntry = fluidStorage.getEntry(key);
            if (fluidEntry == null || (fluidBuilder = fluidEntry.getBuilder()) == null || !fluidBuilder.hasFluidBlock()) continue;
            return true;
        }
        return false;
    }

    private boolean doesFluidVaporize(Material mat, Level level) {
        if (level.dimensionType().ultraWarm() && this.getFluid().defaultFluidState().is(FluidTags.WATER)) {
            return true;
        }
        FluidStorage fluidStorage = mat.getProperty(PropertyKey.FLUID).getStorage();
        FluidStorage.FluidEntry plasmaEntry = fluidStorage.getEntry(FluidStorageKeys.PLASMA);
        FluidStorage.FluidEntry gasEntry = fluidStorage.getEntry(FluidStorageKeys.GAS);
        if (plasmaEntry != null) {
            FluidBuilder plasmaBuilder = plasmaEntry.getBuilder();
            return plasmaBuilder != null && plasmaBuilder.hasFluidBlock();
        }
        if (gasEntry != null) {
            FluidBuilder gasBuilder = gasEntry.getBuilder();
            return gasBuilder != null && gasBuilder.hasFluidBlock();
        }
        return false;
    }
}

