/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.api.capability.CombinedCapabilityProvider;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.component.ElectricStats;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.TreeFellingHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolUIBehavior;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGTTool
extends HeldItemUIFactory.IHeldItemUIHolder,
ItemLike,
IForgeItem {
    public static final ResourceLocation COFH_SMASHING_ENCHANT_ID = new ResourceLocation("ensorcellation", "smashing");
    public static final Set<ResourceLocation> AUTOSMELT_ENCHANT_IDS = (Set)Util.make(new HashSet(), set -> {
        set.add(new ResourceLocation("enderio", "auto_smelt"));
        set.add(new ResourceLocation("ensorcellation", "smelting"));
    });

    public GTToolType getToolType();

    public Material getMaterial();

    public boolean isElectric();

    public int getElectricTier();

    public IGTToolDefinition getToolStats();

    @Nullable
    public SoundEntry getSound();

    public boolean playSoundOnBlockDestroy();

    default public Item asItem() {
        return (Item)this;
    }

    default public ItemStack getRaw() {
        ItemStack stack = new ItemStack((ItemLike)this.asItem());
        ToolHelper.getBehaviorsTag(stack);
        return stack;
    }

    default public ItemStack get() {
        ItemStack stack = new ItemStack((ItemLike)this.asItem());
        CompoundTag stackCompound = stack.getOrCreateTag();
        stackCompound.putBoolean("DisallowContainerItem", false);
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        IGTToolDefinition toolStats = this.getToolStats();
        stackCompound.putInt("HideFlags", 2);
        AoESymmetrical aoeDefinition = this.getToolStats().getAoEDefinition(stack);
        ToolProperty toolProperty = this.getMaterial().getProperty(PropertyKey.TOOL);
        int durability = toolProperty.getDurability() * toolProperty.getDurabilityMultiplier();
        durability = toolStats.getBaseDurability(stack) == 0 ? (int)((float)durability * toolStats.getDurabilityMultiplier(stack)) : (int)((float)durability + (float)toolStats.getBaseDurability(stack) * toolStats.getDurabilityMultiplier(stack));
        toolTag.putInt("MaxDamage", durability - 1);
        if (toolProperty.isUnbreakable()) {
            stackCompound.putBoolean("Unbreakable", true);
        }
        CompoundTag behaviourTag = ToolHelper.getBehaviorsTag(stack);
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.addBehaviorNBT(stack, behaviourTag));
        if (!aoeDefinition.isZero()) {
            behaviourTag.putInt("MaxAoEColumn", aoeDefinition.column);
            behaviourTag.putInt("MaxAoERow", aoeDefinition.row);
            behaviourTag.putInt("MaxAoELayer", aoeDefinition.layer);
            behaviourTag.putInt("AoEColumn", aoeDefinition.column);
            behaviourTag.putInt("AoERow", aoeDefinition.row);
            behaviourTag.putInt("AoELayer", aoeDefinition.layer);
        }
        if (toolProperty.isMagnetic()) {
            behaviourTag.putBoolean("RelocateMinedBlocks", true);
            behaviourTag.putBoolean("RelocateMobDrops", true);
        }
        return stack;
    }

    default public ItemStack get(long defaultCharge, long defaultMaxCharge) {
        ElectricItem electricItem;
        ItemStack stack = this.get();
        if (this.isElectric() && (electricItem = (ElectricItem)GTCapabilityHelper.getElectricItem(stack)) != null) {
            electricItem.setMaxChargeOverride(defaultMaxCharge);
            electricItem.setCharge(defaultCharge);
        }
        return stack;
    }

    default public ItemStack get(long defaultMaxCharge) {
        return this.get(defaultMaxCharge, defaultMaxCharge);
    }

    @Nullable
    default public ToolProperty getToolProperty() {
        return this.getMaterial().getProperty(PropertyKey.TOOL);
    }

    default public float getMaterialToolSpeed() {
        ToolProperty toolProperty = this.getToolProperty();
        return toolProperty == null ? 0.0f : toolProperty.getHarvestSpeed();
    }

    default public float getMaterialAttackDamage() {
        ToolProperty toolProperty = this.getToolProperty();
        return toolProperty == null ? 0.0f : toolProperty.getAttackDamage();
    }

    default public float getMaterialAttackSpeed() {
        ToolProperty toolProperty = this.getToolProperty();
        return toolProperty == null ? 0.0f : toolProperty.getAttackSpeed();
    }

    default public int getMaterialDurability() {
        ToolProperty toolProperty = this.getToolProperty();
        return toolProperty == null ? 0 : toolProperty.getDurability() * toolProperty.getDurabilityMultiplier();
    }

    default public int getMaterialEnchantability() {
        ToolProperty toolProperty = this.getToolProperty();
        return toolProperty == null ? 0 : toolProperty.getEnchantability();
    }

    default public int getMaterialHarvestLevel() {
        ToolProperty toolProperty = this.getToolProperty();
        return toolProperty == null ? 0 : toolProperty.getHarvestLevel();
    }

    default public int getProspectingDepth() {
        ToolProperty toolProperty = this.getToolProperty();
        return toolProperty == null ? 1 : toolProperty.getProspectingDepth();
    }

    default public long getMaxCharge(ItemStack stack) {
        CompoundTag tag;
        if (this.isElectric() && (tag = stack.getTag()) != null && tag.contains("MaxCharge", 4)) {
            return tag.getLong("MaxCharge");
        }
        return -1L;
    }

    default public long getCharge(ItemStack stack) {
        CompoundTag tag;
        if (this.isElectric() && (tag = stack.getTag()) != null && tag.contains("Charge", 4)) {
            return tag.getLong("Charge");
        }
        return -1L;
    }

    default public float getTotalToolSpeed(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("ToolSpeed", 5)) {
            return toolTag.getFloat("ToolSpeed");
        }
        float toolSpeed = this.getToolStats().getEfficiencyMultiplier(stack) * this.getMaterialToolSpeed() + this.getToolStats().getBaseEfficiency(stack);
        toolTag.putFloat("ToolSpeed", toolSpeed);
        return toolSpeed;
    }

    default public float getTotalAttackDamage(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("AttackDamage", 5)) {
            return toolTag.getFloat("AttackDamage");
        }
        float baseDamage = this.getToolStats().getBaseDamage(stack);
        float attackDamage = 0.0f;
        if (baseDamage != Float.MIN_VALUE) {
            attackDamage = this.getMaterialAttackDamage() + baseDamage;
        }
        toolTag.putFloat("AttackDamage", attackDamage);
        return attackDamage;
    }

    default public float getTotalAttackSpeed(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("AttackSpeed", 5)) {
            return toolTag.getFloat("AttackSpeed");
        }
        float attackSpeed = this.getMaterialAttackSpeed() + this.getToolStats().getAttackSpeed(stack);
        toolTag.putFloat("AttackSpeed", attackSpeed);
        return attackSpeed;
    }

    default public int getTotalMaxDurability(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("MaxDamage", 3)) {
            return toolTag.getInt("MaxDamage");
        }
        IGTToolDefinition toolStats = this.getToolStats();
        int maxDurability = this.getMaterialDurability();
        int builderDurability = (int)((float)toolStats.getBaseDurability(stack) * toolStats.getDurabilityMultiplier(stack));
        maxDurability = builderDurability == 0 ? (int)((float)maxDurability * toolStats.getDurabilityMultiplier(stack)) : maxDurability + builderDurability;
        toolTag.putInt("MaxDamage", maxDurability);
        return maxDurability;
    }

    default public int getTotalEnchantability(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("Enchantability", 3)) {
            return toolTag.getInt("Enchantability");
        }
        int enchantability = this.getMaterialEnchantability();
        toolTag.putInt("Enchantability", enchantability);
        return enchantability;
    }

    default public int getTotalHarvestLevel(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("HarvestLevel", 3)) {
            return toolTag.getInt("HarvestLevel");
        }
        int harvestLevel = this.getMaterialHarvestLevel() + this.getToolStats().getBaseQuality(stack);
        toolTag.putInt("HarvestLevel", harvestLevel);
        return harvestLevel;
    }

    default public float definition$getDestroySpeed(ItemStack stack, BlockState state) {
        float specialValue = ToolHelper.getDestroySpeed(state, this.getToolClasses(stack));
        if (specialValue != -1.0f) {
            return specialValue;
        }
        if (ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
            return this.getTotalToolSpeed(stack);
        }
        return this.getToolStats().isToolEffective(state) ? this.getTotalToolSpeed(stack) : 1.0f;
    }

    default public boolean definition$hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.hitEntity(stack, target, attacker));
        ToolHelper.damageItem(stack, attacker, this.getToolStats().getToolDamagePerAttack(stack));
        return true;
    }

    default public boolean definition$onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.level().isClientSide) {
            return false;
        }
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockStartBreak(stack, pos, player));
        if (!player.isShiftKeyDown()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int result = -1;
            if (ToolHelper.isTool(stack, GTToolType.SHEARS)) {
                result = ToolHelper.shearBlockRoutine(serverPlayer, stack, pos);
            }
            if (result != 0) {
                BlockState state = player.level().getBlockState(pos);
                boolean effective = false;
                for (GTToolType type : this.getToolClasses(stack)) {
                    if (!type.harvestTags.stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) continue;
                    effective = true;
                    break;
                }
                if (effective |= ToolHelper.isToolEffective(state, this.getToolClasses(stack), this.getTotalHarvestLevel(stack))) {
                    if (ToolHelper.areaOfEffectBlockBreakRoutine(stack, serverPlayer, pos)) {
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else if (result == -1) {
                        CompoundTag tag = ToolHelper.getBehaviorsTag(stack);
                        if (tag.getBoolean("TreeFelling") && !tag.getBoolean("DisableTreeFelling") && state.is(BlockTags.LOGS)) {
                            TreeFellingHelper.fellTree(stack, player.level(), state, pos, (LivingEntity)player);
                        }
                        if (this.playSoundOnBlockDestroy()) {
                            this.playSound(player);
                        }
                    } else {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    default public boolean definition$mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.isClientSide) {
            this.getToolStats().getBehaviors().forEach(behavior -> behavior.onBlockDestroyed(stack, worldIn, state, pos, entityLiving));
            if ((double)state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0) {
                ToolHelper.damageItem(stack, entityLiving, this.getToolStats().getToolDamagePerBlockBreak(stack));
            }
            if (entityLiving instanceof Player && this.playSoundOnBlockDestroy() && entityLiving.isShiftKeyDown()) {
                this.playSound((Player)entityLiving);
            }
        }
        return true;
    }

    default public boolean definition$isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        if (toRepair.getDamageValue() == 0) {
            return false;
        }
        Item item = repair.getItem();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            return this.getMaterial() == gtTool.getMaterial();
        }
        MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)repair.getItem());
        if (entry.isEmpty()) {
            return false;
        }
        if (entry.material() == this.getMaterial()) {
            if (VanillaRecipeHelper.isMaterialWood(entry.material())) {
                return entry.tagPrefix() == TagPrefix.planks;
            }
            if (entry.tagPrefix() == TagPrefix.plate) {
                return true;
            }
            if (entry.material().hasProperty(PropertyKey.INGOT)) {
                return entry.tagPrefix() == TagPrefix.ingot;
            }
            if (entry.material().hasProperty(PropertyKey.GEM)) {
                return entry.tagPrefix() == TagPrefix.gem;
            }
        }
        return false;
    }

    default public Map<Enchantment, Integer> definition$getAllEnchantments(ItemStack stack) {
        Map<Enchantment, Integer> defaultEnchantments = this.getDefaultEnchantments(stack);
        if (defaultEnchantments.isEmpty()) {
            return EnchantmentHelper.getEnchantments((ItemStack)stack);
        }
        return ToolHelper.joinEnchantments(stack, defaultEnchantments);
    }

    default public Map<Enchantment, Integer> getDefaultEnchantments(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("DefaultEnchantments", 9)) {
            ListTag defaultsTag = toolTag.getList("DefaultEnchantments", 10);
            return EnchantmentHelper.deserializeEnchantments((ListTag)defaultsTag);
        }
        Object2IntLinkedOpenHashMap defaultEnchantments = new Object2IntLinkedOpenHashMap();
        defaultEnchantments.putAll(this.getToolStats().getDefaultEnchantments(stack));
        defaultEnchantments.putAll(this.getMaterial().getProperty(PropertyKey.TOOL).getEnchantments());
        ListTag enchantList = new ListTag();
        for (Object2IntMap.Entry entry : defaultEnchantments.object2IntEntrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment == null || !this.definition$canApplyAtEnchantingTable(stack, enchantment)) continue;
            int level = entry.getIntValue();
            enchantList.add((Object)EnchantmentHelper.storeEnchantment((ResourceLocation)EnchantmentHelper.getEnchantmentId((Enchantment)enchantment), (int)level));
        }
        toolTag.put("DefaultEnchantments", (Tag)enchantList);
        return defaultEnchantments;
    }

    default public int definition$getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return this.definition$getAllEnchantments(stack).getOrDefault(enchantment, 0);
    }

    default public boolean definition$isFoil(ItemStack stack) {
        return !this.getAllEnchantments(stack).isEmpty();
    }

    default public Multimap<Attribute, AttributeModifier> definition$getDefaultAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(Item.BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)this.getTotalAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(Item.BASE_ATTACK_SPEED_UUID, "Weapon modifier", Math.max(-3.9, (double)this.getTotalAttackSpeed(stack)), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    default public int definition$getHarvestLevel(ItemStack stack, GTToolType toolClass, @Nullable Player player, @Nullable BlockState blockState) {
        return this.getToolClasses(stack).contains(toolClass) ? this.getTotalHarvestLevel(stack) : -1;
    }

    default public boolean definition$canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.getToolStats().getBehaviors().stream().anyMatch(behavior -> behavior.canDisableShield(stack, shield, entity, attacker));
    }

    default public boolean definition$doesSneakBypassUse(@NotNull ItemStack stack, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Player player) {
        return this.getToolStats().doesSneakBypassUse();
    }

    default public boolean definition$shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (!oldStack.is(newStack.getItem())) {
            return true;
        }
        if (newStack.isDamageableItem() && oldStack.isDamageableItem()) {
            CompoundTag newTag = newStack.getTag();
            CompoundTag oldTag = oldStack.getTag();
            if (newTag != null && oldTag != null) {
                HashSet newKeys = new HashSet(newTag.getAllKeys());
                HashSet oldKeys = new HashSet(oldTag.getAllKeys());
                newKeys.remove("Damage");
                oldKeys.remove("Damage");
                newKeys.remove("Charge");
                oldKeys.remove("Charge");
                if (!newKeys.equals(oldKeys)) {
                    return true;
                }
                return !newKeys.stream().allMatch(key -> Objects.equals(newTag.get(key), oldTag.get(key)));
            }
            return newTag != null || oldTag != null;
        }
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }

    default public boolean definition$hasCraftingRemainingItem(ItemStack stack) {
        return stack.getTag() == null || !stack.getTag().getBoolean("DisallowContainerItem");
    }

    default public ItemStack definition$getCraftingRemainingItem(ItemStack stack) {
        if (!this.definition$hasCraftingRemainingItem(stack)) {
            return ItemStack.EMPTY;
        }
        stack = stack.copy();
        Player player = ForgeHooks.getCraftingPlayer();
        ToolHelper.damageItemWhenCrafting(stack, (LivingEntity)player);
        this.playCraftingSound(player, stack);
        if (stack.isEmpty()) {
            return this.getToolStats().getBrokenStack();
        }
        return stack;
    }

    default public boolean definition$shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.getCharge(oldStack) != this.getCharge(newStack)) {
            return slotChanged;
        }
        return !oldStack.equals(newStack);
    }

    default public boolean definition$onEntitySwing(LivingEntity entityLiving, ItemStack stack) {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.onEntitySwing(entityLiving, stack));
        return false;
    }

    default public boolean definition$canDestroyBlockInCreative(Level world, BlockPos pos, ItemStack stack, Player player) {
        return true;
    }

    default public int definition$getDamage(ItemStack stack) {
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        if (toolTag.contains("Damage", 3)) {
            int damage = toolTag.getInt("Damage");
            toolTag.remove("Damage");
            return damage;
        }
        return super.getDamage(stack);
    }

    default public int definition$getMaxDamage(ItemStack stack) {
        return this.getTotalMaxDurability(stack);
    }

    default public double definition$getDurabilityForDisplay(ItemStack stack) {
        int damage = stack.getDamageValue();
        int maxDamage = stack.getMaxDamage();
        if (damage == 0) {
            return 1.0;
        }
        return (double)(maxDamage - damage) / (double)maxDamage;
    }

    default public void definition$init() {
        this.getToolStats().getBehaviors().forEach(behavior -> behavior.init(this));
    }

    default public boolean definition$canPerformAction(@NotNull ItemStack stack, @NotNull ToolAction action) {
        if (this.getToolType().defaultAbilities.contains(action)) {
            return true;
        }
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (!behavior.canPerformAction(stack, action)) continue;
            return true;
        }
        return false;
    }

    default public InteractionResult definition$onItemUseFirst(ItemStack stack, UseOnContext context) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemUseFirst(stack, context) != InteractionResult.SUCCESS) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult definition$onItemUse(UseOnContext context) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            InteractionResult result = behavior.onItemUse(context);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResultHolder<ItemStack> definition$use(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.onItemRightClick(world, player, hand).getResult() != InteractionResult.SUCCESS) continue;
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.pass((Object)heldItem);
    }

    default public boolean definition$shouldOpenUIAfterUse(UseOnContext context) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (behavior.shouldOpenUIAfterUse(context)) continue;
            return false;
        }
        return true;
    }

    default public void definition$fillItemCategory(CreativeModeTab category, @NotNull NonNullList<ItemStack> items) {
        if (this.isElectric()) {
            items.add((Object)this.get(Integer.MAX_VALUE));
        } else {
            items.add((Object)this.get());
        }
    }

    default public void definition$appendHoverText(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, TooltipFlag flag) {
        CompoundTag behaviorsTag;
        Item item = stack.getItem();
        if (!(item instanceof IGTTool)) {
            return;
        }
        IGTTool tool = (IGTTool)item;
        CompoundTag tagCompound = stack.getTag();
        if (tagCompound == null) {
            return;
        }
        IGTToolDefinition toolStats = tool.getToolStats();
        if (this.isElectric()) {
            ElectricStats.addCurrentChargeTooltip(tooltip, this.getCharge(stack), this.getMaxCharge(stack), this.getElectricTier(), false);
        }
        if (!tagCompound.getBoolean("Unbreakable")) {
            int damageRemaining = tool.getTotalMaxDurability(stack) - stack.getDamageValue() + 1;
            if (toolStats.isSuitableForCrafting(stack)) {
                tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.crafting_uses", (Object[])new Object[]{FormattingUtil.formatNumbers(damageRemaining / Math.max(1, toolStats.getToolDamagePerCraft(stack)))}));
            }
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.max_uses", (Object[])new Object[]{FormattingUtil.formatNumbers(tool.getTotalMaxDurability(stack))}));
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.general_uses", (Object[])new Object[]{FormattingUtil.formatNumbers(damageRemaining)}));
        }
        if (toolStats.isSuitableForAttacking(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.attack_damage", (Object[])new Object[]{FormattingUtil.formatNumbers(2.0f + tool.getTotalAttackDamage(stack))}));
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.attack_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(4.0f + tool.getTotalAttackSpeed(stack))}));
        }
        if (toolStats.isSuitableForBlockBreak(stack)) {
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.mining_speed", (Object[])new Object[]{FormattingUtil.formatNumbers(tool.getTotalToolSpeed(stack))}));
            int harvestLevel = tool.getTotalHarvestLevel(stack);
            String harvestName = "item.gtceu.tool.harvest_level." + harvestLevel;
            if (Language.getInstance().has(harvestName)) {
                tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.harvest_level_extra", (Object[])new Object[]{harvestLevel, Component.translatable((String)harvestName)}));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.harvest_level", (Object[])new Object[]{harvestLevel}));
            }
        }
        boolean addedBehaviorNewLine = false;
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (!aoeDefinition.isZero()) {
            addedBehaviorNewLine = tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.behavior.aoe_mining", (Object[])new Object[]{aoeDefinition.column * 2 + 1, aoeDefinition.row * 2 + 1, aoeDefinition.layer + 1}));
        }
        if ((behaviorsTag = ToolHelper.getBehaviorsTag(stack)).getBoolean("RelocateMinedBlocks")) {
            if (!addedBehaviorNewLine) {
                addedBehaviorNewLine = true;
                tooltip.add(CommonComponents.EMPTY);
            }
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.behavior.relocate_mining"));
        }
        if (!addedBehaviorNewLine && !toolStats.getBehaviors().isEmpty()) {
            tooltip.add(CommonComponents.EMPTY);
        }
        toolStats.getBehaviors().forEach(behavior -> behavior.addInformation(stack, world, tooltip, flag));
        String uniqueTooltip = this.getToolType().getUnlocalizedName() + ".tooltip";
        if (Language.getInstance().has(uniqueTooltip)) {
            tooltip.add(CommonComponents.EMPTY);
            tooltip.add((Component)Component.translatable((String)uniqueTooltip));
        }
        tooltip.add(CommonComponents.EMPTY);
        Map<Enchantment, Integer> defaultEnchants = this.getDefaultEnchantments(stack);
        if (!defaultEnchants.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.default_enchantments"));
            for (Map.Entry<Enchantment, Integer> entry : defaultEnchants.entrySet()) {
                Enchantment enchant = entry.getKey();
                if (enchant == null) continue;
                tooltip.add(enchant.getFullname(entry.getValue().intValue()));
            }
        }
        tooltip.add(CommonComponents.EMPTY);
        tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.usable_as", (Object[])new Object[]{this.getToolClassNames(stack).stream().filter(s -> Language.getInstance().has("gtceu.tool.class." + s)).map(s -> Component.translatable((String)("gtceu.tool.class." + s))).collect(Component::empty, FormattingUtil::combineComponents, FormattingUtil::combineComponents)}));
        if (!tagCompound.getBoolean("Unbreakable")) {
            if (GTUtil.isShiftDown()) {
                Material material = this.getMaterial();
                ArrayList<MutableComponent> repairItems = new ArrayList<MutableComponent>();
                if (!VanillaRecipeHelper.isMaterialWood(material)) {
                    if (material.hasProperty(PropertyKey.INGOT)) {
                        repairItems.add(TagPrefix.ingot.getLocalizedName(material));
                    } else if (material.hasProperty(PropertyKey.GEM)) {
                        repairItems.add(TagPrefix.gem.getLocalizedName(material));
                    }
                }
                if (!ChemicalHelper.get(TagPrefix.plate, material).isEmpty()) {
                    repairItems.add(TagPrefix.plate.getLocalizedName(material));
                }
                if (!repairItems.isEmpty()) {
                    tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.repair_material", (Object[])new Object[]{repairItems.stream().collect(Component::empty, FormattingUtil::combineComponents, FormattingUtil::combineComponents)}));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.tooltip.repair_info"));
            }
        }
        if (this.isElectric()) {
            tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.replace_tool_head"));
        }
    }

    default public boolean definition$canApplyAtEnchantingTable(@NotNull ItemStack stack, Enchantment enchantment) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation enchantmentId = EnchantmentHelper.getEnchantmentId((Enchantment)enchantment);
        if (COFH_SMASHING_ENCHANT_ID.equals((Object)enchantmentId)) {
            return false;
        }
        if (AUTOSMELT_ENCHANT_IDS.contains(enchantmentId) && (!this.getToolStats().getAoEDefinition(stack).isZero() || ToolHelper.getBehaviorsTag(stack).contains("TreeFelling"))) {
            return false;
        }
        switch (enchantment.category) {
            case DIGGER: {
                return this.getToolStats().isSuitableForBlockBreak(stack);
            }
            case WEAPON: {
                return this.getToolStats().isSuitableForAttacking(stack);
            }
            case BREAKABLE: {
                return stack.getTag() != null && !stack.getTag().getBoolean("Unbreakable");
            }
            case VANISHABLE: {
                return true;
            }
        }
        ToolProperty property = this.getToolProperty();
        if (property == null) {
            return false;
        }
        if (!property.getEnchantments().isEmpty() && property.getEnchantments().containsKey((Object)enchantment)) {
            return true;
        }
        return this.getToolStats().isEnchantable(stack) && this.getToolStats().canApplyEnchantment(stack, enchantment);
    }

    default public void playCraftingSound(Player player, ItemStack stack) {
        if (ConfigHolder.INSTANCE.client.toolCraftingSounds && this.getSound() != null && player != null && this.canPlaySound(stack)) {
            this.setLastCraftingSoundTime(stack);
            this.playSound(player);
        }
    }

    default public void setLastCraftingSoundTime(ItemStack stack) {
        ToolHelper.getToolTag(stack).putInt("LastCraftingUse", (int)System.currentTimeMillis());
    }

    default public boolean canPlaySound(ItemStack stack) {
        return Math.abs((int)System.currentTimeMillis() - ToolHelper.getToolTag(stack).getInt("LastCraftingUse")) > 1000;
    }

    default public void playSound(Player player) {
        if (ConfigHolder.INSTANCE.client.toolUseSounds && this.getSound() != null) {
            player.level().playSound(null, player.position().x, player.position().y, player.position().z, this.getSound().getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    default public ModularUI createUI(Player player, HeldItemUIFactory.HeldItemHolder holder) {
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            IToolUIBehavior uiBehavior;
            if (!(behavior instanceof IToolUIBehavior) || !(uiBehavior = (IToolUIBehavior)behavior).openUI(player, holder.getHand())) continue;
            return uiBehavior.createUI(player, holder);
        }
        return new ModularUI((IUIHolder)holder, player);
    }

    default public Set<GTToolType> getToolClasses(ItemStack stack) {
        return new HashSet<GTToolType>(this.getToolType().toolClasses);
    }

    default public Set<String> getToolClassNames(ItemStack stack) {
        return this.getToolClasses(stack).stream().flatMap(type -> type.toolClassNames.stream()).collect(Collectors.toSet());
    }

    @Nullable
    default public ICapabilityProvider definition$initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        ArrayList<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();
        if (this.isElectric()) {
            final ElectricStats item = ElectricStats.createElectricItem(0L, this.getElectricTier());
            providers.add(new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    return item.getCapability(stack, capability);
                }
            });
        }
        for (IToolBehavior behavior : this.getToolStats().getBehaviors()) {
            if (!(behavior instanceof IComponentCapability)) continue;
            final IComponentCapability componentCapability = (IComponentCapability)((Object)behavior);
            providers.add(new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    return componentCapability.getCapability(stack, capability);
                }
            });
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ICapabilityProvider)providers.get(0);
        }
        return new CombinedCapabilityProvider(providers);
    }

    default public boolean definition$isCorrectToolForDrops(ItemStack stack, BlockState state) {
        Item item = stack.getItem();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            return ToolHelper.isToolEffective(state, gtTool.getToolClasses(stack), gtTool.getTotalHarvestLevel(stack));
        }
        return stack.getItem().isCorrectToolForDrops(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor() {
        return (itemStack, index) -> {
            Item patt41309$temp = itemStack.getItem();
            if (patt41309$temp instanceof IGTTool) {
                IGTTool item = (IGTTool)patt41309$temp;
                Material material = item.getMaterial();
                return switch (index) {
                    case -101, 0 -> {
                        if (item.getToolClasses(itemStack).contains(GTToolType.CROWBAR) && itemStack.hasTag() && ToolHelper.getToolTag(itemStack).contains("TintColor", 3)) {
                            yield ToolHelper.getToolTag(itemStack).getInt("TintColor");
                        }
                        yield -1;
                    }
                    case -111, 1 -> material.getMaterialARGB();
                    case -121, 2 -> {
                        if (material.getMaterialSecondaryARGB() != -1) {
                            yield material.getMaterialSecondaryARGB();
                        }
                        yield material.getMaterialARGB();
                    }
                    default -> -1;
                };
            }
            return -1;
        };
    }
}

